/*
 * image source fifo
 *
 * provides a cache for timed transitions
 *
 * $Id: fifo.c,v 1.7 2000/11/03 16:05:14 opencare Exp $
 *
 * Copyright (C) 2000 OpenCare (www.ocare.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#include "gfxtrans.h"

/*
 * create a fifo cache
 *
 * arg1: imgsource_t: who fills the fifo
 * ... : passed to writer
 */
imgsource_t 
gfxtrans_fifo_create(va_list ap) {
  imgsource_t fifo_source;

  /* create a fifo */
  fifo_source = (imgsource_t) malloc( sizeof(struct _imgsource_t) );
  if (fifo_source) {

    /* consume our arguments, trailing will be given to writer */
    GFXTRANS_FIFO_T(fifo_source).writer = va_arg(ap, imgsource_t);
   
    gfx_log(LOG_DEBUG, "gfxtrans_fifo_create: %p, writer is %p",
	    fifo_source, GFXTRANS_FIFO_T(fifo_source).writer);

    if (GFXTRANS_FIFO_T(fifo_source).writer) {

      /* initialize member functions */
      fifo_source->create_f = gfxtrans_fifo_create;
      fifo_source->display_f = gfxtrans_fifo_display;
      fifo_source->destroy_f = gfxtrans_fifo_destroy;

      /* initialize member datas */
      GFXTRANS_FIFO_T(fifo_source).frame[0] = gfxtrans_display_allocate(GFXTRANS_DISPLAY_ONBOARD,
									GFXTRANS_FIFO_T(fifo_source).writer->width,
									GFXTRANS_FIFO_T(fifo_source).writer->height);
      GFXTRANS_FIFO_T(fifo_source).frame[1] = gfxtrans_display_allocate(GFXTRANS_DISPLAY_ONBOARD,
									GFXTRANS_FIFO_T(fifo_source).writer->width,
									GFXTRANS_FIFO_T(fifo_source).writer->height);
      GFXTRANS_FIFO_T(fifo_source).readindex = 0;
      GFXTRANS_FIFO_T(fifo_source).writeindex = 0;
      GFXTRANS_FIFO_T(fifo_source).length = 2;

      /* ask writer to render */
      GFXTRANS_FIFO_T(fifo_source).writer->display_f(GFXTRANS_FIFO_T(fifo_source).writer,
						     GFXTRANS_FIFO_T(fifo_source).frame[0]);

      gfxtrans_display_render (GFXTRANS_FIFO_T(fifo_source).frame[0]);

      /* exit successfully */
      return fifo_source;

    } else {
      gfx_log(LOG_CRIT, "NULL writer given");
    }
  } else {
    gfx_log(LOG_CRIT, "can't malloc fifo");
  }
  return NULL;
}

/*
 * render next frame to screen
 */
gfxtrans_display_t *
gfxtrans_fifo_display(imgsource_t img_source, gfxtrans_display_t *fb) {
  int readindex = GFXTRANS_FIFO_T(img_source).readindex;
  int writeindex = GFXTRANS_FIFO_T(img_source).writeindex;

  gfx_log(LOG_DEBUG, "gfxtrans_fifo_display(%p, %p)", img_source, fb);

  /* render to screen */
  if (!fb) {
    gfxtrans_display_render(GFXTRANS_FIFO_T(img_source).frame[readindex]);
  } else {
    gfxtrans_display_render(fb);
  }

  /* ask writer to render */
  GFXTRANS_FIFO_T(img_source).writer->display_f(GFXTRANS_FIFO_T(img_source).writer,
						GFXTRANS_FIFO_T(img_source).frame[writeindex]);

  /* advance read index */
  GFXTRANS_FIFO_T(img_source).readindex = (readindex + 1) % GFXTRANS_FIFO_T(img_source).length;

  /* advance write index */
  GFXTRANS_FIFO_T(img_source).writeindex = (writeindex + 1) % GFXTRANS_FIFO_T(img_source).length;

  return NULL;
}

void
gfxtrans_fifo_destroy(imgsource_t img_source) {
  int i;
  gfx_log(LOG_DEBUG, "gfxtrans_fifo_destroy(%p)", img_source);

  for (i = 0; i < GFXTRANS_FIFO_T(img_source).length; i++) {
    gfxtrans_display_destroy(GFXTRANS_FIFO_T(img_source).frame[i]);
  }
  free(img_source);
}
