/*
 * display abstraction
 * for now, only 'ggi_directbuffer' abstracttion is provided
 * included in gfxtrans.h
 *
 * $Id: display.h,v 1.7 2000/11/03 16:02:52 opencare Exp $
 *
 * Copyright (C) 2000 OpenCare (www.ocare.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#ifndef GFXTRANS_DISPLAY_H
#define GFXTRANS_DISPLAY_H

#include <ggi/ggi.h>

typedef struct _gfxtrans_display_t gfxtrans_display_t;

struct _gfxtrans_display_t {
  int location;			/* whether in ram or vram */
  int id;			/* frame # for this display */
  ggi_visual_t visual;
  const ggi_directbuffer *fb;
  ggi_mode mode;
};

/* display allocator will get some video ram*/
#define GFXTRANS_DISPLAY_ONBOARD 0

/* display allocator will get some main ram*/
#define GFXTRANS_DISPLAY_MEMORY 1

/*
 * acquire write lock on display
 * disp: gfxtrans_display_t
 *
 * return 0 on success, otherwise < 0
 */
#define gfxtrans_lock_write_display(disp) ggiResourceAcquire(disp->fb->resource, GGI_ACTYPE_WRITE)

/*
 * acquire read lock on display
 * disp: gfxtrans_display_t
 *
 * return 0 on success, otherwise < 0
 */
#define gfxtrans_lock_read_display(disp) ggiResourceAcquire(disp->fb->resource, GGI_ACTYPE_READ)

/*
 * release lock on display
 * disp: gfxtrans_display_t
 *
 * return 0 on success, otherwise < 0
 */
#define gfxtrans_unlock_display(disp) ggiResourceRelease(disp->fb->resource)

/*
 * retrieve address of read framebuffer
 * disp: gfxtrans_display_t
 *
 * return address of read framebuffer
 */
#define gfxtrans_get_read_fb(disp) (disp->fb->read)

/*
 * retrieve address of write framebuffer
 * disp: gfxtrans_display_t
 *
 * return address of write framebuffer
 */
#define gfxtrans_get_write_fb(disp) (disp->fb->write)

/*
 * flush a display
 * disp: gfxtrans_display_t
 *
 */
#define gfxtrans_flush_display(disp) ggiFlush(disp->visual)

/*
 * visual-to-visual block copy
 * src: gfxtrans_display_t source display
 * dst: gfxtrans_display_t source display
 * sx,sy: int upper-left corner in src
 * dx,dy: int upper-left corner in dst
 * w,h: int width and height of block
 *
 * return 0 on success, otherwise an error code
 */
#define gfxtrans_blit(dst, src, sx, sy, dx, dy, w, h) \
  ggiCrossBlit(src->visual, sx, sy, w, h, dst->visual, dx, dy)


extern int gfxtrans_display_init(int width, int height);
extern void gfxtrans_display_destroy(gfxtrans_display_t *disp);
extern gfxtrans_display_t *gfxtrans_display_allocate(int where, int width, int height);
extern void gfxtrans_display_exit();
extern void gfxtrans_display_render(gfxtrans_display_t *disp);

#endif /* GFXTRANS_DISPLAY_H */
