/*
 * common utility functions
 *
 * $Id: common.c,v 1.7 2000/10/23 11:11:43 opencare Exp $
 *
 * Copyright (C) 2000 OpenCare (www.ocare.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#include "gfxtrans.h"
#include <string.h>
/*
 * get transition type from its name
 *
 * name: name of the transition
 *
 * return type of wanted transition
 */
img_source_type_t
gfxtrans_get_function_by_name(char *name) {
  if (strncmp(name, "timed", 6)) {
    return IMGSOURCE_TIMED;
  } else {
    if (strncmp(name, "fifo", 5)) {
      return IMGSOURCE_FIFO;
    } else {
      if (strncmp(name, "targa", 6)) {
	return IMGSOURCE_TARGA;
      } else {
	if (strncmp(name, "jpeg", 5)) {
	  return IMGSOURCE_JPEG;
	} else {
	  if (strncmp(name, "blocky", 7)) {
	    return IMGSOURCE_BLOCKY;
	  } else {
	    /* unknown transition */

	    return IMGSOURCE_UNKNOWN;
	  }
	}
      }
    }
  }
}

/*
 * create a transition
 *
 * name: name of the transition
 * ... : arguments for the transition
 */
imgsource_t 
gfxtrans_create(img_source_type_t transition, ...) {
  imgsource_t result;
  va_list ap;

  va_start(ap, transition);

  switch (transition) {
  case IMGSOURCE_TIMED:
    result = gfxtrans_timed_create(ap);
    break;
  case IMGSOURCE_FIFO:
    result = gfxtrans_fifo_create(ap);
    break;
  case IMGSOURCE_TARGA:
/*      result = gfxtrans_targa_create(ap); */
    break;
  case IMGSOURCE_JPEG:
    result = gfxtrans_jpeg_create(ap);
    break;
  case IMGSOURCE_BLOCKY:
    result = gfxtrans_blocky_create(ap);
    break;
  case IMGSOURCE_SCALED:
    result = gfxtrans_scaled_create(ap);
    break;
/*    case IMGSOURCE_SCALED_FAST: */
/*      result = gfxtrans_scaled_fast_create(ap); */
/*      break; */
  case IMGSOURCE_UNKNOWN:
  default:
    result = NULL;
  }

  if (result) {
    result->ref_count = 0;
    result->type = transition;
  }
  va_end(ap);
  return result;
}

/*
 * display a transition
 * img_source: which image to display
 * fb: if not NULL, where to display
 *     if NULL, display to internal framebuf
 *
 * returns a drawn display
 */
gfxtrans_display_t *
gfxtrans_display(imgsource_t img_source, gfxtrans_display_t *fb) {
  return img_source->display_f(img_source, fb);
}

/*
 * destroy a transition
 */
void
gfxtrans_destroy (imgsource_t img_source) {
  if (img_source) {
    if (img_source->destroy_f) {
      img_source->destroy_f(img_source);
    } else {
      gfx_log(LOG_CRIT, "destroy_f not bound");
    }
  } else {
    gfx_log(LOG_CRIT, "destroying NULL object");
  }
}
