/*****************************************************************************/
/* File: header.h                                                            */
/* Author: David Chatenay                                                    */
/* Last Modified: Mon Jan 20 1997                                            */
/*                                                                           */
/* Routines to manipulate file headers containing vital informations.        */
/*****************************************************************************/
#ifndef MY_HEADER_H
#define MY_HEADER_H


/* The signature of libcrunched files */
#define LIBCRUNCH_SIGNATURE "CWJC"


/* The different types of compression method */
/***  THIS MUST BE COHERENT WITH CRUNCH.H  ***/
#define METHOD_UNKNOWN  0
#define METHOD_HUFFMAN  1
#define METHOD_AD_HUFF  2
#define METHOD_LZW      3
#define METHOD_LZSS     4
#define METHOD_INVALID  5

/* Error return values for file checking */
/***  THIS MUST BE COHERENT WITH CRUNCH.H  ***/
#define CHECK_ERROR   -1  /* File I/O error    */
#define CHECK_INVALID -2  /* Invalid signature */
#define CHECK_CORRUPT -3  /* Corrupted file    */
#define CHECK_CRC     -4  /* CRC check error   */
#define CHECK_VERSION -5  /* Version mismatch  */


/* The version structure */
typedef struct {
    byte Major;
    byte Minor;
    byte Revision;
} Version;


/* The compressed file header structure */
typedef struct {
    byte  Signature[4];   /* The signature of libcrunch */
    dword OriginalLength; /* Length of original file */
    dword CrunchedLength; /* Length of crunched file */
    dword CRC;            /* CRC32  of crunched file */
    byte  Method;         /* Compression method number */
    Version V;            /* Version of crunch library */
    word ExtensionLength; /* Length of header */
    word HeaderCrc;       /* CRC of header */
} CrunchHeader;


int ReadHeader(int fd, CrunchHeader *h);
int ComputeHeader(int fd, CrunchHeader *h, byte method);
int WriteHeader(int fd, CrunchHeader *h);
int WriteLength(CrunchHeader *h, Buffer *bin, Buffer *bout);
int SeekRealPosition(int fd, CrunchHeader *h, off_t offset);
int CheckFileHeader(int fd, CrunchHeader *h);

/* Those are exported in the library */
int CheckFile(int fd);
byte IdentifyMethod(int fd);


#endif
