/*****************************************************************************/
/* File: hash.c                                                              */
/* Author: David Chatenay                                                    */
/* Last Modified: Tue Jan 07 1997                                            */
/*                                                                           */
/* Implementation of simple hash functions, to generate keys...              */
/*****************************************************************************/
#include "common.h"
#include "crunch.h"


/* The simple hash function */
word SimpleHash(byte *s, long l)
{
    word h=0;
    long i;
    
    for (i=0; i<l; i++)
        h = (word)(h * HASH_VALUE + s[i]);
 
    return (h % HASH_SIZE);
}


/* The raw hash function */
dword RawHash(byte *s, long l)
{
    dword h=0;
    long i;

    for (i=0; i<l; i++)
        h = ~((h << 1) ^ s[i]);

    return h;
}
