/*****************************************************************************/
/* File: common.h                                                            */
/* Author: David Chatenay                                                    */
/* Last Modified: Mon Dec 16 1996                                            */
/*                                                                           */
/* Standard type redefinitions, one and for all...                           */
/*****************************************************************************/
#ifndef MY_COMMON_H
#define MY_COMMON_H


#include <sys/types.h>

/* TYPES */
typedef unsigned char bool;


/* DEFINES */
#ifndef True
#define True  1
#endif
#ifndef False
#define False 0
#endif
#ifndef true
#define true  True
#endif
#ifndef false
#define false False
#endif
#ifndef TRUE
#define TRUE True
#endif
#ifndef FALSE
#define FALSE False
#endif
/* Ansi escape sequences */
#define BOLD "\033[1m"
#define REVR "\033[7m"
#define UNDR "\033[4m"
#define NORM "\033[m"


/* ERRORS AND WARNINGS */
#define ERROR(s)   (void)fprintf(stderr, "Error:" s "\n");
#define WARNING(s) (void)fprintf(stderr, "Warning:" s "\n");


/* CONDITIONNAL TESTINGS */
/*** True Or Return (Int) */
#define TORI(f)  if ((f) == -1) return -1;
/*** True Or Return (Pointer) */
#define TORP(f)  if ((f) == NULL) return -1;


/* DEBUG */
#ifdef MY_DEBUG
#define DEBUG0(m)          (void)fprintf(stderr,BOLD m NORM)
#define DEBUG1(m,x)        (void)fprintf(stderr,BOLD m NORM,x)
#define DEBUG2(m,x,y)      (void)fprintf(stderr,BOLD m NORM,x,y)
#define DEBUG3(m,x,y,z)    (void)fprintf(stderr,BOLD m NORM,x,y,z)
#else
#define DEBUG0(m)
#define DEBUG1(m,x)
#define DEBUG2(m,x,y)
#define DEBUG3(m,x,y,z)
#endif


/* VARIABLES */
extern u_char Mask[9], UMask[9], XMask[9], RMask[9];


/* FUNCTIONS */
extern int OpenR(char *name, int perm);
extern int OpenW(char *name, int perm);
extern int Read(int fd, void *p, int s);
extern int ReadAbs(int fd, void *p, int s);
extern int Write(int fd, void *p, int s);
extern int Seek(int fd, off_t offset, int whence);
extern off_t Tell(int fd);
extern void *Malloc(size_t t);


#endif
