/*****************************************************************************/
/* File: buffer.h                                                            */
/* Author: David Chatenay                                                    */
/* Last Modified: Tue Jan 14 1997                                            */
/*                                                                           */
/* Very simple functions to manipulate buffered I/Os with byte and bit manip */
/* functions. The Code structure eases the bit manipulations in the file.    */
/*****************************************************************************/
#ifndef MY_BUFFER_H
#define MY_BUFFER_H


/* DEFINES */
/* This is an import from stdio.h */
#define BUFF_LEN BUFSIZ
 
 
/* STRUCTURES */
/* The buffer structure */
typedef struct {
    byte buffer[BUFF_LEN];
    int buff_length;
    int byte_count;
    int bit_count;
    dword total;
    int fd;
} Buffer;


/* FUNCTIONS */
Buffer *NewBuffer(int fd);
#define KillBuffer(b)   { free(b); }
#define ResetBuffer(b)  { (void)memset((b)->buffer, 0, BUFF_LEN); \
			  (b)->byte_count = (b)->bit_count = 0; }
#define ReadBuffer(b)   { TORI((b)->buff_length=Read((b)->fd,(b)->buffer, \
						     BUFF_LEN));\
			  (b)->byte_count = (b)->bit_count = 0; \
			  (b)->total += (b)->buff_length; }
#define WriteBuffer(b)  { TORI(Write((b)->fd, (b)->buffer, (b)->byte_count)); \
		          (b)->total += (b)->byte_count; }
#define FlushBuffer(b)  { if ((b)->bit_count != 0) (b)->byte_count++; \
			  WriteBuffer(b); ResetBuffer(b); }


#define Put(b, c)       { b->buffer[(b)->byte_count]=(c); (b)->byte_count++; \
			    if ((b)->byte_count==BUFF_LEN) \
                            { WriteBuffer(b); (b)->byte_count=0; } }
#define Get(b)          ((b)->buffer[(b)->byte_count]); \
                        (b)->byte_count++; \
                        if ((b)->byte_count == (b)->buff_length) ReadBuffer(b);


#define IncrCountO(b)   { (b)->byte_count++; \
                          if ((b)->byte_count == BUFF_LEN) { \
			      WriteBuffer(b); ResetBuffer(b); } }
#define IncrCountI(b)   { (b)->byte_count++; \
                         if ((b)->byte_count == (b)->buff_length) \
                             ReadBuffer(b); }


int AddCode(Code *c, Buffer *b);
int ReadCode(Code *c, Buffer *b);
byte CodeLength(dword d);

int AddCodeToBlock(Code *c, byte *block, dword size, dword *bytec, word *bitc);
int ReadCodeFromBlock(Code *c, byte *block, dword size, dword *bytec,
		      word *bitc);


#endif
