// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#include "arch.H"
#if defined(HAVE_FPU_CONTROL_H)
#  include <fpu_control.h>
#elif defined(HAVE_I386_FPU_CONTROL_H)
#  include <i386/fpu_control.h>
#endif

void
setup_fpu()
{
    __setfpucw(  _FPU_RC_NEAREST
	       | _FPU_SINGLE     // Use single precision internally
	       | _FPU_MASK_IM    // Ignore invalid instructions
	       | _FPU_MASK_DM    // Ignore denormalized operations
	       | _FPU_MASK_ZM    // Ignore divide by zero
	       | _FPU_MASK_PM    // Ignore precision errors (?)
	       | _FPU_MASK_OM    // Ignore overflow
	       | _FPU_MASK_UM    // Ignore underflow
	       );

    // It is important to use low precision arithmetic internally to
    // the FPU, because we are just using floats externally.  This way
    // we get consistent results whether or not the compiler decides
    // to leave some results sitting inside the FPU.  Also, complex FP
    // instructions are faster in 8+24 bit mode.
}

void
restore_fpu()
{
    __setfpucw( _FPU_DEFAULT );
}




