// Copyright (C) 1997 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

// This file is contributed by
// Markus F.X.J. Oberhumer <markus.oberhumer@jk.uni-linz.ac.at>


#include <Lib3d/PrimitiveModelBuilder.H>


uint
PrimitiveModelBuilder::addCube( float width, float height, float depth,
                                int face )
{
    uint v[8];
    const uint r1 = (uint) (~0);
    const uint r2 = (uint) (~0);

    float w = width / 2;
    float h = height / 2;
    float d = depth / 2;

    // Add the vertices in
    v[0] = addVertex( 0 - w, 0 - h, 0 - d );
    v[1] = addVertex( width - w, 0 - h, 0 - d );
    v[2] = addVertex( 0 - w, height - h, 0 - d );
    v[3] = addVertex( width - w, height - h, 0 - d );
    v[4] = addVertex( 0 - w, height - h, depth - d );
    v[5] = addVertex( width - w, height - h, depth - d );
    v[6] = addVertex( width - w, 0 - h, depth - d );
    v[7] = addVertex( 0 - w, 0 - h, depth - d );

    // Add the 6 outside polygons (12 triangles)
    if ( face == FACE_BOTH || face == FACE_OUTSIDE )
    {
	if (addTriangle(v[2],v[1],v[0]) == r1) return r2;
	if (addTriangle(v[2],v[3],v[1]) == r1) return r2;
	if (addTriangle(v[3],v[6],v[1]) == r1) return r2;
	if (addTriangle(v[3],v[5],v[6]) == r1) return r2;
	if (addTriangle(v[2],v[4],v[5]) == r1) return r2;
	if (addTriangle(v[2],v[5],v[3]) == r1) return r2;
	if (addTriangle(v[7],v[4],v[0]) == r1) return r2;
	if (addTriangle(v[0],v[4],v[2]) == r1) return r2;
	if (addTriangle(v[6],v[5],v[4]) == r1) return r2;
	if (addTriangle(v[6],v[4],v[7]) == r1) return r2;
	if (addTriangle(v[7],v[0],v[1]) == r1) return r2;
	if (addTriangle(v[7],v[1],v[6]) == r1) return r2;
    }

    // Add the 6 inside polygons (12 triangles)
    if ( face == FACE_BOTH || face == FACE_INSIDE )
    {
	if (addTriangle(v[2],v[0],v[1]) == r1) return r2;
	if (addTriangle(v[2],v[1],v[3]) == r1) return r2;
	if (addTriangle(v[3],v[1],v[6]) == r1) return r2;
	if (addTriangle(v[3],v[6],v[5]) == r1) return r2;
	if (addTriangle(v[2],v[5],v[4]) == r1) return r2;
	if (addTriangle(v[2],v[3],v[5]) == r1) return r2;
	if (addTriangle(v[7],v[0],v[4]) == r1) return r2;
	if (addTriangle(v[0],v[2],v[4]) == r1) return r2;
	if (addTriangle(v[6],v[4],v[5]) == r1) return r2;
	if (addTriangle(v[6],v[7],v[4]) == r1) return r2;
	if (addTriangle(v[7],v[1],v[0]) == r1) return r2;
	if (addTriangle(v[7],v[6],v[1]) == r1) return r2;
    }

    return v[0];
}


uint
PrimitiveModelBuilder::addCube ( float size, int face )
{
    return addCube( size, size, size, face );
}

