// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#include <Lib3d/internals/HrTimer.H>
#include <string.h>

#if defined(__DJGPP__)
const double HrTimer::PerSecond = 1.0/double(UCLOCKS_PER_SEC);
#else
const double HrTimer::PerSecond = 1.0/1000000.0;
#endif

HrTimer::HrTimer( const char *_name, const char *_operation )
    : total(0),
      count(0),
      running(false)
{
    name = new char[strlen(_name)+1];
    strcpy(name, _name);

    operation = new char[strlen(_operation)+1];
    strcpy(operation, _operation);
}

HrTimer::~HrTimer() 
{
    delete [] name;
    delete [] operation;
}

ostream &operator<<( ostream &out, const HrTimer &timer )
{
    out.precision(4);

    if (timer.count > 1 && timer.total != 0.0) {
	out << timer.name << ": " 
	    << timer.count << " in "
	    << setw(6) << (timer.total * HrTimer::PerSecond)
	    << " seconds (" 
	    << (timer.count / (timer.total * HrTimer::PerSecond))
	    << " " << timer.operation << " per second)";
    } else {
	out << timer.name << ": " 
	    << setw(6) << (timer.total * HrTimer::PerSecond)
	    << " seconds";
    }
    return out;
}

 
double
HrTimer::getElapsedSeconds() const
{ 
    return total * HrTimer::PerSecond;
}








