// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#include <Lib3d/internals/Array.H>
#include <Lib3d/internals/Debuggable.H>
#include <stdlib.h>

voidArray::voidArray( uint elemSize, uint initialNr )
    : elemSize(elemSize),
      max(initialNr),
      nr(0)
{ 
    if ((block = (char *)malloc( elemSize * max )) == 0) {
	err() << "Malloc failed" << endlog;
	abort();
    }
}

voidArray::~voidArray()
{
    if (block != 0) free(block);
}

char *
voidArray::expand( uint idx )
{
    if (idx+1 > nr) nr = idx+1;
    if (idx < max) return block + (idx * elemSize); 
    while((max *= 2) < idx);

    if ((block = (char *)realloc( block, max * elemSize )) == 0) {
	err() << "Realloc failed" << endlog;
	abort();
    }
    return block + (idx * elemSize); 
}

char *
voidArray::next( uint &idx )
{
    idx = nr++;
    if (nr < max) return block + (idx * elemSize); 
    max *= 2;

    if ((block = (char *)realloc( block, max * elemSize )) == 0) {
	err() << "Realloc failed" << endlog;
	abort();
    }
    return block + (idx * elemSize); 
}

char *
voidArray::next()
{
    int idx = nr++;
    if (nr < max) return block + (idx * elemSize); 
    max *= 2;

    if ((block = (char *)realloc( block, max * elemSize )) == 0) {
	err() << "Realloc failed" << endlog;
	abort();
    }
    return block + (idx * elemSize); 
}

void
voidArray::truncate( uint idx )
{
    if (idx < nr) {
	nr = idx;
    }
}
    
char *
voidArray::duplicate()
{
    char *tmp = new char[nr * elemSize];
    memcpy(tmp, block, nr * elemSize);
    return tmp;
}


void 
voidArray::sort(int (*compar)(const void *, const void *))
{
    qsort(block, nr, elemSize, compar);
}






