/**
 * $Id: sphere.cc,v 1.2 1996/08/31 07:04:00 keithw Exp $
 *
 * (c)1996 Hermetica. Written by Alligator Descartes <descarte@hermetica.com>
 *
 * Tesselates a sphere. There are two methods of tesselation here:
 *
 * 	Geodesic: Generates a sphere of triangles according to geodesic tiling
 * 	Longitudinal: Generates a sphere of 'stripes'
 *
 */
/*
 * Distributed under the Artistic Licence.  This file is not a part of lib3d.
 * See the file LICENCE in this directory.
 */

#ifdef PTHREADS
#include <pthread.h>
#endif

#include <Lib3d/ModelBuilder.H>
#include <Lib3d/Model.H>
#include <Primitive/Primitive.H>
#include <stdio.h>
#include <math.h>
#if !defined(PI) && defined(M_PI)
#  define PI	M_PI
#endif

// static const char *rcsId = "$Id: sphere.cc,v 1.2 1996/08/31 07:04:00 keithw Exp $";

extern Model * _createLongitudinalTriangular( primitive_orient_t, float, float );
extern Model * _createLongitudinalPolygonal( primitive_orient_t, float, float );

Model *
createSphere( sphere_type_t type, tesselate_type_t ttype, 
              primitive_orient_t culling, 
              float radius, float granularity ) {

    if ( type == GEODESIC ) {
//        _createGeodesic( 1, granularity );
      }
    if ( type == LONGITUDINAL ) {
        if ( ttype == TRIANGULAR )
            return _createLongitudinalPolygonal( culling, radius, granularity );
        if ( ttype == POLYGONAL )
            return _createLongitudinalTriangular( culling, radius, granularity ); 
      }
    /** Shouldn't ever get here */
    return NULL;
  }

Model *
_createLongitudinalTriangular( primitive_orient_t culling, 
                               float radius, float granularity ) {

    printf( "createSphere: longitudinal\tradius: %f\tgranularity: %f\n",
            radius, granularity );


    ModelBuilder mb;
    mb.startModel();
    mb.calculatePolygonNormals();
    mb.calculateVertexNormals();
    mb.setPolygonMaterial( 0 );

    uint *modelVertices = new uint[( 7 * granularity ) + 2];

    modelVertices[0] =
        mb.addVertex( 0, 0, -radius );
    modelVertices[1] =
        mb.addVertex( 0, 0, radius );

    for ( int m = -3 ; m <= 3 ; m++ ) {
        double tilt = m * 22.5;

        for ( int p = 0; p < granularity ; p++ ) {
            double ang = p * 360 / granularity;
            double radAngle = ( ( ang ) / 180 ) * PI;
            double tiltAngle = ( ( tilt ) / 180 ) * PI;

            double x = cos( radAngle ) * cos( tiltAngle ) * radius;
            double y = sin( radAngle ) * cos( tiltAngle ) * radius;
            double z = sin( tiltAngle ) * radius;

            modelVertices[(int)( ( ( m + 3 ) * granularity ) + p ) + 2] =
                mb.addVertex( (float)x, (float)y, (float)z );
          }
      }

    /** Add the side polygons in */
    for ( int m = -3 ; m < 3 ; m++ ) {
        int ms = (int)( ( m + 3 ) * granularity + 2 );

        for ( int p = 0 ; p < granularity ; p++ ) {
            if ( culling == FACE_BOTH || culling & FACE_OUTSIDE ) {
                uint *polyVertices = new uint[3];
                polyVertices[0] = modelVertices[ms + p];
                polyVertices[1] = modelVertices[(int)( ms + granularity + p )];
                polyVertices[2] = modelVertices[(int)( ms + granularity + ((p+1)%18) )];
                mb.addPolygon( 3, polyVertices );
                delete polyVertices;

                polyVertices = new uint[3];
                polyVertices[0] = modelVertices[(int)( ms + p )];
                polyVertices[1] = modelVertices[(int)( ms + granularity + ((p+1)%18) )];
                polyVertices[2] = modelVertices[(int)( ms + ((p+1) % (int)granularity ) )];
                mb.addPolygon( 3, polyVertices );
                delete polyVertices;
              }
            if ( culling == FACE_BOTH || culling & FACE_INSIDE ) {
                uint *polyVertices = new uint[3];
                polyVertices[0] = modelVertices[ms + p];
                polyVertices[1] = modelVertices[(int)( ms + granularity + ((p+1)%18) )];
                polyVertices[2] = modelVertices[(int)( ms + granularity + p )];
                mb.addPolygon( 3, polyVertices );
                delete polyVertices;

                polyVertices = new uint[3];
                polyVertices[0] = modelVertices[(int)( ms + p )];
                polyVertices[1] = modelVertices[(int)( ms + ((p+1) % (int)granularity ) )];
                polyVertices[2] = modelVertices[(int)( ms + granularity + ((p+1)%18) )];
                mb.addPolygon( 3, polyVertices );
                delete polyVertices;
              }
          }
      }

    /** Add the capping polygons */
    for ( int p = 0 ; p < granularity ; p++ ) {
        /** One end */
//        uint *polyVertices = new uint[3];
//        polyVertices[0] = modelVertices[3];
//        polyVertices[1] = modelVertices[0];
//        polyVertices[2] = modelVertices[p+2];
//        mb.addPolygon( 3, polyVertices );
//        delete polyVertices;

//        polyVertices = new uint[3];
//        polyVertices[0] = modelVertices[0];
//        polyVertices[1] = modelVertices[p+2];
//        polyVertices[2] = modelVertices[(int)( ((p+1) % (int)granularity ) + 2 )];
//        mb.addPolygon( 3, polyVertices );
//        delete polyVertices;

        /** The other end */
//        polyVertices = new uint[3];
//        polyVertices[0] = modelVertices[4];
//        polyVertices[1] = modelVertices[1];
//        polyVertices[2] = modelVertices[(int)(((p+1)%(int)granularity)+(( 7 * (int)granularity ) - granularity + 2))];
//        mb.addPolygon( 3, polyVertices );
//        delete polyVertices;

//        polyVertices = new uint[3];
//        polyVertices[0] = modelVertices[1];
//        polyVertices[1] = modelVertices[(int)(((p+1)%(int)granularity)+((7 * (int)granularity ) - granularity + 2))];
//        polyVertices[2] = modelVertices[(int)( p + ((7 * (int)granularity ) - granularity + 2))];
//        mb.addPolygon( 3, polyVertices );
//        delete polyVertices;
      }

    return mb.endModel();
  }

Model *
_createLongitudinalPolygonal( primitive_orient_t culling, 
                              float radius, float granularity ) {

    printf( "createSphere ( polygonal ): longitudinal\tradius: %f\tgranularity: %f\n",
            radius, granularity );

    ModelBuilder mb;
    mb.startModel();
    mb.calculatePolygonNormals();
    mb.calculateVertexNormals();
    mb.setPolygonMaterial( 0 );

    uint *modelVertices = new uint[( 7 * granularity ) + 2];

    modelVertices[0] =
        mb.addVertex( 0, 0, -radius );
    modelVertices[1] =
        mb.addVertex( 0, 0, radius );

    for ( int m = -3 ; m <= 3 ; m++ ) {
        double tilt = m * 22.5;

        for ( int p = 0; p < granularity ; p++ ) {
            double ang = p * 360 / granularity;
            double radAngle = ( ( ang ) / 180 ) * PI;
            double tiltAngle = ( ( tilt ) / 180 ) * PI;

            double x = cos( radAngle ) * cos( tiltAngle ) * radius;
            double y = sin( radAngle ) * cos( tiltAngle ) * radius;
            double z = sin( tiltAngle ) * radius;

            modelVertices[(int)( ( ( m + 3 ) * granularity ) + p ) + 2] =
                mb.addVertex( (float)x, (float)y, (float)z );
          }
      }

    /** Add the side polygons in */
    for ( int m = -3 ; m < 3 ; m++ ) {
        int ms = (int)( ( m + 3 ) * granularity + 2 );

        for ( int p = 0 ; p < granularity ; p++ ) {
            if ( culling == FACE_BOTH || culling & FACE_OUTSIDE ) {
                uint *polyVertices = new uint[4];
                polyVertices[0] = modelVertices[ms + p];
                polyVertices[1] = modelVertices[(int)( ms + granularity + p )];
                polyVertices[2] = modelVertices[(int)( ms + granularity + ((p+1)%(int)granularity) )];
                polyVertices[3] = modelVertices[(int)( ms + ((p+1) % (int)granularity ) )];
                mb.addPolygon( 4, polyVertices );
                delete polyVertices;
              }
            if ( culling == FACE_BOTH || culling & FACE_INSIDE ) {
                uint *polyVertices = new uint[3];
                polyVertices[0] = modelVertices[ms + p];
                polyVertices[1] = modelVertices[(int)( ms + granularity + p )];
                polyVertices[2] = modelVertices[(int)( ms + granularity + ((p+1)%(int)granularity) )];
                polyVertices[3] = modelVertices[(int)( ms + ((p+1) % (int)granularity ) )];
                mb.addPolygon( 4, polyVertices );
                delete polyVertices;
              }
          }
      }

    /** Add the capping polygons */
    for ( int p = 0 ; p < granularity ; p++ ) {
        /** One end */
//        uint *polyVertices = new uint[3];
//        polyVertices[0] = modelVertices[3];
//        polyVertices[1] = modelVertices[0];
//        polyVertices[2] = modelVertices[p+2];
//        mb.addPolygon( 3, polyVertices );
//        delete polyVertices;

//        polyVertices = new uint[3];
//        polyVertices[0] = modelVertices[0];
//        polyVertices[1] = modelVertices[p+2];
//        polyVertices[2] = modelVertices[(int)( ((p+1) % (int)granularity ) + 2 )];
//        mb.addPolygon( 3, polyVertices );
//        delete polyVertices;

        /** The other end */
//        polyVertices = new uint[3];
//        polyVertices[0] = modelVertices[4];
//        polyVertices[1] = modelVertices[1];
//        polyVertices[2] = modelVertices[(int)(((p+1)%(int)granularity)+(( 7 * (int)granularity ) - granularity + 2))];
//        mb.addPolygon( 3, polyVertices );
//        delete polyVertices;

//        polyVertices = new uint[3];
//        polyVertices[0] = modelVertices[1];
//        polyVertices[1] = modelVertices[(int)(((p+1)%(int)granularity)+((7 * (int)granularity ) - granularity + 2))];
//        polyVertices[2] = modelVertices[(int)( p + ((7 * (int)granularity ) - granularity + 2))];
//        mb.addPolygon( 3, polyVertices );
//        delete polyVertices;
      }

    return mb.endModel();
  }
