// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef TextureClass
#define TextureClass

#include <Lib3d/internals/types.H>

class Texture
{
public:
    Texture(Colour *buffer, int size); // buffer must be 2^size by 2^size.
    ~Texture();

    const Colour *getBuffer() const { return buffer; }
    int getDimension() const { return dimension; }
    int getSize() const { return size; }
    int getMask() const { return mask; }

private:
    Colour *buffer;
    int dimension;		// 2^size
    int size;
    int mask;			// (2^size)-1
};


#endif


