// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef FileDeviceClass
#define FileDeviceClass

#include <Lib3d/Device.H>

class FileDevice : public Device
{
public:
    ~FileDevice();
    
    // Get a list of known filetypes for interactive selection.
    // create() takes an index into array as its first parameter.
    //
    static const char **getFileTypeArray( int &nr );
    static FileDevice *create( int idx, uint, uint, uint ); 

    virtual const char *getFileType() const = 0;
    virtual const char *getFileGlob() const { return "*"; }

    virtual bool openFile( const char * ) = 0; 
    virtual void closeFile() = 0; 

    const char *getFileName() const { return(filename); }

protected:
    FileDevice( uint, uint, uint );
    FileDevice( Exemplar );

    int estimateSpeed() const { return 0; }
    static void registerChildClass( FileDevice * );
    virtual FileDevice *cloneFileDevice( uint, uint, uint ) = 0;

    Device *clone(uint, uint, uint) { return 0; }

protected:
    char *filename;

private:
    static PointerArray<FileDevice> *children;
    static const char **filetypes;
};

#endif








