
// This program demonstrates how to bypass Lib3d's platform
// independence and get at the direct Xlib interface.

// Do this if you have already committed to X windows for some reason and
// you don't mind a small porting effort for other platforms.

// See also motif/* for a more complete treatment of X issues.

#include <Lib3d/Lib3d.H>
#include <Lib3d/Devices/XDevice.H>
#include <X11/Xlib.h>
#include <iostream.h>
#include <fstream.h>

void createSomeWindow();
void setupHierarchy();
void renderMadly();

Viewport *viewport;
World *world;
Model *model;
Matrix34 transform;
Matrix34 increment;

Window window;
Display *display;

int
main()
{
    setupHierarchy();
    createSomeWindow();

    XMapWindow(display, window);

    // You will probably want to use XtWindow() and XtDevice() to get
    // these parameters from a particular widget, if you are using
    // Xt.

    viewport = Viewport::create(XDevice::create(display, window));
    if (!viewport) {
	cout << "Couldn't create viewport" << endl;
	exit(1);
    }
	
    // We don't have an integration between X events and Lib3d
    // rendering.  (Although one is in the works - see testmouse.cc)
    // Simple schemes include using timers, work processes
    // or actions/callbacks to trigger frame-at-a-time rendering...

    renderMadly();		

    // ... but we just go for it.
}


void 
setupHierarchy()
{
    ModelBuilder ob;
    ifstream in("../models/teapot.geom");
    if (in.bad()) {
	cerr << "Couldn't open teapot.geom" << endl;
	exit(-1);
    }
    ob.startModel();
    ob.readGeom( in );
    model = ob.endModel();

    world = new World;
    world->adopt(model);

    Camera *camera = new Camera(*world);
    transform.setTranslation(0,-1,-10);
    camera->setTransform(transform);
    camera->setParameters(1,100,15,1);
    world->setActiveCamera( *camera );

    Vector3 colour(1,1,1);   
    Vector3 direction(0,1,.5);
    Light *light = new Light(*world);
    light->setParameters(colour, colour, direction);
    world->registerLight( *light );

    transform.setIdentity();
    model->setTransform(transform);
}


// If you are just browsing, understand that Lib3d will ordinarily
// create a window for you.  Creating one yourself like this is
// optional, to demonstrate how we can use a particular window if we
// really want to.  This will most often be the case if you are trying
// to integrate Lib3d with an Xt based program - with widgets,
// scrollbars and such.

void
createSomeWindow()
{
    if ((display = XOpenDisplay(NULL)) == 0) {
	cout << "Unable to open display.\n" << endl;
	exit(2);
    }

    window = XCreateSimpleWindow(display, 
				 DefaultRootWindow(display),
				 0,  0, 
				 300, 250,
				 2,
				 BlackPixel(display, DefaultScreen(display)),
				 BlackPixel(display, DefaultScreen(display)));

    XSizeHints size;
    size.flags = PSize;
    size.width = 300;
    size.height = 250;
    char *argv[2] = { (char *)"XDevice", 0 };
    XSetWMProperties(display, window, 0, 0, argv, 1, &size, 0, 0);
}



void
renderMadly()
{
    // Could use Xlib calls to get pointer postion and use this to drive
    // an arcBall style viewer.  If you wanted to.

    transform.setRotation(180, 1,0,0);
    increment.setRotation((4.56), 1, 1, 1);

    for ( int i = 0 ; i < 1000 ; i++ ) {
	transform.premul(increment);
	model->setTransform(transform);
	world->renderHierarchy( *viewport );
	viewport->swapBuffers();
    }
}





