#include <Lib3d/Viewport.H>
#include <Lib3d/ColourRamp.H>
#include <iostream.h>
#include <unistd.h>

#define XMAX 320
#define YMAX 200

main(int argc, char *argv[])
{
    Viewport *viewport = Viewport::create(Device::create(XMAX, YMAX, 8));
    if (!viewport) {
	cout << "Failed to create viewport" << endl;
	exit(1);
    }

    SmoothPipelineData v[3];
    SmoothPipelineData *dv[3] = { &v[0], &v[1], &v[2] };

    
    int flag = 0;
    if (argc == 2) {
	if (strcmp(argv[1], "tri") == 0) flag = 1;
	if (strcmp(argv[1], "poly") == 0) flag = 2;
    }
    

    dv[0]->device.v[X] = 5;
    dv[0]->device.v[Y] = 5;
    dv[0]->device.v[Z] = 1000;
    dv[0]->intensity = 255;

    dv[1]->device.v[X] = 5;
    dv[1]->device.v[Y] = 100;
    dv[1]->device.v[Z] = 1000;
    dv[1]->intensity = 255*255;

    dv[2]->device.v[X] = 75;
    dv[2]->device.v[Y] = 50;
    dv[2]->device.v[Z] = 30000;
    dv[2]->intensity = 15*255;

    cout << "Swapping buffers:" << endl;
    viewport->swapBuffers();
    cout << "Sleeping: " << endl;
    sleep(1);

    cout << "Preparing colour ramp:" << endl;

    ColourRamp r1;
    Vector3 amb(0.0, 0.1, 0.0);
    Vector3 dif(0.8, 1.0, 0.8);
    amb.scale(255);
    dif.scale(255);
    r1.build(*viewport, amb, dif);

    Colour c1, c2;

    if (0 && flag == 1) {
	c1 = r1.getColour(32);   // 12%
	c2 = r1.getColour(255);  // 100%
    } else {
	c2 = r1.getColour(32);   // 12%
	c1 = r1.getColour(255);  // 100%
    } 


    // viewport->smoothPolygonZb(3, dv, r1);

    if (flag==1)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);
    viewport->flatTriangleZb((PipelineData *const*)dv, c1);
    if (flag==2)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);

    dv[0]->device.v[X] = 100;
    dv[0]->device.v[Y] = 5;
    dv[0]->device.v[Z] = 1000;

    dv[2]->device.v[X] = 100;
    dv[2]->device.v[Y] = 100;
    dv[2]->device.v[Z] = 1000;

    dv[1]->device.v[X] = 50;
    dv[1]->device.v[Y] = 50;
    dv[1]->device.v[Z] = 30000;

    if (flag==1)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);
    viewport->flatTriangleZb((PipelineData *const*)dv, c1);
    if (flag==2)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);

    dv[0]->device.v[X] = 100;
    dv[0]->device.v[Y] = 5;
    dv[0]->device.v[Z] = 1000;

    dv[1]->device.v[X] = 125;
    dv[1]->device.v[Y] = 50;
    dv[1]->device.v[Z] = 30000;

    dv[2]->device.v[X] = 150;
    dv[2]->device.v[Y] = 5;
    dv[2]->device.v[Z] = 1000;

    if (flag==1)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);
    viewport->flatTriangleZb((PipelineData *const*)dv, c1);
    if (flag==2)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);

    dv[0]->device.v[X] = 100;
    dv[0]->device.v[Y] = 200;
    dv[0]->device.v[Z] = 1000;

    dv[1]->device.v[X] = 150;
    dv[1]->device.v[Y] = 200;
    dv[1]->device.v[Z] = 1000;

    dv[2]->device.v[X] = 125;
    dv[2]->device.v[Y] = 150;
    dv[2]->device.v[Z] = 30000;

    if (flag==1)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);
    viewport->flatTriangleZb((PipelineData *const*)dv, c1);
    if (flag==2)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);


    dv[0]->device.v[X] = 200;
    dv[0]->device.v[Y] = 5;
    dv[0]->device.v[Z] = 1000;

    dv[1]->device.v[X] = 225;
    dv[1]->device.v[Y] = 50;
    dv[1]->device.v[Z] = 30000;

    dv[2]->device.v[X] = 250;
    dv[2]->device.v[Y] = 25;
    dv[2]->device.v[Z] = 1000;

    if (flag==1)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);
    viewport->flatTriangleZb((PipelineData *const*)dv, c1);
    if (flag==2)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);

    dv[0]->device.v[X] = 200;
    dv[0]->device.v[Y] = 180;
    dv[0]->device.v[Z] = 1000;

    dv[1]->device.v[X] = 250;
    dv[1]->device.v[Y] = 200;
    dv[1]->device.v[Z] = 1000;

    dv[2]->device.v[X] = 225;
    dv[2]->device.v[Y] = 150;
    dv[2]->device.v[Z] = 30000;

    if (flag==1)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);
    viewport->flatTriangleZb((PipelineData *const*)dv, c1);
    if (flag==2)viewport->flatPolygonZb(3, (PipelineData *const*)dv, c2);


    dv[0]->device.v[X] = 90;
    dv[0]->device.v[Y] = 100;
    dv[0]->device.v[Z] = 1000;

    dv[2]->device.v[X] = 95;
    dv[2]->device.v[Y] = 103;
    dv[2]->device.v[Z] = 1000;

    dv[1]->device.v[X] = 85;
    dv[1]->device.v[Y] = 105;
    dv[1]->device.v[Z] = 1000;

    if (flag==2) viewport->flatPolygonZb(3, (PipelineData *const*)dv, c1);
    if (flag==1) viewport->flatTriangleZb((PipelineData *const*)dv, c1);

    dv[0]->device.v[X] = 100;
    dv[0]->device.v[Y] = 100;
    dv[0]->device.v[Z] = 1000;

    dv[2]->device.v[X] = 105;
    dv[2]->device.v[Y] = 104;
    dv[2]->device.v[Z] = 1000;

    dv[1]->device.v[X] = 95;
    dv[1]->device.v[Y] = 105;
    dv[1]->device.v[Z] = 1000;

    if (flag==2) viewport->flatPolygonZb(3, (PipelineData *const*)dv, c1);
    if (flag==1) viewport->flatTriangleZb((PipelineData *const*)dv, c1);


    dv[0]->device.v[X] = 110;
    dv[0]->device.v[Y] = 100;
    dv[0]->device.v[Z] = 1000;

    dv[2]->device.v[X] = 115;
    dv[2]->device.v[Y] = 105;
    dv[2]->device.v[Z] = 1000;

    dv[1]->device.v[X] = 105;
    dv[1]->device.v[Y] = 105;
    dv[1]->device.v[Z] = 1000;

    if (flag==2) viewport->flatPolygonZb(3, (PipelineData *const*)dv, c1);
    if (flag==1) viewport->flatTriangleZb((PipelineData *const*)dv, c1);


    dv[0]->device.v[X] = 120;
    dv[0]->device.v[Y] = 100;
    dv[0]->device.v[Z] = 1000;

    dv[2]->device.v[X] = 125;
    dv[2]->device.v[Y] = 106;
    dv[2]->device.v[Z] = 1000;

    dv[1]->device.v[X] = 115;
    dv[1]->device.v[Y] = 105;
    dv[1]->device.v[Z] = 1000;

    if (flag==2) viewport->flatPolygonZb(3, (PipelineData *const*)dv, c1);
    if (flag==1) viewport->flatTriangleZb((PipelineData *const*)dv, c1);


    dv[0]->device.v[X] = 130;
    dv[0]->device.v[Y] = 100;
    dv[0]->device.v[Z] = 1000;

    dv[2]->device.v[X] = 135;
    dv[2]->device.v[Y] = 107;
    dv[2]->device.v[Z] = 1000;

    dv[1]->device.v[X] = 125;
    dv[1]->device.v[Y] = 105;
    dv[1]->device.v[Z] = 1000;

    if (flag==2) viewport->flatPolygonZb(3, (PipelineData *const*)dv, c1);
    if (flag==1) viewport->flatTriangleZb((PipelineData *const*)dv, c1);



    cout << "Swapping buffers:" << endl;

    viewport->setDirty(0,0,XMAX,YMAX);
    viewport->swapBuffers();

    cout << "Sleeping: " << endl;
    sleep(20);

    if (XMAX >= 300 && YMAX >= 250) {
	cout << "Drawing colour space:" << endl;
	viewport->drawColourSpace();

	cout << "Swapping buffers:" << endl;
	viewport->setDirty(0,0,XMAX,YMAX);
	viewport->swapBuffers();
	
	cout << "Sleeping: " << endl;
	sleep(30);

    } else {
	cout << "Skipping colourspace - viewport too small" << endl;
    }
    
    cout << "Done" << endl;

    delete viewport;
}






