#include <Lib3d/Lib3d.H>
#include <Lib3d/internals/HrTimer.H>
#include <iostream.h>
#include <fstream.h>
#include <new.h>

main( int argc, char ** )
{
    const nrNoClipFrames = 1024;
    const nrClipFrames = 512;

    set_new_handler(abort);

    World *world = new World;
    Model *model = 0;
    { 
	ModelBuilder ob;

	ifstream in("../models/teapot.geom");
	if (in.bad()) {
	    cerr << "Couldn't open teapot.geom" << endl;
	    exit(-1);
	}

	ob.startModel();
	// ob.setColourfulMode(.9);	// Beachball mode
	if (argc == 2) ob.setColourfulMode(.5);	// Beachball mode
	// ob.readNFF( in );
	// ob.readObj( in );
	ob.readGeom( in );

	model = ob.endModel();
    }
    world->adopt(model);


    cout << "Created object:\n" << *model << endl;

    Camera *camera = new Camera(*world);
    camera->setParameters(1,100,15,1);
    world->setActiveCamera( *camera );

    Vector3 colour(1,1,1);   
    Vector3 direction(0,1,.5);

    Light *light = new Light(*world);
    light->setParameters(colour, colour, direction);
    world->registerLight( *light );

    Matrix34 transform;
    transform.setIdentity();
    model->setTransform(transform);
    
    Matrix34 tmp;
    Matrix34 scale;

    Device *device = Device::create(320, 200, 8);

    Viewport *viewport;
    if ((viewport = Viewport::create(device)) == 0) {
	cout << "Couldn't create a viewport." << endl;
	exit(1);
    }

    cout << *viewport << endl;

    for (int n = 0 ; n < 3 ; n++) {
	if (n == 1) {
	    model->usePipeline(* (new SmoothPipeline) );
	    cout << "Smooth pipeline:" << endl;
	    // continue;
	} else if (n == 2) {
	    model->usePipeline(* (new WirePipeline) );
	    cout << "Wire pipeline:" << endl;
	    // continue;
	} else {
	    cout << "Flat pipeline:" << endl;
	    // continue;
	}
	
	HrTimer   clip("    Clipping");
	HrTimer noclip("Not clipping");

	cout << "Rendering " << nrClipFrames << " frames: " << endl;

	scale.setIdentity();
	transform.setRotation(180, 1,0,0);
        scale.setRotation((4.56), 0, 1, 0);
	// scale.setRotation((4.56), 1, 1, 1);
	tmp.setTranslation(0,-1,-10);
	camera->setTransform(tmp);

	transform.premul(scale);
	model->setTransform(transform);
	world->renderHierarchy( *viewport );
        viewport->swapBuffers();
    
	int i;

        clip.start();
        for (  i = 0 ; i < nrClipFrames/4 ; i++ ) {
	    transform.premul(scale);
	    model->setTransform(transform);
	    world->renderHierarchy( *viewport );
	    viewport->swapBuffers();
        }
        clip.end();
    
        cout << clip << endl;
        cout << "\t" << (float(i)/clip.getElapsedSeconds()) 
	     << " frames per second" << endl;
        cout << setprecision(8);
        cout << "\t" << (float(i * model->getNrPolygons())/
			 clip.getElapsedSeconds()) 
	     << " polygons per second" << endl;

    
        cout << "Rendering " << nrNoClipFrames << " frames: " << endl;
    
        tmp.setTranslation(0,0,-16);
        camera->setTransform(tmp);
        transform.setRotation(180, 1,0,0);
        scale.setRotation((4.56), 0, 1, 0);

        transform.premul(scale);
        model->setTransform(transform);
        world->renderHierarchy( *viewport );
        viewport->swapBuffers();
    
        noclip.start();
        for ( int j = 0 ; j < nrNoClipFrames ; j++ ) {
	    transform.premul(scale);
	    model->setTransform(transform);
	    world->renderHierarchy( *viewport );
	    viewport->swapBuffers();
        }
        noclip.end();
    
        cout << noclip << endl;
        cout << "\t" << (float(nrNoClipFrames)/noclip.getElapsedSeconds()) 
    	     << " frames per second" << endl;
        cout << setprecision(8);
        cout << "\t" << (float(nrNoClipFrames * model->getNrPolygons())/
			 noclip.getElapsedSeconds()) 
    	     << " polygons per second" << endl;

    }

    delete viewport;
    delete world;
}










