#include <Lib3d/Viewport.H>
#include <Lib3d/Model.H>
#include <Lib3d/ModelBuilder.H>
#include <Lib3d/World.H>
#include <Lib3d/Camera.H>
#include <Lib3d/Light.H>
#include <Lib3d/SmoothPipeline.H>
#include <Lib3d/WirePipeline.H>
#include <Lib3d/internals/HrTimer.H>
#include <iostream.h>
#include <fstream.h>
#include <unistd.h>


main( int argc, char *argv[] )
{
    cout << "This demo will take over your console/terminal for the" << endl;
    cout << "time it takes to render 500 frames.  If you don't like" << endl;
    cout << "this idea, hit ctrl-C now..." << endl;

    sleep(10);

    cout << "OK.  Here we go..." << endl;

    Pipeline *pipeline = 0;
    if (argc == 2) {
	if (strcmp(argv[1], "smooth") == 0) pipeline = new SmoothPipeline;
	if (strcmp(argv[1], "wire") == 0) pipeline = new WirePipeline;
	if (strcmp(argv[1], "flat") == 0) pipeline = new FlatPipeline;
    }
    if (pipeline == 0) pipeline = new FlatPipeline;

    Device *device = Device::create(300,200,8,Device::MouseCapability);
    Viewport *viewport = Viewport::create(device);

    if (!viewport) {
	cout << "Failed to create viewport" << endl;
	exit(1);
    }

    cout << *device << endl;
    cout << *viewport << endl;

    World world;
    ModelBuilder ob;


#if 0
    ifstream in("../models/teapot.nff");
    if (in.bad()) {
	cerr << "Couldn't open teapot.nff" << endl;
	exit(-1);
    }

    ob.startModel();
    ob.readNFF( in );
#else
    ifstream in("../models/teapot.geom");
    if (in.bad()) {
	cerr << "Couldn't open teapot.geom" << endl;
	exit(-1);
    }

    ob.startModel();
    ob.readGeom( in );
#endif


    Model *model = ob.endModel();
    world.adopt(model);

    cout << "Created object:\n" << *model << endl;

    Camera *camera = new Camera(world);
    camera->setParameters(3,100,15,1);
    world.setActiveCamera( *camera );

    Vector3 colour(1,1,1);	// A white light
    Vector3 direction(0,1,.5);
    Light *light = new Light(world);
    light->setParameters(colour, colour, direction);
    world.registerLight( *light );

    model->usePipeline(*pipeline);

    Matrix34 transform;
    transform.setIdentity();
    model->setTransform(transform);
    
    Matrix34 tmp;
    Matrix34 incr;
    HrTimer render("Rendering", "Frames");

    transform.setRotation(-90, 1,0,0);

    tmp.setTranslation(0,-1,-10);
    camera->setTransform(tmp);

    int nrFrames = 1000;

    device->enableMouseCapability();

    render.start();
    for ( int i = 0 ; i < nrFrames ; i++ ) {
	render.lap();
	device->processPendingEvents();
	incr.setArcBallIncrement(100.0, 
				 device->getMouseXRel(), 
				 device->getMouseYRel());
	
	transform.premul(incr);
	model->setTransform(transform);
	world.renderHierarchy( *viewport );
	viewport->swapBuffers();
    }
    render.end();
	
    cout << render << endl;
    cout << setprecision(8) << "\t" 
	 << (float(nrFrames * model->getNrPolygons())
	     / render.getElapsedSeconds()) 
	 << " polygons per second" << endl;

    delete pipeline;
    delete viewport;
}










