/* Copyright (C) 1994-1995 G & Y Systems, Foster City, Ca */
/*----------------------------- GRAPHICS.H ---------------------------------*/
/* Constants, definitions and prototypes for libbgi                         */
/*--------------------------------------------------------------------------*/
#if  !defined(__GRAPHX_DEF_)
#define __GRAPHX_DEF_

#define max(a,b)   (((a)>(b))? (a):(b))
#define min(a,b)   (((a)<(b))? (a):(b))

#define TEXTCOLOR          0x03
#define TEXTMONO           0x07

#define DETECT                0
#define NODETECT              1

#define G640x200x16        0x0E
#define G640x350x16        0x10
#define G640x480x16        0x12
#define G320x200x256       0x13

#define G800x600x16        0x102
#define G1024x768x16       0x104

#define G640x400x256       0x100
#define G640x480x256       0x101
#define G800x600x256       0x103
#define G1024x768x256      0x105

#define GRAPHMONO          0x0f

#define TERMINAL_MODE      0xB

#define FALSE            0
#define TRUE             1

#define MINMAX          -1
#define NOMINMAX        -2
#define DPOINTS         -3

#define NULL_SIZE        0x1000

#define MAXFONTS         20
#define PREFIXSIZE       0x80

#define ERRNUMBASE       0

/* Operation codes for stroked fonts */
#define ENDCHAR          0
#define SCAN             1
#define MOVE             2
#define DRAW             3

struct TModeInfo     /* Information about the current graphics mode   */
{
  int Driver, Mode; /* Driver and current mode               */
  int MaxX, MaxY;   /* Maximum value coordinates (in pixels) */
  int AspX, AspY;   /* Aspect ratio                          */
  int Bytes;        /* Number of bytes in screen line        */
  int MaxColor;     /* Maximum color number                  */
  int Regime;       /* VGA_MODE, SVGA_MODE or BAD_MODE       */
  int Type;         /* TEXT_MODE, GRAPH_MODE etr.            */
  int NCol;         /* Number of character columns           */
  int NRow;         /* Number of character rows per screen   */
  int Size;         /* Length of display buffer              */
  int MaxBank;      /* Number banks of visual display memory */
};

struct BOUND /* Item of list of bound points */
{
  int x, y; /* Coordinates of a point */
  int NumFrag; /* Fragment number with this point */
  struct BOUND *Next; /* Pointer on the next item */
};

struct POINT
{
  int x, y; /* Point coordinates */
};

struct EDGE /* Item of list with edges of polygon */
{
  int BegX, BegY; /* First point */
  int EndX, EndY; /* Last point (EndY > BegY) */
  double CurX; /* Coordinate of crossing point */
  double DeltaX; /* Increment of crossing point */
};

struct CROSS /* Item of list with edges, crossed the line */
{
  int Num; /* Edge number */
  struct CROSS *Next; /* Pointer on the next number */
};

typedef struct /* Font header */
{
  char    sig;                  /* SIGNATURE byte                        */
  short   nchrs;                /* Number of characters in file          */
  char    mystery;              /* Currently Undefined                   */
  char    first;                /* First character in file               */
  short   cdefs;                /* Offset to char definitions            */
  char    scan_flag;            /* True if set is scanable               */
  char    org_to_cap;           /* Height from origin to top of capitol  */
  char    org_to_base;          /* Height from origin to baseline        */
  char    org_to_dec;           /* Height from origin to bot of decender */
  char    fntname[4];           /* Four character name of font           */
  char    unused;               /* Currently undefined                   */
} FONTHEADER;

typedef struct /* Item of stroked font descriptor */
{
  short   OpCode;               /* Stroke opcode                         */
  short   x;                    /* Relative offset x direction           */
  short   y;                    /* Relative offset y direction           */
} STROKE;

enum graphics_errors /* graphresult error return codes */
{
  grOk                          =   0,
  grNoInitGraph                 =  -1,
  grNotDetected                 =  -2,
  grFileNotFound                =  -3,
  grInvalidDriver               =  -4,
  grNoLoadMem                   =  -5,
  grNoScanMem                   =  -6,
  grNoFloodMem                  =  -7,
  grFontNotFound                =  -8,
  grNoFontMem                   =  -9,
  grInvalidMode                 = -10,
  grError                       = -11,
  grIOerror                     = -12,
  grInvalidFont                 = -13,
  grInvalidFontNum              = -14,
  grInvalidDeviceNum            = -15,
  grInvalidVersion              = -18,
  grReversArc                   = -19,
  grNullRadCircle               = -20,
  grReversAngleEllipse          = -21,
  grNullRadEllipse              = -22,
  grErrMemory                   = -23,
  grNoCorrectParFillarea        = -24,
  grNullRadFillellipse          = -25,
  grReversAnglePieslice         = -26,
  grReversAngleSector           = -27,
  grLargeImagesize              = -28,
  grVGAOnly                     = -29,
  grNotOpenTtyInitialize        = -30,
  grErrMemMapInitialize         = -31,
  grIOErrorGetpixel             = -32,
  grNoCorrectParSetviewport     = -33,
  grNoCorrectParBar             = -34,
  grNoCorrectParBar3d           = -35,
  grNotEnoughParFillpoly        = -36,
  grNotEnoughParDrawpoly        = -37,
  grDataErrorSetlinestyle       = -38,
  grLargeNumFontInstalluserfont = -39,
  grIncorrSetaspect             = -40,
  grIncorrRadPieslice           = -41,
  grIncorrRadSector             = -42,
  grIncorrSetpalette            = -43,
  grIncorrSetRGB                = -44,
  grSetfillpatt                 = -45,
  grSetfillsty                  = -46,
  grSetWriteMode                = -47,
  grTextJust                    = -48,
  grTextStyle                   = -49,
  grSetUserDefChar              = -50
};

#define MAXCOLORS   255

/* Colors for setpalette and setallpalette */
#if !defined(__COLORS)
#define __COLORS

enum COLORS
{
  BLACK,
  BLUE,
  GREEN,
  CYAN,
  RED,
  MAGENTA,
  BROWN,
  LIGHTGRAY,
  DARKGRAY,
  LIGHTBLUE,
  LIGHTGREEN,
  LIGHTCYAN,
  LIGHTRED,
  LIGHTMAGENTA,
  YELLOW,
  WHITE
};
#endif

enum CGA_COLORS
{
  CGA_LIGHTGREEN   = 1,     /* Palette C0 Color Names */
  CGA_LIGHTRED     = 2,
  CGA_YELLOW       = 3,

  CGA_LIGHTCYAN    = 1,     /* Palette C1 Color Names */
  CGA_LIGHTMAGENTA = 2,
  CGA_WHITE        = 3,

  CGA_GREEN        = 1,     /* Palette C2 Color Names */
  CGA_RED          = 2,
  CGA_BROWN        = 3,

  CGA_CYAN         = 1,     /* Palette C3 Color Names */
  CGA_MAGENTA      = 2,
  CGA_LIGHTGRAY    = 3
};

enum EGA_COLORS
{
  EGA_BLACK        =  0,
  EGA_BLUE         =  1,
  EGA_GREEN        =  2,
  EGA_CYAN         =  3,
  EGA_RED          =  4,
  EGA_MAGENTA      =  5,
  EGA_BROWN        =  20,
  EGA_LIGHTGRAY    =  7,
  EGA_DARKGRAY     =  56,
  EGA_LIGHTBLUE    =  57,
  EGA_LIGHTGREEN   =  58,
  EGA_LIGHTCYAN    =  59,
  EGA_LIGHTRED     =  60,
  EGA_LIGHTMAGENTA =  61,
  EGA_YELLOW       =  62,
  EGA_WHITE        =  63
};

enum line_styles /* Line styles for get/setlinestyle */
{
  SOLID_LINE   = 0,
  DOTTED_LINE  = 1,
  CENTER_LINE  = 2,
  DASHED_LINE  = 3,
  USERBIT_LINE = 4 /* User defined line style */
};

enum line_widths /* Line widths for get/setlinestyle */
{
  NORM_WIDTH  = 1,
  THICK_WIDTH = 3
};

enum fill_patterns /* Fill patterns for get/setfillstyle */
{
  EMPTY_FILL,       /* fills area in background color */
  SOLID_FILL,       /* fills area in solid fill color */
  LINE_FILL,        /* --- fill                       */
  LTSLASH_FILL,     /* /// fill                       */
  SLASH_FILL,       /* /// fill with thick lines      */
  BKSLASH_FILL,     /* \\\ fill with thick lines      */
  LTBKSLASH_FILL,   /* \\\ fill                       */
  HATCH_FILL,       /* light hatch fill               */
  XHATCH_FILL,      /* heavy cross hatch fill         */
  INTERLEAVE_FILL,  /* interleaving line fill         */
  WIDE_DOT_FILL,    /* widely spaced dot fill         */
  CLOSE_DOT_FILL,   /* closely spaced dot fill        */
  USER_FILL         /* user defined fill              */
};

enum putimage_ops /* BitBlt operators for putimage */
{
  COPY_PUT,         /* MOV */
  XOR_PUT,          /* XOR */
  OR_PUT,           /* OR  */
  AND_PUT,          /* AND */
  NOT_PUT           /* NOT */
};

enum font_names
{
  DEFAULT_FONT    = 0, /* 8x8 bit mapped font */
  TRIPLEX_FONT    = 1, /* "Stroked" fonts */
  SMALL_FONT      = 2,
  SANS_SERIF_FONT = 3,
  GOTHIC_FONT     = 4
};

#define HORIZ_DIR        0        /* left to right */
#define VERT_DIR         1        /* bottom to top */

#define USER_CHAR_SIZE   0        /* user-defined char size */

enum text_just /* Horizontal and vertical justification for settextjustify */
{
  LEFT_TEXT        = 0,
  CENTER_TEXT      = 1,
  RIGHT_TEXT       = 2,

  BOTTOM_TEXT      = 0,
  /* CENTER_TEXT   = 1,  already defined above */
  TOP_TEXT         = 2
};

struct palettetype
{
  unsigned size;
  int colors[MAXCOLORS+1];
};

struct linesettingstype
{
  int      linestyle;
  unsigned upattern;
  int      thickness;
};

struct textsettingstype
{
  int font;
  int direction;
  int charsize;
  int horiz;
  int vert;
};

struct fillsettingstype
{
  int pattern;
  int color;
};

struct pointtype
{
  int x, y;
};

struct viewporttype
{
  int left, top, right, bottom;
  int clip;
};

struct arccoordstype
{
  int x, y;
  int xstart, ystart, xend, yend;
};

/*-------------------------------------------------------------------------*/

void  restoretextmode();
void  arc(int x, int y, int stangle, int endangle, int radius);
void  bar(int left, int top, int right, int bottom);
void  bar3d(int left, int top, int right, int bottom, int depth, int topflag);
void  circle(int x, int y, int radius);
void  cleardevice(void);
void  clearviewport(void);
void  closegraph(void);
void  drawpoly(int numpoints, int  *polypoints);
void  ellipse(int x, int y, int stangle, int endangle,
              int xradius, int yradius);
void  fillellipse(int x, int y, int xradius, int yradius );
void  fillpoly(int numpoints, int  *polypoints);
void  floodfill(int x, int y, int border);
void  getarccoords(struct arccoordstype  *arccoords);
void  getaspectratio(int  *xasp, int  *yasp);
int   getbkcolor(void);
int   getcolor(void);
struct palettetype  * getdefaultpalette( void );
void  getfillpattern(char  *pattern);
void  getfillsettings(struct fillsettingstype  *fillinfo);
int   getgraphmode(void);
void  getimage(int left, int top, int right, int bottom, void  *bitmap);
void  getlinesettings(struct linesettingstype  *lineinfo);
int   getmaxcolor(void);
int   getmaxmode(void);
int   getmaxx(void);
int   getmaxy(void);
unsigned  getpixel(int x, int y);
void  getpalette(struct palettetype  *palette);
int   getpalettesize( void );
void  gettextsettings(struct textsettingstype  *texttypeinfo);
void  getviewsettings(struct viewporttype  *viewport);
int   getx(void);
int   gety(void);
char *  grapherrormsg(int errorcode);
int   graphresult(void);
unsigned imagesize(int left, int top, int right, int bottom);
void  initgraph(int *graphdriver, int *graphmode, char *pathtodriver);
int   installuserfont(char *name );
void  line(int x1, int y1, int x2, int y2);
void  linerel(int dx, int dy);
void  lineto(int x, int y);
void  moverel(int dx, int dy);
void  moveto(int x, int y);
void  outtext(char *textstring);
void  outtextxy(int x, int y, char *textstring);
void  pieslice(int x, int y, int stangle, int endangle, int radius);
void  putimage(int left, int top, void  *bitmap, int op);
void  putpixel(int x, int y, int color);
void  rectangle(int left, int top, int right, int bottom);
void  restorecrtmode(void);
void  sector(int X, int Y, int StAngle, int EndAngle,
             int XRadius, int YRadius );
void  setallpalette(struct palettetype  *palette);
void  setaspectratio(int xasp, int yasp);
void  setbkcolor(int color);
void  setcolor(int color);
void  setfillpattern(char *upattern, int color);
void  setfillstyle(int pattern, int color);
void  setgraphmode(int mode);
void  setlinestyle(int linestyle, unsigned upattern, int thickness);
void  setpalette(int colornum, int color);
void  setrgbpalette(int colornum, int red, int green, int blue);
void  settextjustify(int horiz, int vert);
void  settextstyle(int font, int direction, int charsize);
void  setusercharsize(int multx, int divx, int multy, int divy);
void  setuserdefchar();
void  setviewport(int left, int top, int right, int bottom, int clip);
void  setvisualpage(int page);
void  setwritemode( int mode );
int   textheight(char *textstring);
int   textwidth(char *textstring);
int   warnresult();

int   getch(void);
int   kbhit(void);

void  LockVT(void);         /* Locking virtual console   */
void  UnLockVT(void);       /* Unlocking virtual console */
void  RunInBkgr(int State); /* On/Off running in background */
int   WriteVT(void);        /* Returns TRUE if VT is acquired */

#endif




