/*
    OpenGUI - Drawing & Windowing library

    Copyright (C) 1996,2000  Marian Krivos

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    nezmar@internet.alcatel.sk
    Some widgets
*/

#include <sys/stat.h>

#pragma implementation

#include "config.h"
#include "widgets.h"
#include "_fastgl.h"

Window	*FileDialog::wnd;
FileDialog *FileDialog::instance=0;
char FileDialog::path[256];
char FileDialog::tmppath[256];
ColorDialog *ColorDialog::instance=0;
Window	*ColorDialog::wnd;

unsigned int ColorDialog::custom_colors[256] = {
0x000000, 0x0000a8, 0x00a800, 0x00a8a8, 0xa80000, 0xa800a8, 0xa85400, 
0xa8a8a8, 0x545454, 0x5454fc, 0x54fc54, 0x54fcfc, 0xfc5454, 0xfc54fc, 
0xfcfc54, 0xfcfcfc, 0x000000, 0x141414, 0x202020, 0x2c2c2c, 0x383838, 
0x444444, 0x505050, 0x606060, 0x707070, 0x808080, 0x909090, 0xa0a0a0, 
0xb4b4b4, 0xc8c8c8, 0xe0e0e0, 0xfcfcfc, 0x0000fc, 0x4000fc, 0x7c00fc, 
0xbc00fc, 0xfc00fc, 0xfc00bc, 0xfc007c, 0xfc0040, 0xfc0000, 0xfc4000, 
0xfc7c00, 0xfcbc00, 0xfcfc00, 0xbcfc00, 0x7cfc00, 0x40fc00, 0x00fc00, 
0x00fc40, 0x00fc7c, 0x00fcbc, 0x00fcfc, 0x00bcfc, 0x007cfc, 0x0040fc, 
0x7c7cfc, 0x9c7cfc, 0xbc7cfc, 0xdc7cfc, 0xfc7cfc, 0xfc7cdc, 0xfc7cbc, 
0xfc7c9c, 0xfc7c7c, 0xfc9c7c, 0xfcbc7c, 0xfcdc7c, 0xfcfc7c, 0xdcfc7c, 
0xbcfc7c, 0x9cfc7c, 0x7cfc7c, 0x7cfc9c, 0x7cfcbc, 0x7cfcdc, 0x7cfcfc, 
0x7cdcfc, 0x7cbcfc, 0x7c9cfc, 0xb4b4fc, 0xc4b4fc, 0xd8b4fc, 0xe8b4fc, 
0xfcb4fc, 0xfcb4e8, 0xfcb4d8, 0xfcb4c4, 0xfcb4b4, 0xfcc4b4, 0xfcd8b4, 
0xfce8b4, 0xfcfcb4, 0xe8fcb4, 0xd8fcb4, 0xc4fcb4, 0xb4fcb4, 0xb4fcc4, 
0xb4fcd8, 0xb4fce8, 0xb4fcfc, 0xb4e8fc, 0xb4d8fc, 0xb4c4fc, 0x000070, 
0x1c0070, 0x380070, 0x540070, 0x700070, 0x700054, 0x700038, 0x70001c, 
0x700000, 0x701c00, 0x703800, 0x705400, 0x707400, 0x547000, 0x387000, 
0x1c7000, 0x007000, 0x00701c, 0x007038, 0x007054, 0x007070, 0x005470, 
0x003870, 0x001c70, 0x383870, 0x443870, 0x543870, 0x603870, 0x703870, 
0x703860, 0x703854, 0x703844, 0x703838, 0x704438, 0x705438, 0x706038, 
0x707038, 0x607038, 0x547038, 0x447038, 0x387038, 0x387044, 0x387054, 
0x387060, 0x387070, 0x386070, 0x385470, 0x384470, 0x505070, 0x585070, 
0x605070, 0x685070, 0x705070, 0x705068, 0x705060, 0x705058, 0x705050, 
0x705850, 0x706050, 0x706850, 0x707050, 0x687050, 0x607050, 0x587050, 
0x507050, 0x507058, 0x507060, 0x507068, 0x507070, 0x506870, 0x506070, 
0x505870, 0x000040, 0x100040, 0x200040, 0x300040, 0x400040, 0x400030, 
0x400020, 0x400010, 0x400000, 0x401000, 0x402000, 0x403000, 0x404000, 
0x304000, 0x204000, 0x104000, 0x004000, 0x004010, 0x004020, 0x004030, 
0x004040, 0x003040, 0x002040, 0x001040, 0x202040, 0x282040, 0x302040, 
0x382040, 0x402040, 0x402038, 0x402030, 0x402028, 0x402020, 0x402820, 
0x403020, 0x403820, 0x404020, 0x384020, 0x304020, 0x284020, 0x204020, 
0x204028, 0x204030, 0x204038, 0x204040, 0x203840, 0x203040, 0x202840, 
0x2c2c40, 0x302c40, 0x342c40, 0x3c2c40, 0x402c40, 0x402c3c, 0x402c34, 
0x402c30, 0x402c2c, 0x40302c, 0x40342c, 0x403c2c, 0x40402c, 0x3c402c, 
0x34402c, 0x30402c, 0x2c402c, 0x2c4030, 0x2c4034, 0x2c403c, 0x2c4040, 
0x2c3c40, 0x2c3440, 0x2c3040, 0x000000, 0x000000, 0x000000, 0x000000, 
0x000000, 0x000000, 0x000000, 0x000000 };

//
// return code of operations
//
int ListBox::DoListBox(int key)
{
	switch(key)
	{
		case KUP:
			Up();
			return 1;
		case KDOWN:
			Down();
			return 2;
		case HOME:
			SetToItem(0);
			return 3;
		case END:
			SetToItem(GetSize()-1);
			return 4;
	}
	return 0;
}

int ListBox::Draw(int)
{
	int i,j,a=fpol;

    owner->WindowRect(x-2,y-1,onew*polx+18,oneh*poly+2,CWHITE);
    owner->WindowBox(x,y,onew*polx,oneh*poly,owner->GetPaper());
    draw();
    if (*p_size==0) return 0;
    for(i=0;i<poly;i++) for(j=0;j<polx;j++)
    {
		kresli(x+j*onew, y+i*oneh, fpol*polx+i*polx+j, 0, dataptr);
		if (*p_size==++a)
        {
			kresli(x+cx*onew, y+cy*oneh, *p_position, 1, dataptr);
            return 1;
        }
    }
	kresli(x+cx*onew, y+cy*oneh, *p_position, 1, dataptr);
	return 1;
}

void ListBox::Up(void)
{
	if (*p_position>=polx)
	{
		kresli(x+cx*onew, y+cy*oneh, *p_position, 0, dataptr);
		if (cy>0) cy--;
		else if (fpol>0)
		{
			fpol--;
            if (poly>1) owner->WindowScrollDown(x,y,polx*onew,(poly-1)*oneh,oneh);
			for(int i=0; i<polx; i++) kresli(x+i*onew, y, fpol*polx+i, 0, dataptr);
        }
		*p_position = (fpol+cy)*polx+cx;
		kresli(x+cx*onew, y+cy*oneh, *p_position, 1, dataptr);
	}
	corecture();
}

void ListBox::Down(void)
{
	if ((*p_position+polx)<=(*p_size-1))
	{
		kresli(x+cx*onew, y+cy*oneh, *p_position, 0, dataptr);
		if (cy<poly-1) cy++;
		else
		{
			fpol++;
            if (poly>1) owner->WindowScrollUp(x,y+oneh,polx*onew,(poly-1)*oneh,oneh);
			for(int i=0; i<polx; i++) kresli(x+i*onew, y+(poly-1)*oneh, fpol*polx+(poly-1)*polx+i, 0, dataptr);
        }
		*p_position = (fpol+cy)*polx+cx;
		kresli(x+cx*onew, y+cy*oneh, *p_position, 1, dataptr);
	}
	corecture();
}

void ListBox::Right(void)
{
	if (*p_position<(*p_size-1))
	{
		kresli(x+cx*onew, y+cy*oneh, *p_position, 0, dataptr);
		if (cx<(polx-1)) cx++;
        else if (cy<(poly-1)) { cx = 0; cy++; }
		else
		{
			fpol++;
            if (poly>1) owner->WindowScrollUp(x,y+oneh,polx*onew,(poly-1)*oneh,oneh);
			for(int i=0; i<polx; i++) kresli(x+i*onew, y+(poly-1)*oneh, fpol*polx+(poly-1)*polx+i, 0, dataptr);
			cx= 0 ;
		}
		*p_position = (fpol+cy)*polx+cx;
		kresli(x+cx*onew, y+cy*oneh, *p_position, 1, dataptr);
	}
	corecture();
}

void ListBox::Left(void)
{
	if (*p_position>0)
	{
		kresli(x+cx*onew, y+cy*oneh, *p_position, 0, dataptr);
		if (cx>0) cx--;
        else if (cy>0) {cy--; cx=polx-1; }
        else
        {
        	if (fpol)
        	{
        		fpol--;
	            if (poly>1) owner->WindowScrollDown(x,y,polx*onew,(poly-1)*oneh,oneh);
				for(int i=0; i<polx; i++) kresli(x+i*onew, y, fpol*polx+i, 0, dataptr);
	        	cx=polx-1;
			}
        }
		*p_position = (fpol+cy)*polx+cx;
		kresli(x+cx*onew, y+cy*oneh, *p_position, 1, dataptr);
	}
	corecture();
}

void ListBox::SetToItem(int a)
{
	int komplet = 0;

	if (a>=*p_size) a = *p_size-1;
	if (a==*p_position || a<0) return;
	kresli(x+cx*onew, y+cy*oneh, *p_position, 0, dataptr);
	cx = a%polx;
	if (a<fpol || a>=(fpol+poly))
	{
		fpol = (a-cx)/polx;
		if (fpol>=(*p_size-poly))
		{
			fpol = *p_size-poly;
			cy   = a-fpol;
		}
		else cy = 0;
		komplet = 1;
	}
	else cy = a-fpol;
	*p_position = (fpol+cy)*polx+cx;
	if (komplet) Draw();
	else kresli(x+cx*onew, y+cy*oneh, *p_position, 1, dataptr);
	corecture();
}

void ListBox::SetToItemRel(int a)
{
	if (a==0) return;
	if (a>0) for(;a--;) Right();
	else for(;a++<0;) Left();
}

void ListBox::Resize(int kolko)
{
   	if ((*p_size+kolko)<0) *p_size = 0;
	else *p_size += kolko;
	while(*p_position>(*p_size-1) && *p_position>0)
	{
		if (cx>0) cx--;
        else if (cy>0) {cy--; cx=polx-1; }
	    else { fpol=0; cx=polx-1; }
		*p_position = (fpol+cy)*polx+cx;
	}
	corecture();
	Draw();
	if (*p_size) RedrawItem();
}

int ListBox::Test(int ccx, int ccy)
{
	int c;
	if (*p_size<1) return -1;
	if (ccx<x || ccx>=(x+onew*polx)) return -1;
	if (ccy<y || ccy>=(y+oneh*poly)) return -1;
	c = ((ccy-y)/oneh)*polx + (ccx-x)/onew + fpol*polx;
	if (c>=*p_size) return -1;
	return c;
}

void ListBox::SetSize(int kolko)
{
	assert(kolko>=0);
	Resize(kolko - *p_size);
}

void ListBox::lbCall(Control *T)
{
	ListBox	*This = (ListBox *)(T->GetParam());
	if (This->poly < *(This->p_size))
	{
		This->SetToItem( int (*(This->p_size) * ((float)(This->slider+1) / This->maxv)));
	}
}

ListBox::ListBox(int xs, int ys, int wpol, int hpol, int w, int h, int *cnt, int *pos, void (*drawone)(int,int,int,int,void *), Window *wind, void *data)
	:	Slider(wind,
		xs+wpol*w, ys,
		16, hpol*h+1,
		0,(hpol*h)-18,
		1, &slider, lbCall), slider(0)
{
	_count = 0;
	_curr = 0;
	if (cnt==0) cnt = &_count;
	if (pos==0) pos = &_curr;
	_init(xs,ys,wpol,hpol,w,h,cnt,pos,drawone,data);
}

ListBox::ListBox(int xs, int ys, int wpol, int hpol, int w, int h, int cnt, void (*drawone)(int,int,int,int,void *), Window *wind, void *data)
	:	Slider(wind,
		xs+wpol*w, ys,
		16, hpol*h+1,
		0,(hpol*h)-18,
		1, &slider, lbCall), slider(0)
{
	_count = cnt;
	_curr = 0;
	_init(xs,ys,wpol,hpol,w,h,&_curr,&_count,drawone,data);
}

void ListBox::_init(int xs, int ys, int wpol, int hpol, int w, int h, int *pozicia, int *cnt, void (*drawone)(int,int,int,int,void *), void *data)
{
	SetParam((int)this);
	if (*cnt>0) if (*pozicia>=*cnt) *pozicia = *cnt-1;
	p_position = pozicia;
	p_size  = cnt;
	dataptr = data;
	x    = xs;
	y    = ys;
	cx   = *p_position%wpol; // obe v polozkach
	cy   = *p_position/wpol;
	onew = w;
	oneh = h;
	polx = wpol;
	poly = hpol;
	fpol = 0;
	kresli = drawone;
	Draw();
	corecture();
}

int FileDialog::Selected(void)
{
	char tmp[256+64];
	char tmp2[256];
	int retval=0;

	*tmp=0;
	strcpy(tmp,path);
#ifdef __MSDOS__
	if (*tmp && tmp[1]==':' && tmp[3]) strcat(tmp,"\\");
#else
	if (*tmp) strcat(tmp,"/");
#endif
	if (filename[0]=='.' && filename[1]=='.' && filename[2]!=0)
		strcpy(filename, filename+2);
	strcat(tmp, filename);
	getcwd(tmp2, 255);
	retval = chdir(tmp);
	if (retval!=0 && (filename[0]=='/'|| filename[0]=='\\' || filename[1]==':'))
	{
		retval=chdir(filename); // try absolute path
		if (retval==0)
		strcpy(tmp,filename);
	}
	chdir(tmp2);
	if (retval==0)
	{
		Refresh(tmp);
		return FALSE;
	}

	if (strncmp(tmp, tmp2, strlen(tmp2))==0)
		strcpy(tmp,tmp+strlen(tmp2)+1);

	if (fileselect1)
	{
		FILE *fp=fopen(tmp, "r");  // if exists ..
		if (fp) fclose(fp);
		if (mode&FDIALOG_OPEN)
		{
			if (fp)
			{
				fileselect1(tmp);
				return TRUE;
			}
		}
		else
		{
			fileselect1(tmp);
			return TRUE;
		}
	}
	else if (fileselect2)
	{
		FILE *fp=fopen(tmp, "r");  // if exists ..
		if (fp) fclose(fp);
		if (mode&FDIALOG_OPEN)
		{
			if (fp)
			{
				fileselect2(tmp, this);
				return TRUE;
			}
		}
		else
		{
			fileselect2(tmp, this);
			return TRUE;
		}
	}
	return FALSE;
}

void FileDialog::Refresh(char *newpath)
{
	strcpy(path, newpath);
	int old = files;
	reload();
	list->SetToItem(0);
	list->Resize(files-old);
	list->Draw();
}

void FileDialog::InputName(CallBack)
{
	if (!instance->Selected()) return;
	if (wnd) delete wnd;
}

void FileDialog::myproc(GuiEvent *p)
{
	switch(p->Type())
	{
		case KEYEVENT: switch(p->Key())
		{
			case ' ':
				instance->nameEBox->ClickUp(1);
				break;
			case KUP:
				instance->list->Up();
				break;
			case KDOWN:
				instance->list->Down();
				break;
			case PGUP:
				instance->list->SetToItemRel(-10);
				break;
			case CTRL_PGUP:
				instance->list->SetToItem(0);
				if (instance->Selected()) goto quit;
				break;
			case PGDOWN:
				instance->list->SetToItemRel(10);
				break;
			case HOME:
				instance->list->SetToItem(0);
				instance->list->Draw();
				break;
			case END:
				instance->list->SetToItem(instance->files);
				instance->list->Draw();
				break;
			case CR:
				if (!instance->Selected()) break;
			case ESC:
quit:				if (wnd) delete wnd;
				break;
		}
		break;
		
		case CLICKLEFTEVENT:
		{
			int x=(p->GetX()-8)/154, y=(p->GetY()-34)/16;
			if (x==0 && y>=0 && y<=9)
			{
				instance->list->SetToItemRel(y - (instance->list->GetCurrent() - instance->list->GetFirstVisible()));
				if (!instance->Selected()) break;
				if (wnd) delete wnd;
			}
		}
		break;

		case BUTTONHOLDEVENT:
			if (p->Key() == instance->up->GetId()) instance->list->Up();
			if (p->Key() == instance->down->GetId()) instance->list->Down();
			break;
		case ACCELEVENT:
			if (!instance) break;
			if (p->Key() == instance->up->GetId()) break;
			if (p->Key() == instance->down->GetId()) break;
			if (p->Key() == instance->nameEBox->GetId()) break;
			else if (p->Key() == instance->ok->GetId())
			{
				if (ininput)
				{
					ininput->inputproc(CR);
					return;
				}
				else if (!instance->Selected()) break;
				if (wnd) delete wnd;
			}
			if (p->Key() != instance->cancel->GetId()) break;
			if (wnd) delete wnd;
			break;
	}
}

void FileDialog::drawone(int x, int y, int c, int flg, void *ptr)
{
	FileDialog *p = (FileDialog *) ptr;
	char name[32];
 	int fnt=set_font(2);

	sprintf(name, "%.19s",  p->filebuffer[c].item.d_name);
	if (!flg)
	{
		p->wnd->WindowBox(x,y,152,16,p->wnd->GetPaper());
		p->wnd->WindowText(x+4,y,name, p->filebuffer[c].type ? p->wnd->GetInk():int(CBROWN), p->wnd->GetPaper());
	}
	else
	{
		p->wnd->WindowBox(x,y,152,16,p->wnd->GetInk());
		p->wnd->WindowText(x+4,y,name, p->wnd->GetPaper(), p->wnd->GetInk());
        strcpy(p->filename, p->filebuffer[c].item.d_name);
        if (p->filename[0]=='.')
        {
        	p->filename[2]=0;
            p->nameEBox->ChangeItem(p->filename+2);
        }
        else
		{
			p->nameEBox->ChangeItem(p->filename);
			struct stat s;
			getcwd(p->tmppath, 255);
			chdir(p->path);
			stat(p->filename, &s);
			chdir(p->tmppath);
			set_ppop(_GSET);
			wnd->WindowBox(188,140,170,40,wnd->GetPaper());
			wnd->SetColors();
			set_font(1);
			wnd->printf(188,144,"Files:%9d\n", p->fls);
			wnd->printf(188,154,"Dirs :%9d\n", p->dirs);
			wnd->printf(188,164,"Size :%9d bytes\n", s.st_size);
			char *ss = ctime(&s.st_atime)+4;
			ss[strlen(ss)-1] = 0;
			wnd->WindowText(188,180, ss);
		}
    }
	set_font(fnt);
}

static int sort_name(void const *a, void const *b)
{
	return stricmp(((mydirent *)a)->item.d_name, ((mydirent *)b)->item.d_name);
}

static int sort_type(void const *a, void const *b)
{
	return ((mydirent *)a)->type - ((mydirent *)b)->type;
}

void FileDialog::reload(void)
{
	DIR *dirp;
	struct dirent *direntp;
	struct stat st;
	int i = 0, j=0, ne=0, q=0, isdir;
	char extensions[64][10], *p=filter;

	dirs = fls = files = 0;
	getcwd(tmppath, 255);
	chdir(path);
	getcwd(path, 255);  // reload path string in case "."
	dirp = opendir(path);

	if (dirp == NULL) return;
	else
	{	// expand filters
		if (p)
		{
			while(*p)
			{
				extensions[ne][j] = *p;
				if (*p==' ' || j==9)
				{
					extensions[ne++][j]=0;
					j=0;
					if (ne==64) break;
				}
				else j++;
				p++;
			}
			extensions[ne++][j]=0;
		}

		for (;;)
		{
			direntp = readdir(dirp);
			if (direntp == NULL) // finale
				break;
			if (strcmp(direntp->d_name, "."))
			{
				stat(direntp->d_name, &st);
				isdir = S_ISDIR(st.st_mode);
				if (isdir) dirs++;
				if (ne && !isdir) for(q=0;q<ne;q++)
				{
					if (strstr(direntp->d_name, extensions[q])) break;
				}
				if (ne && q==ne && strcmp(direntp->d_name, "..") && !isdir)
				{
					continue; // no valid extension
				}
				memcpy(&filebuffer[i].item, direntp, sizeof(struct dirent));
				filebuffer[i].type = !isdir;
				if (!isdir) fls++;
				if (++i == maxfiles)
				{
					maxfiles += maxfiles;
					memory = new char[maxfiles*sizeof(mydirent)];
					memcpy(memory, filebuffer, i*sizeof(mydirent));
					filebuffer = (struct mydirent *) memory;
					delete memory;
				}
			}
		}
		closedir(dirp);
	}
	files = i;
	chdir(tmppath);
	qsort(filebuffer, files, sizeof(mydirent), sort_type);
	qsort(filebuffer, dirs, sizeof(mydirent), sort_name);
	qsort(filebuffer+dirs, fls, sizeof(mydirent), sort_name);
	dirs--;
	return;
}

void FileDialog::_init(char *dir, char *flt, char *namewnd, int m, int ink, int paper)
{
 	int fnt=set_font(2);

	if (instance)
	{
		delete instance;
	}
	instance = this;
	param = -1;
	maxfiles = 256;
	memory = new char[maxfiles*sizeof(mydirent)];
	filebuffer = (struct mydirent *) memory;
	if (!(m&FDIALOG_SAVEDIR && path[0]))
		if (dir) strcpy(path, dir); 
		else getcwd(path, 255);
	filter = flt;
	mode = m;
	wnd = new Window(&wnd, 100,100,373,230, namewnd, myproc, ink, paper, WCLICKABLE|WUSELAST|WSTANDARD+WMODAL*(m&FDIALOG_MODAL?1:0));
	set_font(1);
	reload();
	wnd->WindowText(188,62,"press SPACE for");
	wnd->WindowText(188,72,"enter filename,");
	wnd->WindowText(188,82,"arrows and ENTER");
	wnd->WindowText(188,92,"to select file");
	strcpy(filename, "");
	nameEBox = wnd->AddEditBox(6,6,0,172,"Name",'N',filename,InputName);
	list = new ListBox(8,34,1,10,154,16, files,drawone,wnd,this);
	list->Down();
	ok = wnd->AddPushButton(188,6,80,21,"OK");
	cancel = wnd->AddPushButton(276,6,80,21,"CANCEL");
	up = wnd->AddPushButton(188,32,80,21,"UP");
	down = wnd->AddPushButton(276,32,80,21,"DOWN");
	set_font(fnt);
}

FileDialog::FileDialog(void (*filesel)(char *,FileDialog *), char *dir, char *flt, char *namewnd, int m, int ink, int paper)
{
	fileselect1 = 0;
	fileselect2 = filesel;
	_init(dir, flt, namewnd, m, ink, paper);	
}

FileDialog::FileDialog(void (*filesel)(char *), char *dir, char *flt, char *namewnd, int m, int ink, int paper)
{
	fileselect1 = filesel;
	fileselect2 = 0;
	_init(dir, flt, namewnd, m, ink, paper);	
}

void ReleaseFd(void)
{
    if (FileDialog::instance) delete FileDialog::instance;
}

void ListBox::draw(void)
{
	Window *tmp = owner->Context();
	set_ppop(_GSET);

	switch (status & 7)
	{
		case BNORMAL:
			set_fcolor(CScheme->slider);
			Boxw(GetX() + 1, GetY() + 1, GetW() - 3, GetH() - 3);
			frame(GetX(),GetY(),GetW(), GetH());
			if (poly<*p_size)
				frame(GetX()+2, GetY()+1+((*val-minv)/steps),12,16,1);
			set_colors(CBLACK, CScheme->slider);
			break;

		case BDISABLED:
			break;

		case BUNVISIBLE:
			set_fcolor(GetPaper());
			Boxw(GetX(), GetY(), GetW(), GetH());
			break;
	}
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

void ListBox::ClickMove(int, int dy)
{
	modify(dy-GetY()-10+owner->ywrk);
}

void ListBox::ClickDown(void)
{
	modify((GetMouseY()-owner->GetY())-GetY()-10);
}

void ColorDialog::SetColorsProc(GuiEvent *p)
{
	int	xWnd = p->GetX()-8;
	int	yWnd = p->GetY()-8;
	int item;
	
	ColorDialog *ptr = (ColorDialog *)p->wnd->GetParam();

	switch(p->Type()) 
	{
		case ACCELEVENT:
			if (p->accel->GetLocalId()==0)
			{
#ifdef INDEX_COLORS
					CreateColor(ptr->cd_r>>2, ptr->cd_g>>2, ptr->cd_b>>2, ptr->color);
#endif
				delete p->wnd;
				if (ptr->fnc)
					ptr->fnc(ptr->color);
				ptr->fnc = 0;
				break;
			}
			else if (p->accel->GetLocalId()==1)
			{
				delete wnd;
				break;
			}
			break;
		case TERMINATEEVENT:
#ifdef INDEX_COLORS
//			_set_fgl_palette();
#endif
			break;
		case CLICKLEFTEVENT:
			if (yWnd<0 || xWnd<0) return;
			xWnd = xWnd/20;
			yWnd = yWnd/20;
			if (yWnd>15 || xWnd>15) return;
			item = xWnd + yWnd*16;
			ptr->FocusTo(item);
			break;
	}
}

static void CSliderFnc(CallBack cb)
{
	ColorDialog *ptr = (ColorDialog *)cb->GetParam();
	if (ptr != (ColorDialog *)-1)
		ptr->UpdatePalette();
}

ColorDialog::ColorDialog(char *capture, void (*fnc)(FGPixel), FGPixel bgc)
{
	int i,j;
	ColorDialog::fnc = fnc;
	curr = 0;
	cd_r = cd_g = cd_b = 0;
	wnd = new Window(&wnd, 240, 80, 520, 364, capture, SetColorsProc, 0, bgc, 0x203|WUSELAST|WESCAPE);
	UpdatePalette();
	wnd->SetParam(int(this));
	wnd->AddPushButton(428, 32, 72, 21, "Ok", CR);
	wnd->AddPushButton(428, 64, 72, 21, "Cancel");
	sl1 = wnd->AddSlideBarV(340, 5, 0, 255, 1, &cd_r, CSliderFnc);
	sl1->SetParam(int(this));
	sl2 = wnd->AddSlideBarV(370, 5, 0, 255, 1, &cd_g, CSliderFnc);
	sl2->SetParam(int(this));
	sl3 = wnd->AddSlideBarV(400, 5, 0, 255, 1, &cd_b, CSliderFnc);
	sl3->SetParam(int(this));
	set_ppop(_GSET);
	for(i=0; i<16; i++) for(j=0; j<16; j++)
	{
#ifdef INDEX_COLORS
		wnd->WindowBox(8+j*20,  8+i*20, 16, 16, j+i*16);
		if (ColorsArray[(j+i*16)].alfa)
			wnd->WindowRect(8+j*20-1, 8+i*20-1, 18, 18, CYELLOW);
#else
		wnd->WindowBox(8+j*20,  8+i*20, 16, 16, DirectColor(custom_colors[j+i*16]));
#endif
	}
	FocusTo(0);
	instance = this;
}

void ReleaseCd(void)
{
    if (ColorDialog::instance) delete ColorDialog::instance;
}

void ColorDialog::FocusTo(int a)
		{
			wnd->WindowRect(6+(curr%16)*20, 6+(curr/16)*20, 20, 20, wnd->GetPaper());
			wnd->WindowRect(7+(curr%16)*20, 7+(curr/16)*20, 18, 18, wnd->GetPaper());
			curr=a;
#ifdef INDEX_COLORS
			color = a;
#else
			color = DirectColor(custom_colors[curr]);
#endif
			wnd->WindowBox(428,128,72,72,color);
			wnd->WindowRect(6+(curr%16)*20, 6+(curr/16)*20, 20, 20, 0);
			wnd->WindowRect(7+(curr%16)*20, 7+(curr/16)*20, 18, 18, 0);
			wnd->SetColors();
			wnd->printf(450,8,"%03d\n", curr);
#ifdef INDEX_COLORS
			unsigned pal = get_palette(curr);
			cd_r = pal>>14;
			cd_g = (pal>>6)&255;
			cd_b = (pal<<2)&255;
#else
			cd_r = custom_colors[curr]>>16;
			cd_g = (custom_colors[curr]>>8)&255;
			cd_b = custom_colors[curr]&255;
#endif
			sl1->redraw();
			sl2->redraw();
			sl3->redraw();
			UpdatePalette();
		}

void ColorDialog::UpdatePalette(void)
	{
#ifdef INDEX_COLORS
			unsigned pal = ((cd_r<<14) + (cd_g<<6) + (cd_b>>2)) & 0x3f3f3f;
			__palette(curr, pal);
#else
			custom_colors[curr] = (cd_r<<16) + (cd_g<<8) + cd_b;
			color = DirectColor(custom_colors[curr]);
			wnd->WindowBox(428,128,72,72,color);
			wnd->WindowBox(8+(curr%16)*20, 8+(curr/16)*20, 16, 16, color);
#endif
			wnd->SetColors();
			wnd->printf(438,240,"R: %03d\n", cd_r);
			wnd->printf(438,260,"G: %03d\n", cd_g);
			wnd->printf(438,280,"B: %03d\n", cd_b);
	}

int ColorDialog::Import(char *name)
{
			FILE *f = fopen(name, "rb");
			int i;
			if (f)
			{
#ifdef INDEX_COLORS
				for(i=0; i<256; i++) custom_colors[i] = _fgl_palette[i]<<2;
#endif
				int rc = fread(custom_colors, sizeof(custom_colors), 1, f);
				fclose(f);
#ifdef INDEX_COLORS
				for(i=0; i<256; i++) _fgl_palette[i] = custom_colors[i]>>2;
#endif
				return rc;
			}
			return 0;
}

int ColorDialog::Export(char *name)
{
			FILE *f = fopen(name, "wb");
			if (f)
			{
#ifdef INDEX_COLORS
				for(int i=0; i<256; i++) custom_colors[i] = _fgl_palette[i]<<2;
#endif
				int rc = fwrite(custom_colors, sizeof(custom_colors), 1, f);
				fclose(f);
				return rc;
			}
			return 0;
}

