/*
    OpenGUI - Drawing & Windowing library

    Copyright (C) 1996,2000  Marian Krivos

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    nezmar@internet.alcatel.sk
    
    Framebuffer library headers and prototypes 
*/


#ifndef _OFBIS_H_
#define _OFBIS_H_

#include <linux/fb.h>

/* FBError defines */

#define SYSERR	0x0002
#define	FATAL	0x0001
#define WARNING	0x0000

/* Error handling function */

void FBerror(unsigned short flags, const char *fmt,...);
void FBshutdown(void);

typedef struct fbcmap
{
	int start;
	int end;
	int len;
	unsigned short *red;
	unsigned short *green;
	unsigned short *blue;
}
FBCMAP;

typedef struct fbinf FB;

struct fbinf
{
	int fb;						/* fb file descriptor */
	int tty;					/* tty file desc. */
	int ttyno;					/* VT number */
	unsigned short visible;		/* Is VT visible? */
	unsigned short *sbuf;		/* addr of frame buf */
	unsigned short *sbak;		/* addr of backing store */
	struct fb_fix_screeninfo finf;	/* fixed screen info */
	struct fb_var_screeninfo vinf;	/* variable screen info */
	FBCMAP *cmap;				/* current colourmap */

};

/* misc defines */

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

/* init/deinit functions */

/* options for FBopen */

#define FB_OPEN_NEW_VC      0x0001

FB *FBopen(const char *fbname, unsigned short opts, int, int);
int FBclose(FB * f);

/* VT handling functions */
static void FBVTopen(FB * f);
static void FBVTclose(FB * f);
static void FBVTswitch(int s);
void FBVTswitchoriginal(FB * f);
void FBVTswitchfb(FB * f);
extern unsigned short switching;

/* lowlevel drawing functions */

static void FBgetfix(FB * f);
static void FBgetvar(FB * f);
static void FBputvar(FB * f);

/* colourmap functions */

//static FBCMAP *FBgetcmap(FB * f);
//static void FBputcmap(FB * f, FBCMAP * fbcmap);
//static void FBfreecmap(FBCMAP * fbcmap);

/* event declarations and functions */

typedef int FBListKeyType;
typedef FB *FBListValType;

typedef struct fb_lnde
{
	FBListKeyType key;
	FBListValType val;
	struct fb_lnde *next;
}
 *FBListNode;

typedef FBListNode *FBList;

#endif /* _OFBIS_H_ */
