/*
    OpenGUI - Drawing & Windowing library

    Copyright (C) 1996,2000  Marian Krivos

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    nezmar@internet.alcatel.sk

    kernel.cc - linux framebuffer support   
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <stdarg.h>
#include <ctype.h>

extern "C" {

#include "config.h"
#include "base.h"
#include "_fastgl.h"

#if (!defined(NO_MMX) || !defined(FRAMEBUFFER))
#error This source not support MMX and no FRAMEBUFFER issue
#endif

void outpb(unsigned port, unsigned data)
{
	__asm__ __volatile__ ("outb %%al,%%dx": :"d" (port), "a" (data));
}

void outpw(unsigned port, unsigned data)
{
	__asm__ __volatile__ ("outl %%ax,%%dx": :"d" (port), "a" (data));
}

void outpl(unsigned port, unsigned data)
{
	__asm__ __volatile__ ("outl %%eax,%%dx": :"d" (port), "a" (data));
}

unsigned char inpb(unsigned port)
{
	__asm__ __volatile__ ("inb %%dx,%%al\n"
 							: "=a" (port)
							: "d" (port));
	return port;
}

unsigned short inpw(unsigned port)
{
	__asm__ __volatile__ ("inw %%dx,%%ax\n"
 							: "=a" (port)
							: "d" (port));
	return port;
}

unsigned long inpl(unsigned port)
{
	__asm__ __volatile__ ("inl %%dx,%%eax\n"
 							: "=a" (port)
							: "d" (port));
	return port;
}

void modify_point2(FGPixel *ptr, FGPixel c)
{
	switch (ppop)
	{
		default:
		case 0:
			*ptr =	c;
			break;
		case 1:					// xor
			*ptr^= c;
			break;
		case 2:					// and
			*ptr &= c;
			break;
		case 3:					// or
			*ptr |= c;
			break;
		case 4:					// plus
			*ptr += c;
			break;
		case 5:					// minus
			*ptr -= c;
			break;
		case 6:					// not
			*ptr ^= -1;
			break;
		case 7:					// not
			if (*ptr>=16) *ptr = c;
			break;
		case 8:					// transp
			if (c) *ptr = c;
			break;
	}
}

void L1RamToRam(FGPixel *from,	FGPixel *to, int w, int h, int off1, int off2)
{
	int step1 =	off1+w;
	int step2 =	off2+w;
	for(int i=0; i<h; i++)
	{
		FGmemcpy(to,from,w);
		from += step2;
		to += step1;
	}
}

void L1RamToRamPpop(FGPixel *from,	FGPixel *to, int w, int h, int off1, int off2)
{
	int step1 =	off1+w;
	int step2 =	off2+w;
	for(int i=0; i<h; i++)
	{
		FGmemcpy2(to,from,w);
		from += step2;
		to += step1;
	}
}

// fill box in buffer without drawmode
void L1Box(FGPixel	*ptr, int w, int h, int xoffset)
{
	xoffset += w;
	for(;h>0;h--)
	{
		FGmemset(ptr, _CurrColor, w);
		ptr += xoffset;
	}
}

void L1BoxX(FGPixel	*ptr, int w, int h, int xoffset)
{
	xoffset += w;
	for(;h>0;h--)
	{
		FGmemset2(ptr, _CurrColor, w); // !!!!!!!!!!!!!!
		ptr += xoffset;
	}
}

// copy block from video to RAM
void L1VideoToRam8(FGPixel	*from, FGPixel	*to, int off1, int off2, int w, int h)
{
	off1 += w;
	off2 += w;
	for(;h>0;h--)
	{
		FGmemcpy(to, from, w); // !!!!!!!!!!!!!!
		from += off1;
		to += off2;
	}
}

void L1RamToVideo8(FGPixel	*from, FGPixel *to, int w,	int h, int off1, int off2)
{
	L1VideoToRam8(from,to,w,h,off1,off2);
}

void L1RamToVideo2(FGPixel	*from, FGPixel *to, int w,	int h, int off1, int off2)
{
	assert(0); // do not reach
}

void LinuxInit(void)
{
    printf("Currently you run a generic version (without asm kernel)\n");
}

int set_ppop(int val)
{
	int tmp = ppop;
	ppop = val;
	return tmp;
}

void draw_point(int x, int y)
{
	if (y <	clip_y_min || x < clip_x_min || y >= clip_y_max || x >= clip_x_max) return;
	modify_point(videobase + X_width * y + x);
}

int get_point(int x, int y)
{
	if (y <	clip_y_min || x < clip_x_min || y >= clip_y_max || x >= clip_x_max) return 256;
	return *(videobase + X_width * y + x);
}

void draw_hline(int x, int y, int len)
{
	if (ppop) FGmemset2(videobase + X_width * y + x, _CurrColor, len);
	else FGmemset(videobase + X_width * y + x, _CurrColor, len);
}

void draw_vline(int x, int y, int len)
{
	for(;len>0;len--) draw_point(x,y++);
}

void _fill_rect(int x, int y, int w, int h)
{
	assert(lfb); // this is not permitted without linear addressing
	for(;h>0;h--) draw_hline(x,y++,w);
}

#ifdef TRUE_COLORS
void CharOutClip(FGPixel *dst, FGPixel *src, int step)
{
	int i;
	FGPixel ink=_CurrColor;
	FGPixel paper=_CurrBkColor;

	for(i=0;i<fonth;i++) switch(fontw>>2)
	{
		case 4:
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
		case 3:
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
		case 2:
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
		case 1:
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
			*dst++ = *src++?ink:paper;
			dst += (step - fontw);
	}
}
#else
void CharOutClip(FGPixel *dst, FGPixel *src, int step)
{
	int i;
	unsigned c,
	ink=_CurrColor+(_CurrColor<<8)+(_CurrColor<<16)+(_CurrColor<<24),
	paper=_CurrBkColor+(_CurrBkColor<<8)+(_CurrBkColor<<16)+(_CurrBkColor<<24);
	for(i=0;i<fonth;i++) switch(fontw>>2)
	{
		case 4:
			c = *(int *)src;
		  	c = (c&ink) | (~c&paper);
			*(int *)dst = c;
			src += 4;
			dst += 4;
		case 3:
			c = *(int *)src;
		  	c = (c&ink) | (~c&paper);
			*(int *)dst = c;
			src += 4;
			dst += 4;
		case 2:
			c = *(int *)src;
		  	c = (c&ink) | (~c&paper);
			*(int *)dst = c;
			src += 4;
			dst += 4;
		case 1:
			c = *(int *)src;
		  	c = (c&ink) | (~c&paper);
			*(int *)dst = c;
			src += 4;
			dst += (4 + step - fontw);
	}
}
#endif // TRUE_COLORS

//
// NOTE! this runs with pixels not bytes !!!
//
void FGmemcpy2(FGPixel *to, FGPixel *from, unsigned c)
{
	int cc;
#ifndef TRUE_COLORS
	cc = c>>2;
#else
	cc = c;
#endif
	__asm__ ("cld");
	switch(ppop)
	{
	default:
	case _GSET:
		if (cc<4) // if less than 16 bytes
		{
			__asm__ __volatile__ ("rep\n\t movsb" : : "c" (c) , "D" (to) , "S" (from));
		}
		else
		{
			__asm__ __volatile__ ("rep\n\t movsl" : : "c" (cc) , "D" (to) , "S" (from) );
			if (c &=3) __asm__ __volatile__ ("rep\n\t movsb" : : "c" (c) );
		}
		break;
	case _GAND:
		if (cc<4) // if less than 16 bytes
		{
			__asm__ __volatile__ ("1:movb (%%esi),%%al\n\t"
 			"andb %%al,(%%edi)\n\t "
			"inc %%esi\n\t "
			"inc %%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (c) , "D" (to) , "S" (from));
		}
		else
		{
			__asm__ __volatile__ ("1:movl (%%esi),%%eax\n\t"
 			"andl %%eax,(%%edi)\n\t "
			"addl $4,%%esi\n\t "
			"addl $4,%%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (cc) , "D" (to) , "S" (from) );
			if (c &=3)
			{
				__asm__ __volatile__ ("1:movb (%%esi),%%al\n\t"
 				"andb %%al,(%%edi)\n\t "
				"inc %%esi\n\t "
				"inc %%edi\n\t "
				"dec %%ecx\n\t jnz 1b"
				: : "c" (c) , "D" (to) , "S" (from));
			}
		}
		break;
	case _GOR:
		if (cc<4) // if less than 16 bytes
		{
			__asm__ __volatile__ ("1:movb (%%esi),%%al\n\t"
 			"orb %%al,(%%edi)\n\t "
			"inc %%esi\n\t "
			"inc %%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (c) , "D" (to) , "S" (from));
		}
		else
		{
			__asm__ __volatile__ ("1:movl (%%esi),%%eax\n\t"
 			"orl %%eax,(%%edi)\n\t "
			"addl $4,%%esi\n\t "
			"addl $4,%%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (cc) , "D" (to) , "S" (from) );
			if (c &=3)
			{
				__asm__ __volatile__ ("1:movb (%%esi),%%al\n\t"
 				"orb %%al,(%%edi)\n\t "
				"inc %%esi\n\t "
				"inc %%edi\n\t "
				"dec %%ecx\n\t jnz 1b"
				: : "c" (c) , "D" (to) , "S" (from));
			}
		}
		break;
	case _GXOR:
		if (cc<4) // if less than 16 bytes
		{
			__asm__ __volatile__ ("1:movb (%%esi),%%al\n\t"
 			"xorb %%al,(%%edi)\n\t "
			"inc %%esi\n\t "
			"inc %%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (c) , "D" (to) , "S" (from));
		}
		else
		{
			__asm__ __volatile__ ("1:movl (%%esi),%%eax\n\t"
 			"xorl %%eax,(%%edi)\n\t "
			"addl $4,%%esi\n\t "
			"addl $4,%%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (cc) , "D" (to) , "S" (from) );
			if (c &=3)
			{
				__asm__ __volatile__ ("1:movb (%%esi),%%al\n\t"
 				"xorb %%al,(%%edi)\n\t "
				"inc %%esi\n\t "
				"inc %%edi\n\t "
				"dec %%ecx\n\t jnz 1b"
				: : "c" (c) , "D" (to) , "S" (from));
			}
		}
		break;
	}
}

//
// NOTE! this runs with pixels not bytes !!!
//
void FGmemset2(FGPixel *to, FGPixel data, unsigned c)
{
	__asm__ ("cld");
#ifndef TRUE_COLORS
	int cc;
	cc = c>>2;
	switch(ppop)
	{
	default:
	case _GSET:
		if (cc<4) // if less than 16 bytes
			__asm__ __volatile__ ("rep\n\t stosb" : : "c" (c) , "D" (to), "a" (data));
		else
		{
			__asm__ __volatile__ ("mov %%al,%%ah\n pushw %%ax\n pushw %%ax\n popl %%eax\n rep\n\t stosl" : : "c" (cc) , "D" (to), "a" (data));
			if (c &= 3) __asm__ __volatile__ ("rep\n\t stosb" : : "c" (c), "a" (data));
		}
		break;
	case _GOR:
		if (cc<4) // if less than 16 bytes
		{
			__asm__ __volatile__ ("1:orb %%al,(%%edi)\n\t "
			"inc %%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (c) , "D" (to) , "a" (data));
		}
		else
		{
			__asm__ __volatile__ ("mov %%al,%%ah\n pushw %%ax\n pushw %%ax\n popl %%eax\n 1:orl %%eax,(%%edi)\n\t "
			"addl $4,%%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (cc) , "D" (to) , "a" (data) );
			if (c &=3)
			{
				__asm__ __volatile__ ("1:orb %%al,(%%edi)\n\t "
				"inc %%edi\n\t "
				"dec %%ecx\n\t jnz 1b"
				: : "c" (c) , "D" (to) , "a" (data));
			}
		}
		break;
	case _GXOR:
		if (cc<4) // if less than 16 bytes
		{
			__asm__ __volatile__ ("1:xorb %%al,(%%edi)\n\t "
			"inc %%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (c) , "D" (to) , "a" (data));
		}
		else
		{
			__asm__ __volatile__ ("mov %%al,%%ah\n pushw %%ax\n pushw %%ax\n popl %%eax\n 1:xorl %%eax,(%%edi)\n\t "
			"addl $4,%%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (cc) , "D" (to) , "a" (data) );
			if (c &=3)
			{
				__asm__ __volatile__ ("1:xorb %%al,(%%edi)\n\t "
				"inc %%edi\n\t "
				"dec %%ecx\n\t jnz 1b"
				: : "c" (c) , "D" (to) , "a" (data));
			}
		}
		break;
	case _GAND:
		if (cc<4) // if less than 16 bytes
		{
			__asm__ __volatile__ ("1:andb %%al,(%%edi)\n\t "
			"inc %%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (c) , "D" (to) , "a" (data));
		}
		else
		{
			__asm__ __volatile__ ("mov %%al,%%ah\n pushw %%ax\n pushw %%ax\n popl %%eax\n 1:andl %%eax,(%%edi)\n\t "
			"addl $4,%%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (cc) , "D" (to) , "a" (data) );
			if (c &=3)
			{
				__asm__ __volatile__ ("1:andb %%al,(%%edi)\n\t "
				"inc %%edi\n\t "
				"dec %%ecx\n\t jnz 1b"
				: : "c" (c) , "D" (to) , "a" (data));
			}
		}
		break;
	case _GNOT:
		if (cc<4) // if less than 16 bytes
		{
			__asm__ __volatile__ ("1:notb (%%edi)\n\t "
			"inc %%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (c) , "D" (to) , "a" (data));
		}
		else
		{
			__asm__ __volatile__ ("1:notl (%%edi)\n\t "
			"addl $4,%%edi\n\t "
			"dec %%ecx\n\t jnz 1b"
			: : "c" (cc) , "D" (to) , "a" (data) );
			if (c &=3)
			{
				__asm__ __volatile__ ("1:notb (%%edi)\n\t "
				"inc %%edi\n\t "
				"dec %%ecx\n\t jnz 1b"
				: : "c" (c) , "D" (to) , "a" (data));
			}
		}
		break;
	}
#else
	switch(ppop)
	{
	default:
	case _GSET:
		__asm__ __volatile__ ("rep\n\t stosl" : : "c" (c) , "D" (to) , "a" (data));
		break;
	case _GOR:
		__asm__ __volatile__ ("1:orl %%eax,(%%edi)\n\t "
		"addl $4,%%edi\n\t "
		"dec %%ecx\n\t jnz 1b"
		: : "c" (c) , "D" (to) , "a" (data) );
		break;
	case _GXOR:
		__asm__ __volatile__ ("1:orl %%eax,(%%edi)\n\t "
		"addl $4,%%edi\n\t "
		"dec %%ecx\n\t jnz 1b"
		: : "c" (c) , "D" (to) , "a" (data) );
		break;
	case _GAND:
		__asm__ __volatile__ ("1:andl %%eax,(%%edi)\n\t "
		"addl $4,%%edi\n\t "
		"dec %%ecx\n\t jnz 1b"
		: : "c" (c) , "D" (to) , "a" (data) );
		break;
	case _GNOT:
		__asm__ __volatile__ ("1:notl (%%edi)\n\t "
		"addl $4,%%edi\n\t "
		"dec %%ecx\n\t jnz 1b"
		: : "c" (c) , "D" (to) , "a" (data) );
		break;
	}
#endif
}

//
// NOTE! this runs with pixels not bytes !!!
//
void FGmemcpy(FGPixel *to, FGPixel *from, unsigned c)
{
	__asm__ ("cld");

    // workaround for a bug in GCC
    // changed regs ecx,esi,edi are not clobbered but not saved !!!!

//	__asm__ ("pushl %ecx");
//	__asm__ ("pushl %esi");
//	__asm__ ("pushl %edi");
#ifndef TRUE_COLORS
	int cc;
	while(int(to)&3)
 	{
		if (--c & 0x80000000) return;
		*to++=*from++;
	}
	cc = c>>2;
	if (cc<4) // if less than 16 bytes
	{
		__asm__ __volatile__ ("rep\n\t movsb" : : "c" (c) , "D" (to) , "S" (from));
	}
	else
	{
		__asm__ __volatile__ ("rep\n\t movsl" : : "c" (cc) , "D" (to) , "S" (from));
		if (c &=3) __asm__ __volatile__ ("rep\n\t movsb" : : "c" (c));
	}
#else
	__asm__ __volatile__ ("rep\n\t movsl" : : "c" (c) , "D" (to) , "S" (from));
#endif
//	__asm__ ("popl %edi");
//	__asm__ ("popl %esi");
//	__asm__ ("popl %ecx");
}

}


