/*
    OpenGUI - Drawing & Windowing library

    Copyright (C) 1996,2000  Marian Krivos

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    nezmar@internet.alcatel.sk

    fastgl.cc - graphics engine
*/
#include <stdarg.h>
#include <stdlib.h>
#ifdef __WATCOMC__
#ifdef __DOS__
#include <direct.h>
#else
#include <dirent.h>
#endif // dos
#else
#include <dirent.h>
#endif // watcom


#pragma implementation "fastgl.h"

#include "config.h"
#include "fastgl.h"
#include "_fastgl.h"

extern void ReleaseFd(void);
extern void ReleaseCd(void);

//
// Global definitions & declaration
//

int BaseGui::counter = 0;		// counter of all graph. objects
int Window::allControls = 0;	// numbers of all buttons
int Window::hresult = 0;		// numbers of all buttons
int Window::rebuild = 1;		// flag
int Window::nWnd = 0;			// numbers of all windows
Window *Window::current = (Window *) 0;
Window *Window::first = (Window *) 0;
void (*App::DelayProc) (void) = 0;
void (*App::OnEverySecond)(int) = 0;
static Window *Colise = 0;
char EditBox::buf[128], EditBox::clip[128];
int EditBox::is_clip;
GuiEvent *App::event, *App::queque;
MainHwnd App::appHandler;
int App::quequeIndex = 0;
char App::currdir[128];
char * App::homedir = 0;
int WindowDatabase::xyCounter = 0;
WindowDatabase *entryPoint;
App *cApp;
static BaseMenu *inmenu;
Control * call_handler = 0; // set if need call handler (in translateevent)
MenuWindow *MenuWindow::CurrentMenu=0;
Control *Control::cControl=0;
GuiHwnd MenuWindow::Proc=0;
static PolygonStruct psw;
Config *cCfg;
static unsigned int CRCTab[256];
int allBitmapCounter=0;
int MOVEABLE = 1, verbose;
Window *App::Root = 0;
static int DoRootWindow = 0;
static int shut_down = 0;
static Window *errWindow = 0;
static int alty[26] = { 
ALT_A,ALT_B,ALT_C,ALT_D,ALT_E,ALT_F,ALT_G,ALT_H,
ALT_I,ALT_J,ALT_K,ALT_L,ALT_M,ALT_N,ALT_O,ALT_P,
ALT_Q,ALT_R,ALT_S,ALT_T,ALT_U,ALT_V,ALT_W,ALT_X,
ALT_Y,ALT_Z };
int FGx, FGy;

static void InitCRC(void);

class IconWindow : public Window
{
		Window *original;
		static void Proc(GuiEvent *p)
		{
			IconWindow *pp = (IconWindow *)p->wnd;
			if (p->Type()==CLICKRIGHTEVENT) pp->original->WindowIconize();
			if (p->Type()==KEYEVENT && p->Key()==ALT_F02) pp->original->WindowIconize();
			if (p->Type()==WINDOWMOVEEVENT)
			{
				entryPoint->DatabaseSetIcon(p->GetX(), p->GetY(), pp->original->GetName());
				pp->original->SetIconPosition(p->GetX(), p->GetY());
			}
		}
	public:
		IconWindow(Window *parent, int xs, int ys, DrawBuffer *ico)
			: Window(0, xs, ys, ico?ico->GetW()+4:48, ico?ico->GetH()+4:48, "Icon", Proc, 0, CWHITE, WNOPICTO|WICONWINDOWTYPE|WCLICKABLE)
		{
			icon = ico;
			if (icon==0)
				icon = new DrawBuffer(44, 44, BMP_MEM, CGRAYED);
			original = parent;
			original->WindowAttachIcon(icon);
			WindowBox(0,0,w,h,CBLUELIGHT);
			WindowSetWorkRect(2,2,w-4,h-4);
			set_ppop(_GSET);
			WindowText(4,24,"ICON",CWHITE,CGRAYED);
			draw();
		}
		virtual void draw(void)
		{
			if (icon)
			{
//				get_block(x, y, w,h,image);
//				set_ppop(_GTRANSP);
				WindowPutBitmap(0,0,0,0,w,h,icon);
				set_ppop(_GSET);
			}
		}
};

static ColorScheme _CS =
{
	CWHITED, CBLACK, // window colors
	CBLUELIGHT, // active title
	CBROWN,		// inactive title
	CWHITE,		// wnd border 1
	CBLACK,		// wnd border 2
	CGRAY2,		// wnd border 3
	CWHITED,	// statusbar
	CWHITE,		// menu bg
	CBLACK,		// menu fore
	CBLACK,		// menu bg active
	CWHITE,		// menu fore active
	CBLACK,		// pbutton fore
	CGRAY1,		// pbutton back
	CDARK,		// pbutton fore - pushed
	CGRAY2,		// pbutton back - pushed
	CWHITE,		// control::frame1
	CBLACK,		// control::frame2
	CGRAYED,	// control::frame3
	CWHITE,		// edit back
	CBLACK,		// edit fore
	CDARK, 		// edit bord1
	CGRAY3,		// edit bord2
	CGRAY1,		// slider
	CGRAY3,		// menuwindow back
	CBLACK,		// menuwindow fore
	CBLUELIGHT, // pdmenu back
	CWHITE,		// pdmenu fore
	CGRAY1,		// pdmenu gray
	CGRAY1,		// editbox disable
};

ColorScheme * CScheme = &_CS;

//
// Source code
// --------------------------------------------------------------------------
//
// Internal
//
Window * Window::Context(void)
{
	Window *tmp = current;
	current = this;
	if (!current) return this;
#if 1
	current->tmp_ink   = _CurrColor;
	current->tmp_paper = _CurrBkColor;
	current->tmp_ppop  = ppop;
	current->tmp_font  = fontn;
	_CurrColor   = tmp_ink;
	_CurrBkColor = tmp_paper;
	ppop         = tmp_ppop;
	fontn        = tmp_font;
#endif
	Image = image;
	cx_max = w;
	cy_max = h;
	cx_work = xwrk;
	cy_work = ywrk;
	cx_maxwork = wwrk;
	cy_maxwork = hwrk;
	return tmp;
}

// kresli ikonky na titulok okna
void Window::PiktoMem(int x, int y)
{
	int action= status&WMINIMIZE?1:0;
	action |= status&WNOPICTO?0:2;
	switch(action)
	{
		case 0:	// nothing
			break;
		case 3:	// all (minimize+close)
			RamToRam(0, 0, PICTOSIZE*2, PICTOSIZE, x, y, w,h, PICTOSIZE*2, PICTOSIZE, _internal_bitmap0, Image);
			break;
		case 1:	// (minimize)
			RamToRam(0, 0, PICTOSIZE*2, PICTOSIZE, x+PICTOSIZE, y, w,h, PICTOSIZE, PICTOSIZE, _internal_bitmap0, Image);
			break;
		case 2:	// (close)
			RamToRam(PICTOSIZE, 0, PICTOSIZE*2, PICTOSIZE, x+PICTOSIZE, y, w,h, PICTOSIZE, PICTOSIZE, _internal_bitmap0, Image);
			break;
	}
}

//
// A traditional printf in window form
//

int Window::printf(const char *format,...)
{
	char s[256];
	va_list arglist;

	va_start(arglist, format);
	vsprintf(s, format, arglist);
	va_end(arglist);
	puts(s);
	return strlen(s);
}

//
// A traditional printf in window form + position
//

int Window::printf(int xx, int yy, const char *format,...)
{
	char s[256];
	if (xx<0 || xx>w || yy<0 || yy>h) return 0;
	move(xx, yy);
	va_list arglist;

	va_start(arglist, format);
	vsprintf(s, format, arglist);
	va_end(arglist);
	puts(s);
	return strlen(s);
}

//
// Put char to window at current print position
//

void Window::wputc(int c)
{
	Window *tmp = current;

	Context();

	if (c == -1)
	{
		WindowRepaint(0 + xwrk, ypos + ywrk, xpos + xwrk, fonth);
		tmp->Context();
		return;
	}
	if (xpos == -1)
	{
		WindowScrollUp(0, fonth, wsur, hsur - fonth - hsur % fonth, fonth);
		xpos = 1;
	}
	if (xpos < (wsur - xwrk))
	{
		if (c == '\n')
		{
			if (ypos > (hsur - fonth * 2))
			{
				WindowRepaint(0 + xwrk, ypos + ywrk, xpos + xwrk, fonth);
				xpos = -1;
			}
			else
			{
				WindowRepaint(0 + xwrk, ypos + ywrk, xpos + xwrk, fonth);
				ypos += fonth;
				xpos = 1;
			}
		}
		else
		{
			Text(xpos + xwrk, ypos + ywrk, (char *) &c);
			xpos += fontw;
		}
	}
	else
	{
		xpos -= fontw;
		wputc('\n');
		wputc(c);
	}
	tmp->Context();
}

//
// Internal
//
void BaseGui::PositionCheck(int &xx, int &yy, int &ww, int &hh)
{
	if (ww > X_width) ww = X_width;
	if (hh > Y_width) hh = Y_width;
	if (ww < 8)	ww = 8;
	if (hh < 8)	hh = 8;
	if (status&WALIGNED)
	{
		xx &= ~3;
		yy &= ~3;
		ww &= ~3;
		hh &= ~3;
	}
	if ((xx + ww) >= X_width) xx = X_width - ww;
	if (xx < 0)	xx = 0;
	if ((yy + hh - 1) >= Y_width) yy = Y_width - hh;
	if (yy < 0)	yy = 0;
}

/*
 * return 0 if in window area
 * else 1 for title
 * 2 for close
 * 3 for minimize
 * 4 for resize
 */
int Window::TitleFind(GuiEvent * e)
{
	if ((x <= e->GetX()) && ((x + w) >= e->GetX()))
	{
		if (((x + w - 13) <= e->GetX()) &&
			((y + h - 13 <= e->GetY()) && ((y + h) >= e->GetY())) && status & WSIZEABLE)
				return 4;
		if (status & WTITLED)
		{
			if ((y <= e->GetY()) && ((y + 3+TITLEH) >= e->GetY()))
			{
				if (!(status & WNOPICTO)) // close or close&minimize
				{
					if (e->GetX() >= (x + w - 3 - PICTOSIZE))
						return 2;
					if (e->GetX() >= (x + w - 3 - PICTOSIZE*2))
						if (status&WMINIMIZE) return 3;
						else return 0;
				}
				else if (status & WMINIMIZE)
				{
					if (e->GetX() >= (x + w - 3 - PICTOSIZE))
						return 3;
				}
				return 1;
			}
		}
		else if (status & WUNMOVED) return 0;
		else if ((y <= e->GetY()) && ((y + h) >= e->GetY()) && status&WICONWINDOWTYPE)
			return 1;
		else if ((y <= e->GetY()) && ((y + TITLEH+3) >= e->GetY()))
			return 1;
	}
	return 0;
}

volatile void DestroyWindow(void)
{
	int c = Window::nWnd;
	if (c && verbose) printf("WARNING: %d window(s) not closed at exit\n", c);
}

int	Window::_over(int xa1, int ya1, int xa2, int ya2, int xx, int yy, int ww, int hh)
{
	register int xb1 = xx, xb2 = xx + ww, yb1 = yy, yb2 = yy + hh;

	if ((xa1 <= xb1 && xa2 >= xb1) || (xa1 <= xb2 && xa2 >= xb2))	// x sa prekryva
	{
		if (ya1 <= yb1 && ya2 >= yb1)
		{
			return 1;
		}
		if (ya1 <= yb2 && ya2 >= yb2)
		{
			return 2;
		}
		if (yb1 <= ya1 && yb2 >= ya1)
		{
			return 3;
		}
		if (yb1 <= ya2 && yb2 >= ya2)
		{
			return 4;
		}
	}
	else if ((xb1 <= xa1 && xb2 >= xa1) || (xb1 <= xa2 && xb2 >= xa2))
	{
		if ((yb1 <= ya1 && yb2 >= ya1))
		{
			return 5;
		}
		if ((yb1 <= ya2 && yb2 >= ya2))
		{
			return 6;
		}
		if (ya1 <= yb1 && ya2 >= yb1)
		{
			return 7;
		}
		if (ya1 <= yb2 && ya2 >= yb2)
		{
			return 8;
		}
	}
	return 0;
}

//
// redraw block unconditionally
//
void Window::WindowUpdateBlock(int x, int y, int w, int h)
{
	Context();
	WindowClip(x,y,w,h);
	RepaintBlock(x,y,w,h);
}

void Window::HideAll(void)
{
	set_fcolor(cApp->background);

	if (!(cApp->flags&APP_ROOTWINDOW)) clear_frame_buffer(cApp->background);
	else App::GetRootWindow()->WindowUpdateBlock(0,0,X_width,Y_width);
}

void Window::ShowAll(void)
{
	BaseGui *p = (BaseGui *)first;
	Window *pw;
	
	while (p)
	{
		pw = (Window *)p;
		pw->WindowUpdateBlock(0,0, pw->GetW(), pw->GetH());
		p = p->GetNext();
	}
}

//
// params are real size & position of cleared window
//
void Window::intersect(int _x, int _y, int _w, int _h)
{
	Window *p = first;
	Window *tmp = current;
	int rc;
	
	set_ppop(_GSET);
	set_fcolor(cApp->background);

	if (!(cApp->flags&APP_ROOTWINDOW)) fill_box(_x,_y,_w,_h);
	else App::GetRootWindow()->WindowUpdateBlock(_x,_y,_w,_h);
	
	// now we trace all windows from down to *this*
	while (p)
	{
		if (!(p->status&WHIDEN) && p!=this)
		{
			rc=_over(p->x, p->y, p->x+p->w, p->y+p->h, _x, _y, _w, _h);
			if (rc)
			{
				p->WindowUpdateBlock(_x-p->GetX(), _y-p->GetY(), _w, _h);
			}
		}
		p =	(Window *) ((BaseGui *)p)->GetNext();
	}
	tmp->Context();
}

//
// redraw window intersection with original background
// dx,dy are deltas from original
void Window::WindowUpdate(int dx, int dy, int all)
{
	if (all || abs(dx) > w || abs(dy) > h)
	{
		intersect(x,y,w,h);
		return;
	}
	if (dx>0) // right side
	{
		intersect(x,y,dx,h);
	}
	if (dy>0) // up side
	{
		intersect(x,y,w,dy);
	}

	if (dx<0) // left side
	{
		intersect(x+w+dx,y,-dx,h);
	}
	if (dy<0) // down side
	{
		intersect(x,y+h+dy,w,-dy);
	}
}

//
// Test overlaping window, called from OdkryteOkno only
//
BaseGui *BaseGui::OverSprite(BaseGui * od, int xx, int yy, int ww, int hh)
{
	register int xa1, xa2, ya1, ya2;
	BaseGui *v = 0;
	int xb1 = xx, xb2 = xx + ww, yb1 = yy, yb2 = yy + hh;

	while (od != this)
	{
		if (!(od->status & WHIDEN))
		{
			xa1 = od->x,
				xa2 = od->x + od->w,
				ya1 = od->y,
				ya2 = od->y + od->h;

			if ((xa1 <= xb1 && xa2 >= xb1) ||
				(xa1 <= xb2 && xa2 >= xb2))	// x sa prekryva
			{
				if ((ya1 <= yb1 && ya2 >= yb1) ||
					(ya1 <= yb2 && ya2 >= yb2))
				{
					v = od;
					break;
				}
				else if (yb1 <= ya1 && yb2 >= ya2)
				{
					v = od;
					break;
				}
			}
			else if ((xb1 <= xa1 && xb2 >= xa1) ||
				(xb1 <= xa2 && xb2 >= xa2))
			{
				if ((yb1 <= ya1 && yb2 >= ya1) ||
					(yb1 <= ya2 && yb2 >= ya2))
				{
					v = od;
					break;
				}
				else if (ya1 <= yb1 && ya2 >= yb2)
				{
					v = od;
					break;
				}
			}
		}
		od = od->last;
	}
	return v;
}

//
// Called from WindowRepaint() for the window overlap testing
//
int Window::OdkryteOkno(Window * pokial, int x, int y, int w, int h)
{
	if (!IsVisible())
		return -1;				// je skryte

	if (!GetNext())
		return 0;				// je aktivne

	while (pokial != this)
	{
		if ((Colise = (Window *) OverSprite(pokial, x, y, w, h)) != 0)
		{
			return 1;
		}
		pokial = (Window *) pokial->GetLast();
	}
	return 0;
}

#define Ladenie ::printf
#define area(a,b,c,d) *out++=a,*out++=b,*out++=c,*out++=d; //, debug==1?(Ladenie("a,b,c,d - %d,%d,%d,%d\n",a,b,c,d)):0;

int Window::Rozporcuj(int X1, int Y1, int X2, int Y2, int *in, int *out)
{
	int x1, y1, x2, y2, f;

	if (*in == -1) return 0;
	while (*in != -1)
	{
		x1 = *in++;
		y1 = *in++;
		x2 = *in++;
		y2 = *in++;
		f = 0;
		if (x1 >= X1 && y1 >= Y1 && x2 <= X2 && y2 <= Y2)
			continue;				// cely prekryty

		if (x2 < X1 || y2 < Y1 || x1 > X2 || y1 > Y2)	// cely mimo
		{
			area(x1, y1, x2, y2);
			continue;
		}

		if (x1 <= X1 && x2 >= X1)
		{
			area(x1, y1, X1, y2);
			x1 = X1;
		}

		if (y1 <= Y1 && y2 >= Y1)
		{
			area(x1, y1, x2, Y1);
			y1 = Y1;
		}

		if (x2 >= X2 && x1 <= X2)
		{
			area(X2, y1, x2, y2);
		}

		if (y2 >= Y2 && y1 <= Y2)
		{
			area(x1, Y2, x2, y2);
		}
	}
	*out = -1;
	return 1;
}

//
// aktualizovane okno a relativne suradnice v tomto okne
//
void Window::WindowRepaint(int xr, int yr, int w, int h)
{
	static int zoznam1[320], zoznam2[320], *p1, *p2, *p3;
	BaseGui *posledne = current;

	if (status & WLOCKED)
	{
		status |= WDIRTY;
		return;
	}
	// clipping
	if (xr < 0)
	{
		w += xr;
		xr = 0;
		if (w <= 0)
			return;
	}
	if (yr < 0)
	{
		h += yr;
		yr = 0;
		if (h <= 0)
			return;
	}
	for (; posledne->GetNext(); posledne = posledne->GetNext()); // at the end
#if 0
	if (rebuild)
	{
		BuildOverlays(posledne);
		rebuild = 0;
	}
	int rc = ovr.GetOverlapMap();
	switch(rc)
	{
		case -1:
			status |= WDIRTY;
			return;
		case 0:
			RepaintBlock(xr, yr, w, h);
			return;
	}
	// chyba je v okne Colise a mozno aj v oknach medzi nimy
	posledne = ovr.GetOverlapWindow();
	p1 = zoznam1;
	p1[0] = x + xr;
	p1[2] = p1[0] + w;
	p1[1] = y + yr;
	p1[3] = p1[1] + h;
	p1[4] = -1;
	p2 = zoznam2;		// inicializacia poli
	p2[0] = -1;
//	rc--;
	status |= WDIRTY;
	for (;rc--;)
	{
		if (posledne->IsVisible())
		{
			if (!Rozporcuj(posledne->GetX(), posledne->GetY(), posledne->GetX() + posledne->GetW(), posledne->GetY() + posledne->GetH(), p1, p2))
				return; // ???
			p3 = p1;
			p1 = p2;
			p2 = p3;
		}
		posledne = ovr.GetOverlapNextWindow();
	}
#else
	// test overlap
	switch (OdkryteOkno((Window *) posledne, x + xr, y + yr, w, h))
	{
		case -1:
			status |= WDIRTY;
			return;
		case 0:
			RepaintBlock(xr, yr, w, h);
			return;
	}

	// chyba je v okne Colise a mozno aj v oknach medzi nimy
	posledne = Colise;

	p1 = zoznam1;
	p1[0] = x + xr;
	p1[2] = p1[0] + w;
	p1[1] = y + yr;
	p1[3] = p1[1] + h;
	p1[4] = -1;
	p2 = zoznam2;		// inicializacia poli
	p2[0] = -1;

	status |= WDIRTY;
	for (;;)
	{
		if (posledne->IsVisible())
		{
			if (!Rozporcuj(posledne->GetX(), posledne->GetY(), posledne->GetX() + posledne->GetW(), posledne->GetY() + posledne->GetH(), p1, p2))
				return; // ???
			p3 = p1;
			p1 = p2;
			p2 = p3;
		}
		posledne = posledne->GetLast();
		if (posledne == this) // finito?
			break;
		if (OdkryteOkno((Window *) posledne, x + xr, y + yr, w, h) < 1)
			break;
	}
#endif
	while (*p1 != -1)
	{
		RepaintBlock(p1[0] - x, p1[1] - y, p1[2] - p1[0], p1[3] - p1[1]);
		p1 += 4;
	}
}

//
// clip coor and size to user space
//
void Window::WindowClipUser(int& xr, int& yr, int& wr, int& hr)
{
	if (xr<xwrk)
	{
		wr -= xwrk-xr;
		xr = xwrk;
	}
	if (yr<ywrk)
	{
		hr -= ywrk-yr;
		yr = ywrk;
	}
	if (xr+wr>wwrk)
	{
		wr -= (xr+wr)-wwrk;
	}
	if (yr+hr>hwrk)
	{
		hr -= (yr+hr)-hwrk;
	}
}

//
// clip coor and size to wnd space
//
void Window::WindowClip(int& xr, int& yr, int& wr, int& hr)
{
	if (xr<0)
	{
		wr += xr;
		xr = 0;
	}
	if (yr<0)
	{
		hr += yr;
		yr = 0;
	}
	if (xr+wr>w)
	{
		wr -= (xr+wr)-w;
	}
	if (yr+hr>h)
	{
		hr -= (yr+hr)-h;
	}
}

//
// redraw user space only
//
void Window::WindowRepaintUser(int xr, int yr, int wr, int hr)
{
	WindowClipUser(xr,yr,wr,hr);
	WindowRepaint(xr,yr,wr,hr);
}

void Window::WindowHide(void)
{
	WindowUpdate(0,0,1); // zmaze ho cele podkladom
}

void Window::WindowShow(void)
{
	Window *pom = Context();

	if (!iconized)
	{
		Image = image;
		RepaintBlock(0, 0, w, h);
		SetStatus(GetStatus() & ~(WDIRTY));
	}
	pom->Context();
}

void Window::WindowRecopy(void)
{
	if (!IsVisible()) WindowHide();
	else WindowShow();
}


BaseGui *BaseGui::Over(BaseGui * od, BaseGui * po)
{
	int xa1, xa2, ya1, ya2;
	BaseGui *v = 0;
	int xb1 = po->GetX(), xb2 = po->GetX() + po->GetW(), yb1 = po->GetY(),
	  yb2 = po->GetY() + po->GetH();
	BaseGui *t;

	while (od != po && od)
	{
		if (od->IsVisible())
		{
			xa1 = od->GetX(),
				xa2 = od->GetX() + od->GetW(),
				ya1 = od->GetY(),
				ya2 = od->GetY() + od->GetH();

			if ((xa1 <= xb1 && xa2 > xb1) || (xa1 < xb2 && xa2 >= xb2))	// x sa prekryva
			{
				if ((ya1 <= yb1 && ya2 > yb1) || (ya1 < yb2 && ya2 >= yb2))
				{
					v = od;
					break;
				}
				else if (yb1 <= ya1 && yb2 >= ya2)
				{
					v = od;
					break;
				}
			}
			else if ((xb1 <= xa1 && xb2 > xa1) || (xb1 < xa2 && xb2 >= xa2))
			{
				if ((yb1 <= ya1 && yb2 > ya1) || (yb1 < ya2 && yb2 >= ya2))
				{
					v = od;
					break;
				}
				else if (ya1 <= yb1 && ya2 >= yb2)
				{
					v = od;
					break;
				}
			}
		}
		t = od;
		od = od->GetLast();
	}
	return v;
}

/*
** Simply test to Window intersection
*/
int Window::OverWnd(void)
{
	BaseGui *pokial = current;

	if (!GetNext())	return 0;				// is active
	while (pokial != this && pokial)
	{
		if (Over(pokial, this) != 0) return 1;
		pokial = pokial->GetLast();
	}
	return 0; // no window over this
}

long Window::WindowStatus(long stat)
{
	Window *pom = current;
	int tmp;

	tmp = status;

	Context();
	switch (stat)
	{
		case WHIDE:
			if (!IsVisible()) break;
			status |= WHIDEN;
			WindowRecopy();
			break;

		case WVISIBLE:
			if (IsVisible()) break;
			status &= (~WHIDEN);
			WindowRecopy();
			break;

		case WDEACTIVE:
			DrawTitleMem(CTITLE);
			break;

		case WACTIVE:
			DrawTitleMem(CTITLEACTIVE);
			break;
	}
	pom->Context();
	return tmp;
}

// prepne okno na popredie
void Window::WindowFocus(void)
{
	Window *old = current, *novy = this;
	GuiEvent a1(LOSTFOCUSEVENT), a2(GETFOCUSEVENT);

	if (iconized) novy = iconized;
	novy->FlushInput();
	old->SendToWindow(&a1);
	old = current;

	if (nWnd <= 1) // no more window
		return;
	if (novy == old) // no more to switch
		return;

	old->WindowStatus(WDEACTIVE);	// deactive old

	if (novy == first)				// if switch to first in queque
	{
		first = (Window *) novy->GetNext();
		first->SetLast(0);
	}
	else // switch to other than first
	{
		(novy->GetLast())->SetNext(novy->GetNext());
		(novy->GetNext())->SetLast(novy->GetLast());
	}
	old->SetNext((BaseGui *) novy);	  // exchange
	novy->SetLast((BaseGui *) old);
	novy->SetNext(0);
	rebuild = 1;
	novy->WindowStatus(WACTIVE); // active new
	novy->Context();			 // set context to this
	novy->RepaintBlock(0,0,w,h); // refresh all
	SendToWindow(&a2);
	oldidm = idm = 0;
	oldidw = idw = 0;
}

static char *skipstr(char *s)
{
	while (*s)
	{
		if (*s > ' ')
			return s;
		s++;
	}
	return s;
}

Control::Control(int xs, int ys, int typ, int keycode, int flag, Window * own, Bitmap * bm, ControlCall f):
  BaseGui(xs += own->xwrk, ys += own->ywrk, bm->GetW() + 4, bm->GetH() + 4, 0, typ, 0, 0, flag | WBITMAP)
{
	owner = own;
	icon = bm;
	grp = 0;
	mask = 1;
	if (keycode >= 'a' && keycode <= 'z')
		keycode = toupper(keycode);
	key = keycode;
	fnc = f;
    Window::allControls++;
	local_id = owner->nControls++;
	xr = owner->GetX() + xs;
	yr = owner->GetY() + ys;
	SetLast(owner->lastButton);
	owner->lastButton = this;

	if (!owner->Buttony)		// first control
	{
		owner->Buttony = this;
	}
	else
	{
		GetLast()->SetNext(this);
	}
}

Control::Control(int xs, int ys, int ws, int hs, char *nm, int typ, int keycode, int flag, Window * own, ControlCall f, int p, int i):
  BaseGui(xs += own->xwrk, ys += own->ywrk, ws, hs, nm, typ, i, p, flag)
{
	owner = own;
	icon = 0;
	grp=0;
	mask = 1;
	if (keycode >= 'a' && keycode <= 'z')
		keycode = toupper(keycode);
	key = keycode;
	fnc = f;
    Window::allControls++;
	local_id = owner->nControls++;
	xr = owner->GetX() + xs;
	yr = owner->GetY() + ys;
	SetLast(owner->lastButton);
	owner->lastButton = this;
	if (!owner->Buttony)		// first control
	{
		owner->Buttony = this;
	}
	else
	{
		GetLast()->SetNext(this);
	}
}

Control::~Control()
{
	BaseGui *l, *n;

	if (!owner) return;
	if (this==cControl) cControl = 0; // no more valid
	if (this==call_handler) call_handler = 0;
	l = GetLast();
	n = GetNext();

	if (n == (Control *) 0 && l == (Control *) 0)	// no more windows ...
	{
		owner->Buttony = 0;
	}
	else if (n == (BaseGui *) 0)	// last in queqe

	{
		owner->lastButton = l;
	}
	else if (l == (BaseGui *) 0)	// first in queqe
	{
		owner->Buttony = n;
	}
	else
	{
	}
    Window::allControls--;
	owner->nControls--;
	owner = 0;
}

void Control::Enable(void)
{
	Window *tmp = Window::GetCurrent();

	owner->Context();
	SetStatus((GetStatus() & (~7)) | BNORMAL);
	draw();
	tmp->Context();
}

void Control::Disable(void)
{
	Window *tmp = Window::GetCurrent();

	owner->Context();
	SetStatus((GetStatus() & (~7)) | BDISABLED);
	draw();
	tmp->Context();
}

void Control::ClickUp(int a)	// if TRUE, so call handler
{
	if ((status&7) == BDISABLED) return;
	status ^= WTRIGGER;
	draw();
	if (a) SetActive();
}

void BaseMenu::ClickUp(int a)	// if TRUE, so call handler
{
	if ((status&7) == BDISABLED) return;
	draw();
	FGx = owner->GetX()+x;
	FGy = owner->GetY()+y+20;
	if (a) SetActive();
}

Control *Control::ButtonFind(GuiEvent * e, int n)
{
	Window *curr = Window::GetCurrent();
	Control *p = (Control *) curr->GetCurrentControls();
	int c;

	if (!p || curr->IsIconized())
		return 0;				// niesu buttony alebo je to ikona

	if (e->Key() >= 'a' && e->Key() <= 'z')
		c = toupper(e->Key());
	else c = e->Key();
	
	if (e->Type() == KEYEVENT)
	{
		for (;;)
		{
			if ((p->Key() == c) && (p->GetStatus() & n & 7) == n)
				return p;
			if ((p = (Control *) p->GetNext()) == 0)
				return 0;
		}
	}
	else
	{
		do
		{
			if ((p->owner->GetX() + p->owner->GetW() >= e->GetX()) && ((p->owner->GetY() + p->owner->GetH()) >= e->GetY()))
				if ((p->GetXr() <= e->GetX()) && ((p->GetXr() + p->GetW()) >= e->GetX()))
					if ((p->GetYr() <= e->GetY()) && ((p->GetYr() + p->GetH()) >= e->GetY()))
						if ((p->GetStatus() & n & 7) == n)
						{
							if (p->GetType() == MENUBUTTON || p->GetType() == MENUBUTTON2)
								inmenu = (BaseMenu *) p;
							return p;
						}
						else if (p->GetStatus() == BDISABLED)
						{
							return 0;
						}
		}
		while ((p = (Control *) p->GetNext()) != 0);
	}
	return 0;
}

// najde okno, ktoremu patrila mysia udalost
Window *Window::WindowFind(GuiEvent * e)
{
	return (Window *) BaseGui ::Find(first, e);
}

BaseGui *BaseGui::Find(BaseGui * p, GuiEvent * e)
{
	BaseGui *x = 0;
	if (!p) return p;
	if (p->next)
			x = Find(p->next, e);
	if (x)
		return x;
	if ((p->x <= e->x) && ((p->x + p->w) >= e->x))
	{
		if ((p->y <= e->y) && ((p->y + p->h) >= e->y))
			if (!(p->status & WHIDEN) && (p->type!=PSEUDOWINDOW))
				x = p;
	}
	return x;
}

// najde okno podla nazvu
BaseGui *BaseGui::FindName(BaseGui * p, char *s)
{
	for (; p;)
	{
		if (!strcmp(p->name, s))
			break;
		if (p->next == (BaseGui *) 0)
			return (BaseGui *) 0;
		p = p->next;
	}
	return p;
}

// najde okno podla idw
BaseGui *BaseGui::FindId(BaseGui * p, int idw)
{
	for (; p;)
	{
		if (p->id == idw)
			break;
		if (p->next == (BaseGui *) 0)
			return (BaseGui *) 0;
		p = p->next;
	}
	return p;
}

void Control::frame(void) 
{
	set_fcolor(CScheme->button_bord1);
	Vline(GetX(), GetY(), GetH());
	Hline(GetX(), GetY(), GetW());
	set_fcolor(CScheme->button_bord3); // CGRAYED;
	Vline(GetX() + GetW() - 2, GetY() + 1, GetH() - 2);
	Hline(GetX() + 1, GetY() + GetH() - 2, GetW() - 2);
	set_fcolor(CScheme->button_bord2); // CBLACK;
	Vline(GetX() + GetW() - 1, GetY() + 0, GetH() - 0);
	Hline(GetX() + 0, GetY() + GetH() - 1, GetW() - 1);
}

//
// nakresli button
//
void PushButton::draw(void)
{
	Window *tmp = Window::GetCurrent();
	static char str[128];
	unsigned dl=0, a = set_font(FONT0816), st;

	set_ppop(_GSET);
	owner->Context();
	if (GetName())
	{
		dl = (GetW() - 12) / 8;	// maximalny zobrazitelny pocet znakov

		strncpy(str, GetName(), strlen(GetName()) <= dl ? dl = strlen(GetName()) : dl);
		str[dl] = 0;
	}
	st = GetStatus();
	switch (st & 7)
	{
		case BNORMAL:
			frame();
			if (st & WBITMAP)
			{
				owner->WindowPutBitmap(GetX() + 2 - cx_work, GetY() + 2 - cy_work, 0, 0, icon->GetW(), icon->GetH(), icon);
			}
			else
			{
				set_fcolor(CScheme->button_back);
				Boxw(GetX() + 1, GetY() + 1, GetW() - 3, GetH() - 3);
				set_bcolor(CScheme->button_back);
				set_fcolor(CScheme->button_fore);
				Textw(GetX() + (GetW() / 2 - dl * fontw / 2), GetY() + 1 + (GetH() / 2 - fonth / 2), str);
				Underscore((GetW() / 2 - dl * fontw / 2) , 1 + GetH() / 2 - fonth / 2, CDARK);
			}
			break;

		case BPUSHED:
			set_fcolor(CScheme->button_bord2);
			Boxw(GetX(), GetY(), GetW(), GetH());
			set_fcolor(CScheme->button_bord1);
			Vline(GetX() + GetW() - 2, GetY() + 1, GetH() - 2);
			Hline(GetX() + 1, GetY() + GetH() - 2, GetW() - 2);
			if (st & WBITMAP)
			{
				owner->WindowPutBitmap(GetX() + 2 - cx_work, GetY() + 2 - cy_work, 0, 0, icon->GetW(), icon->GetH(), icon);
			}
			else
			{
				set_fcolor(CScheme->button_back);
				Boxw(GetX() + 2, GetY() + 2, GetW() - 4, GetH() - 4);
				set_bcolor(CScheme->button_back);
				set_fcolor(CScheme->button_fore_pushed);
				Textw(GetX() + (GetW() / 2 - dl * fontw / 2), GetY() + 1 + (GetH() / 2 - fonth / 2), str);
			}
			break;

		case BDISABLED:
			set_fcolor(CScheme->button_bord1);
			Boxw(GetX(), GetY(), GetW(), GetH());
			set_fcolor(CScheme->button_fore_pushed);
			Vline(GetX() + GetW() - 2, GetY() + 1, GetH() - 2);
			Hline(GetX() + 1, GetY() + GetH() - 2, GetW() - 2);
			Rect(GetX(), GetY(), GetW(), GetH());
			set_fcolor(CScheme->button_back);
			Boxw(GetX() + 2, GetY() + 2, GetW() - 4, GetH() - 4);
			set_bcolor(CScheme->button_back);
			set_fcolor(CScheme->button_bord3);
			Textw(GetX() + (GetW() / 2 - dl * fontw / 2), GetY() + 1 + (GetH() / 2 - fonth / 2), str);
			break;

		case BUNVISIBLE:
			set_fcolor(GetPaper());
			Boxw(GetX(), GetY(), GetW(), GetH());
			break;
	}
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

void EditBox::MoveIn(void)
{
	owner->Context();
	set_fcolor(CYELLOW);
	set_ppop(_GSET);
	Rect(GetX() + w1, GetY(), w2, GetH());
	owner->WindowRepaint(GetX() + w1, GetY(), w2, GetH());
}

void EditBox::MoveOut(void)
{
	owner->Context();
	set_fcolor(CScheme->edit_bord1);
	set_ppop(_GSET);
	Rect(GetX() + w1, GetY(), w2, GetH());
	owner->WindowRepaint(GetX() + w1, GetY(), w2, GetH());
}

void PushButton::MoveIn(void)
{
	owner->Context();
	set_fcolor(CYELLOW);
	set_ppop(_GSET);
	Rect(GetX(), GetY(), GetW(), GetH());
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
}

void PushButton::MoveOut(void)
{
	owner->Context();
	frame();
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
}

void PushButton::Push(void)
{
	SetStatus((GetStatus() & (~7)) | BPUSHED | WTRIGGER);
	draw();
}

void PushButton::ClickDown(void)
{
	Push();
}

void PushButton::Release(void)
{
	SetStatus((GetStatus() & (~(7|WTRIGGER))) | BNORMAL);
	draw();
}

void PushButton::ClickUp(int a)	// if TRUE, so call handler
{
	if ((status&7) == BDISABLED) return;
	Release();
	if (a) call_handler = this;
}

void CheckButton::draw(void)
{
	FGPixel *ptr = e_mask;
	static char str[40];
	unsigned dl, a = set_font(FONT0816);
	Window *tmp = Window::GetCurrent();

	owner->Context();
	dl = (GetW() - 12) / 8;		// maximalny zobrazitelny pocet znakov

	strncpy(str, GetName(), strlen(GetName()) <= dl ? dl = strlen(GetName()) : dl);
	str[dl] = 0;
	set_bcolor(GetPaper());
	switch (GetStatus() & 7)
	{
		case BNORMAL:
			set_fcolor(GetInk());
			Textw(GetX() + 24, GetY(), GetName());
			Underscore(24, 0, GetInk());
			break;
		case BDISABLED:
			set_fcolor(CGRAY1);
			Textw(GetX() + 24, GetY(), GetName());
			Underscore(24, 0, GetPaper());
			break;
	}
	if (GetStatus() & WTRIGGER)
	{
		ptr = c_mask;
		if (variable) *variable |= mask;
	}
	else
	{
		ptr = d_mask;
		if (variable) *variable &= ~mask;
	}
	RamToRam(0, 0, 14, 14, GetX(), GetY(), owner->GetW(), owner->GetH(), 14, 14, ptr, Image);
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

void PointButton::draw(void)
{
	static char str[40];
	unsigned dl, a = set_font(FONT0816);
	Window *tmp = Window::GetCurrent();

	owner->Context();
	dl = (GetW() - 12) / 8;		// maximalny zobrazitelny pocet znakov

	strncpy(str, GetName(), strlen(GetName()) <= dl ? dl = strlen(GetName()) : dl);
	str[dl] = 0;
	set_bcolor(GetPaper());
	if ((GetStatus()&7)==BDISABLED) set_fcolor(CScheme->edit_disable);
	else set_fcolor(GetInk());
	Textw(GetX() + 24, GetY(), GetName());
	Underscore(24, 0, GetInk());
	int xx=GetX()+2, yy=GetY()+2;
	if (GetStatus() & WTRIGGER)
	{
		if (variable) *variable |= mask;
		set_fcolor(CWHITE);
		Boxw(xx,yy,10,10);
		set_fcolor(CBLACK);
		Hline(xx,yy,10);
		Hline(xx+1,yy+1,8);
		Vline(xx,yy,10);
		Vline(xx+1,yy+1,8);
	}
	else
	{
		if (variable) *variable &= ~mask;
		set_fcolor(CBLACK);
		Boxw(xx,yy,10,10);
		set_fcolor(CWHITE);
		Hline(xx,yy,10);
		Hline(xx+1,yy+1,8);
		Vline(xx,yy,10);
		Vline(xx+1,yy+1,8);
	}
	set_fcolor(CGRAY2);
	Boxw(xx+2,yy+2,6,6);
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

void Window::WindowText(int x, int y, char *s)
{
	Window *tmp = Window::current;

	x += xwrk;
	y += ywrk;

	set_fcolor(GetInk());
	set_bcolor(GetPaper());
	Context();
	Text(x, y, s);
	WindowRepaint(x, y, strlen(s) * fontw, fonth);
	tmp->Context();
}

void Window::WindowText(int x, int y, char *s, int color)
{
	Window *tmp = current;

	x += xwrk;
	y += ywrk;
	set_bcolor(GetPaper());
	set_fcolor(color);
	Context();
 	Text(x, y, s);
	WindowRepaint(x, y, strlen(s) * fontw, fonth);
	tmp->Context();
}

void Window::WindowText(int x, int y, char *s, int color, int bk)
{
	Window *tmp = current;

	x += xwrk;
	y += ywrk;
	set_fcolor(color);
	set_bcolor(bk);
	Context();
	Text(x, y, s);
	WindowRepaint(x, y, strlen(s) * fontw, fonth);
	tmp->Context();
}

void Window::WindowUpdate(int x, int y, int a, int b)
{
	Window *tmp = current;
	Context();
	WindowRepaint(x, y, a, b);
	tmp->Context();
}

void Window::WindowBox(int x, int y, int a, int b)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	Box(x, y, a, b);
	WindowRepaint(x, y, a, b);
	tmp->Context();
}

void Window::WindowBox(int x, int y, int a, int b, int c)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	set_fcolor(c);
	Box(x, y, a, b);
	WindowRepaint(x, y, a, b);
	tmp->Context();
}

void Window::WindowRect(int x, int y, int a, int b)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	Rect(x, y, a, b);
	WindowRepaint(x, y, a, b);
	tmp->Context();
}

void Window::WindowRect(int x, int y, int a, int b, int c)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	set_fcolor(c);
	Rect(x, y, a, b);
	WindowRepaint(x, y, a, b);
	tmp->Context();
}

void Window::WindowLine(int x, int y, int a, int b, int c)
{
	Window *tmp = current;
	int x1, x2, y1, y2;

	set_fcolor(c);
	Context();
	x += xwrk;
	y += ywrk;
	a += xwrk;
	b += ywrk;
	x1 = (x < a) ? x : a;
	x2 = (x < a) ? a : x;
	y1 = (y < b) ? y : b;
	y2 = (y < b) ? b : y;
	Line(x, y, a, b);

	WindowRepaint(x1, y1, x2 - x1+1, y2 - y1+1);

	tmp->Context();
}

void Window::WindowLine(int x, int y, int a, int b)
{
	Window *tmp = current;
	int x1, x2, y1, y2;

	Context();
	x += xwrk;
	y += ywrk;
	a += xwrk;
	b += ywrk;
	x1 = (x < a) ? x : a;
	x2 = (x < a) ? a : x;
	y1 = (y < b) ? y : b;
	y2 = (y < b) ? b : y;
	Line(x, y, a, b);

	WindowRepaint(x1, y1, x2 - x1+1, y2 - y1+1);

	tmp->Context();
}

void Window::WindowPixel(int x, int y, int c)
{
	Window *tmp = current;

	set_fcolor(c);
	Context();
	x += xwrk;
	y += ywrk;
	Pixel(x, y);
	WindowRepaint(x, y, 1, 1);
	tmp->Context();
}

void Window::WindowPixel(int x, int y)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	Pixel(x, y);
	WindowRepaint(x, y, 1, 1);
	tmp->Context();
}

void Window::WindowDrawCircle(int x, int y, int r)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	DrawCircle(x, y, r);
	WindowRepaint(x - r, y - r, r + r + 1, r + r + 1);
	tmp->Context();
}

void Window::WindowDrawCircle(int x, int y, int r, int c)
{
	Window *tmp = current;

	Context();
	set_fcolor(c);
	x += xwrk;
	y += ywrk;
	DrawCircle(x, y, r);
	WindowRepaint(x - r, y - r, r + r + 1, r + r + 1);
	tmp->Context();
}

void Window::WindowFillCircle(int x, int y, int r)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	FillCircle(x, y, r);
	WindowRepaint(x - r, y - r, r + r + 1, r + r + 1);
	tmp->Context();
}

void Window::WindowFillCircle(int x, int y, int r, int c)
{
	Window *tmp = current;

	Context();
	set_fcolor(c);
	x += xwrk;
	y += ywrk;
	FillCircle(x, y, r);
	WindowRepaint(x - r, y - r, r + r + 1, r + r + 1);
	tmp->Context();
}

void Window::WindowDrawEllipse(int x, int y, int rx, int ry)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	DrawEllipse(x, y, rx, ry);
	WindowRepaint(x - rx, y - ry, rx + rx + 1, ry + ry + 1);
	tmp->Context();
}

void Window::WindowDrawEllipse(int x, int y, int rx, int ry, int c)
{
	Window *tmp = current;

	Context();
	set_fcolor(c);
	x += xwrk;
	y += ywrk;
	DrawEllipse(x, y, rx, ry);
	WindowRepaint(x - rx, y - ry, rx + rx + 1, ry + ry + 1);
	tmp->Context();
}

void Window::WindowFillEllipse(int x, int y, int rx, int ry, int c)
{
	Window *tmp = current;

	Context();
	set_fcolor(c);
	x += xwrk;
	y += ywrk;
	FillEllipse(x, y, rx, ry);
	WindowRepaint(x - rx, y - ry, rx + rx + 1, ry + ry + 1);
	tmp->Context();
}

void Window::WindowFillEllipse(int x, int y, int rx, int ry)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	FillEllipse(x, y, rx, ry);
	WindowRepaint(x - rx, y - ry, rx + rx + 1, ry + ry + 1);
	tmp->Context();
}

void Window::WindowDrawArc(int x, int y, double a, double b, int r, int c)
{
	Window *tmp = current;

	Context();
	set_fcolor(c);
	x += xwrk;
	y += ywrk;
	DrawArc(x, y, a, b, r);
	WindowRepaint(x - r, y - r, r + r + 1, r + r + 1);
	tmp->Context();
}

void Window::WindowDrawArc(int x, int y, double a, double b, int r)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	DrawArc(x, y, a, b, r);
	WindowRepaint(x - r, y - r, r + r + 1, r + r + 1);
	tmp->Context();
}

void Window::WindowScrollDown(int p1, int p2, int p3, int p4, int p5)
{
	Window *tmp = current;

	Context();
	p1 += xwrk;
	p2 += ywrk;
	RamToRamd(p1, p2, cx_max, cy_max, p1, p2 + p5, cx_max, cy_max, p3, p4, Image, Image);
	int a = get_fcolor();

	set_fcolor(GetPaper());
	Boxw(p1, p2, p3, p5);
	set_fcolor(a);
	WindowRepaint(p1, p2, p3, p4 + p5);
	tmp->Context();
}

void Window::WindowScrollUp(int p1, int p2, int p3, int p4, int p5)
{
	Window *tmp = current;
	int a;

	Context();
	p1 += xwrk;
	p2 += ywrk;
	RamToRam(p1, p2, cx_max, cy_max, p1, p2 - p5, cx_max, cy_max, p3, p4, Image, Image);
	a = get_fcolor();
	set_fcolor(GetPaper());
	Boxw(p1, p2 + p4 - p5, p3, p5);
	set_fcolor(a);
	WindowRepaint(p1, p2 - p5, p3, p4 + p5);
	tmp->Context();
}

void Window::WindowUnLock(void)
{
	SetStatus(GetStatus() & (~WLOCKED));
	if (GetStatus() & WDIRTY && IsVisible())
	{
		Window *tmp = current;

		SetStatus(GetStatus() & (~WDIRTY));
		Context();
		WindowRepaint(xwrk,ywrk,GetWW(),GetHW());
		tmp->Context();
	}
}

App::App(int m, int &argc, char **&argv, int bck, int f)
{
	volatile int curr = 0, par = 0, benchmark=0;
	char *apn=argv[0], *apn2, **cmdl=argv+1;
	video = m;
	driver = 0;

	background = bck;
	flags = f;
	if (cApp) IError("Multiple App class not allowed !", 1);
	cApp = this;
	homedir = getenv("HOME");
	getcwd(currdir, 127);
	if (homedir==NULL) homedir = ".";
	apn2 = apn;
	apn = apn+strlen(apn)-1;
	if (strcmp(apn-3, ".exe")==0) { apn = apn-4; apn[1]=0; }
	while ((*apn!='/' && *apn!='\\' && *apn!=':') && apn2<=apn) apn--;
	apn++;
	name = strdup(apn);
	cCfg = new Config(apn);
	event = new GuiEvent;
	queque = new GuiEvent[MAX_EVENT_QUEQUE];

	if (argc > 1)
	{
		while (curr<(argc-1))
		{
			curr++;
			if (argv[curr][0] == '-') switch (tolower(argv[curr][1]))
			{
				case 'r':
					if (!memcmp(&argv[curr][1], "res", 3))
					{
						curr++;
						if (argc)
							video = argv[curr][0] - '0';
						par += 2;
					}
					else *cmdl++ = argv[curr];
					break;
#ifndef __linux__
				case 'd':
					if (!memcmp(&argv[curr][1], "dri", 3))
					{
						curr++;
						if (argc)
							driver = atoi(&argv[curr][0]);
						if (driver == 0)
							driver = -1;	// no detect -> VESA
						par += 2;
					}
					else *cmdl++ = argv[curr];
					break;
#else
				case 's':
					if (!memcmp(&argv[curr][1], "svg", 3))
					{
						nofb = 1;	// no detect FRAMEBUFFER
						par++;
					}
					else if (!memcmp(&argv[curr][1], "saf", 3))
					{
						video = G640x480;
                  verbose = 1;
                  driver = -1;
                  mmx = -1;
                  flags &= ~APP_WINDOWDATABASE;
						printf("Safe mode entered ..\a\n");
						par++;
					}
					else *cmdl++ = argv[curr];
					break;
				case 'm':
					if (!memcmp(&argv[curr][1], "mode", 4))
					{
						curr++;
						if (argc)
						{
							strncpy(fb_modename, argv[curr], 31);
							par+=2;
						} else par++;
					}
					else *cmdl++ = argv[curr];
					break;
#endif
#ifndef __QNX__
				case 'n':
					if (!memcmp(&argv[curr][1], "nom", 3))
					{
						mmx = -1;
						printf("MMX instruction disabled\n");
						par++;
					}
					else if (!memcmp(&argv[curr][1], "nof", 3))
					{
						fulldrag = 0;
						printf("Full window drag enabled\n");
						par++;
					}
					else *cmdl++ = argv[curr];
					break;
#endif
				case 'b':
					if (!memcmp(&argv[curr][1], "ban", 3))
					{
						set_linear(0);
						printf("Linear addresing disabled!\n");
						par++;
					}
					else if (!memcmp(&argv[curr][1], "ben", 3))
					{
						benchmark = 1;
						par++;
					}
					else *cmdl++ = argv[curr];
					break;
				case 'h':
					printf("\nFastGL library %s - (c) Copyright 1996,99 RUMSOFT\n\n", VERZIA);
					printf(" -resolution N\n");
					printf("          :force scr. resolution 'N', where 'N' = \n");
					printf("           1=320x200, 2=640x480, 3=800x600, 4=1024x768, 5=1280x1024\n");
					printf("           6=1600x1200\n");
#ifndef __linux__
					printf(" -driver N\n");
					printf("          :force display driver to 'N' (if autodetect failed), where 'N' = \n");
					printf("           0=vesa, 1=cirrus, 2=trident, 3=old s3, 4=new s3, 5=mxic\n");
					printf("           6=tseng3000, 7=ati, 8=tseng4000, 9=chips&tech, 10=wd, 11=banshee\n");
					printf("           12=riva 128, 13=matrox, 14=permedia, 15=intel\n");
#else
					printf(" -svga    :don't use FRAMEBUFFER\n");
					printf(" -mode N  :use 'N' name monitor timings (/etc/fb.modes)\n");
#endif
					printf(" -nommx   :don`t use MMX instruction set\n");
					printf(" -nofull  :use faster window moving\n");
					printf(" -verbose :verbose output\n");
					printf(" -safe    :safe mode\n");
					printf(" -banked  :disable linear mode\n");
					printf(" -bench   :run benchmark\n");
					getchar();
					par++;
					break;
				case 'v':
					if (!memcmp(&argv[curr][1], "ver", 3))
					{
						verbose = 1;
						par++;
					}
					else *cmdl++ = argv[curr];
					break;
				default:
					*cmdl++ = argv[curr];
					break;
			}
			else *cmdl++ = argv[curr];
		}
	}
	argc -= par;
	Argv = argv;
	Argc = argc;

	if (flags&APP_WINDOWDATABASE) entryPoint = new WindowDatabase(apn);
	if (video < 1 || video > 6)
		video = 1;
	if (driver < 0 || driver >= FG_LAST)
		driver = -1;

	if (!graph_set_mode(video))
	{
		printf("Fatal error: can't set graphics mode %d\n\a", video);
		exit(-2);
	}
	SetColorFuzzy(3);
	if (verbose)
	{
		printf("Video mode is %d [%dx%dx%d]\n", video, X_width,Y_width,FASTGL_BPP);
		printf("VideoBase %x, VideoSelector %x\n", (int)videobase,(short)VideoSelector);
#ifndef __linux
		if (framebuffer) printf("framebuffer at addr 0x%x\n", framebuffer);
		else printf("framebuffer not found\n");
#endif
		printf("memory size %d KB\n\n", memorysize);
	}
//  if you here get GPF, that its not a FastGL, but cwsdpmi.exe bug
	clear_frame_buffer(background);
	if (benchmark)
	{
		bench();
		getchar();
		delay(100);
		getchar();
		exit(0);
	}
//  if you here get GPF, that its not a FastGL, but cwsdpmi.exe bug
	GuiEvent::InitUserEvent();
	SetDelayProc(0);
	SetTimerProc(0);
	if (f&APP_ROOTWINDOW) Root = new Window(&Root, background);
#ifndef __MSDOS__
	setuid(getuid());  
	setgid(getgid());
	seteuid(getuid());
	setegid(getgid());
#endif
#ifdef __linux__
	FGTimer::TimerInit();
#endif	
}

App::~App()
{
#ifdef __linux__
	FGTimer::TimerQuit();
#endif	
	clear_frame_buffer(CBLACK);
	SetDelayProc(0);
	SetTimerProc(0);
        if (allBitmapCounter && verbose) IError("WARNING: Some non-released bitmaps encoutered !", 0);
	ReleaseFd();
	ReleaseCd();
#ifdef INDEX_COLORS
	_set_default_palette();
#endif	
#ifndef __WATCOMC__
	if (mmx_state) printf("WARNING: MMX set/reset calling mismatch!\n");
#endif	
	if (flags&APP_WINDOWDATABASE) delete entryPoint;
	delete cCfg;
	if (Root) delete Root;
	DestroyWindow();
	delete [] queque;
	delete event;
	free(name);
	cApp = 0;
}

// send message to all windows
void App::BroadcastMessage(GuiEvent *e)
{
	BaseGui *first = Window::GetCurrent();
	while(first)
	{
		((Window *)first)->SendToWindow(e);
		first = first->GetNext();
	}
}

extern int mouseflag;

void App::Yield(void)
{
	GuiEvent event;
	int tmp = mouseflag;
	mouseflag = 0;
	event.GetUserEvent(1);	// do while ALT+X no pressed
	mouseflag = tmp;
}

void App::Run(MainHwnd hwnd)
{
	appHandler = hwnd;
	for (;;)
	{
		event->GetUserEvent(-1);	// do while ALT+X no pressed
		event->TranslateUserEvent();
		for (; quequeIndex;)
		{
			quequeIndex--;
			if (appHandler) appHandler(queque+quequeIndex);
			if (queque[quequeIndex].type == QUITEVENT)
			{
				shut_down = 1;
				return; // force ret if QUITEVENT
			}
			queque[quequeIndex].type = NOEVENT;
		}
	}
}

/*
   ** prepne na dalsie okno a ak treba tak aj na dalsiu aplikaciu
 */
void Window::nextwnd(void)
{
	BaseGui *p = 0;
	static int cnt = 0;

	if (nWnd <= 1 || current->GetStatus() & WMODAL)
	{
		WarningBeep(0);
		return;
	}
	for (;;)
	{
		if (BaseGui::counter > cnt) cnt++;
		else cnt = 0;
		p = BaseGui::FindId(first, cnt);
		if (!p)
			continue;
		if (current == p || p->GetType()==PSEUDOWINDOW)
			continue;
		break;
	}
	((Window *) p)->WindowFocus();
}

// draw only input text with/without cursor

void EditBox::draw(int f)
{
	char str[130];
	unsigned a = set_font(FONT0816);
	Window *tmp = Window::GetCurrent();

	set_ppop(_GSET);
	owner->Context();
	set_fcolor(CScheme->edit_back);
	Boxw(GetX() + 2 + w1, GetY() + 2, w2 - 4, GetH() - 4);
	strcpy(str, buf);
	if (passwd) 
	{
		char *x=str;
		while (*x)
		{
			if (*x != ' ') *x = '*';
			x++;
		}
	}
	set_colors(CScheme->edit_fore, CScheme->edit_back);
	str[maxpos+offset] = 0;
	if (f)
	{
		Textw(GetX() + w1 + pos * 8 + 2 + 8, GetY() + 1 + (GetH() / 2 - fonth / 2), str + offset + pos);
		Boxw(GetX() + w1 + pos * 8 + 8, GetY() + 3, 2, GetH() - 6);
		str[pos+offset] = 0;
		Textw(GetX() + w1 + 8, GetY() + 1 + (GetH() / 2 - fonth / 2), str+offset);
	}
	else
	{
		Textw(GetX() + w1 + 8, GetY() + 1 + (GetH() / 2 - fonth / 2), str+offset);
	}
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

// draw all

void EditBox::draw(void)
{
	char str[130];
	char *spt=0;
	unsigned maxdl, ndl, dl, a = set_font(FONT0816), cp;
	Window *tmp = Window::GetCurrent();
	set_ppop(_GSET);
	owner->Context();
	offset = pos = 0;
	TestRange();
	memset(str, ' ', sizeof(str));	// fill local buffer with spaces
	maxdl = dl = (w1 - 8) / 8;			// maximalny zobrazitelny pocet znakov
	ndl = strlen(GetName()) <= dl ? dl = strlen(GetName()) : dl;
	strncpy(str, GetName(), ndl);
	ndl = (maxdl-ndl)*8;
	str[dl] = 0;
	cp = ((GetStatus() == BDISABLED) ? CScheme->edit_disable : (FGPixel)GetInk());
	set_colors(cp, GetPaper());
	Textw(GetX()+ndl, GetY() + 1 + (GetH() / 2 - fonth / 2), str);
	Underscore(ndl, 1 + GetH() / 2 - fonth / 2, GetPaper());
	switch (GetStatus() & 7)
	{
		case BNORMAL:
			Underscore(ndl, 1 + GetH() / 2 - fonth / 2, GetInk());
		case BDISABLED:
			set_fcolor(CScheme->edit_fore);
			Boxw(GetX() + w1, GetY(), w2, GetH());
			set_fcolor(CScheme->edit_back);
			Vline(GetX() + w1 + w2 - 2, GetY() + 1, GetH() - 2);
			Hline(GetX() + 1 + w1, GetY() - 2 + GetH(), w2 - 2);
			set_fcolor(CGRAY3);
			Boxw(GetX() + 2 + w1, GetY() + 2, w2 - 4, GetH() - 4);
			set_fcolor(CScheme->edit_bord1);
			Rect(GetX() + w1, GetY(), w2, GetH());
			set_bcolor(CScheme->edit_bord2);
			set_fcolor((GetStatus() == BDISABLED) ? cp : CScheme->edit_fore);
			switch (data_type)
			{
				case 0:
					if (!hex) sprintf(str, "%d", *(int *) ptr);
					else sprintf(str, "0x%x", *(int *) ptr);
					spt = str;
					break;
				case 1:
					 strcpy(str,(char *)ptr);
					spt = str;
					break;
				case 2:
					sprintf(str, "%f", *(double *) ptr);
					if (*str=='0') strcpy(str, str+1);
					spt = str;
					break;
			}
			spt[maxpos] = 0;	// print visible part only
			if (passwd) 
			{
				char *x=spt;
				while (*x)
				{
					if (*x != ' ') *x = '*';
					x++;
				}
			}
			Textw(GetX() + w1 + 8, GetY() + 1 + (GetH() / 2 - fonth / 2), spt);
			break;

		case BUNVISIBLE:
			set_fcolor(GetPaper());
			Boxw(GetX(), GetY(), GetW(), GetH());
			break;
	}
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

//
// vracia 1 na konci
//
int EditBox::inputproc(int c)
{
	char *s, *d;
	int i;

	// input filter
	if (c>= ' ' && c<127) switch(data_type)
	{
		case 0:
			if (!isdigit(c) && c != '-')
				if (hex)
				{
					if (c<'A' || c>'f') return 0;
					else if (c>'F' && c<'a') return 0;
				}
				else return 0;
			break;
		case 2:
			if (!isdigit(c) && c != '-')
	 			if (c!= '.' && c!='e' && c!='E') return 0;
			break;
	}
	
	draw(0); // cursor off
	if (first)
	{
		first = 0;
		if ((isprint(c) || c == DEL || c == BACKSP) && c < 256)
		{
			for (i = 0; i < size; buf[i++] = ' ');
			offset = pos = 0;
		}
	}

	switch (c)
	{
		case CTRL_INSERT:
			memcpy(clip,buf,sizeof(clip));
			is_clip = 1;
			break;
		case INSERT:
			memcpy(buf,clip,sizeof(clip));
			break;
		case ESC:
			ininput = 0;
			SetStatus(BNORMAL);
			draw(); // draw final
			return -1;
		case CR:
			ininput = 0;
			switch (data_type)
			{
				case 0:
					int n;
					if (hex) n = strtol(buf, 0, 16); else n = atoi(buf);
					{
						*(int *) ptr = n;
                        TestRange();
					}
					break;
				case 1:
					pos = size;
					while (pos)
					{
						if (buf[pos - 1] != ' ')
							break;
						pos--;
					}
					if (buf[pos-1]=='\"' && pos>0) pos--;
					buf[pos]=0;
					strcpy((char *) ptr, buf);
					break;
				case 2:
					double d;
					d = atof(buf);
					{
						*(double *) ptr = d;
                        TestRange();
					}
					break;
			}
			SetStatus(BNORMAL);
			draw(); // draw final
			SetActive();
			return 1;
		case HOME:
			offset = pos = 0;
			break;
		case END:
			{
				pos = size;
				while (pos)
				{
					if (buf[pos - 1] != ' ')
						break;
					pos--;
				}
				offset = pos>maxpos?pos-maxpos:0;
				pos = pos-offset;
			}
			break;
		case BACKSP:
			if (pos+offset)
			{
				s = &buf[offset+pos--];
				d = s - 1;
				while (*s)
					*d++ = *s++;
				*d = ' ';
				if (offset) { offset--; pos++; }
			}
			break;
		case KLEFT:
			if (pos+offset)
			{
				if (pos) pos--;
				else if (offset) offset--;
			}
			break;
		case KRIGHT:
			if (pos+offset < size)
			{
				if (pos<maxpos) pos++;
				else { offset++; }
			}
			break;
		case DEL:
			if (pos+offset < size)
			{
				d = &buf[pos+offset];
				s = d + 1;
				while (*s)
					*d++ = *s++;
				buf[size - 1] = ' ';
			}
			break;

		default:
			if (pos+offset < size)
			{
				if ((c > 31) | (c < 128))
				{
					d = buf + sizeof(buf) -1;
					while(d>(buf+pos+offset))
					{
						*d = d[-1];
						d--;
					}
					*d = (char)c;
				}
				if (pos+offset < size)
				{
					if (pos<maxpos) pos++;
					else { offset++; }
				}
			}
			break;
	}
	buf[size] = 0;
	draw(1); // cursor on
	return 0;
}

// start input line
void EditBox::input(void)
{
	char str[130];
	int a = set_font(FONT0816);

	ininput = this;
	iline = GetY() + 1 + (GetH() / 2 - fonth / 2);
	icol = GetX() + w1 + 8;
	switch (data_type)
	{
		case 0:
			sprintf(str, "%d", *(int *) ptr);
			break;
		case 1:
			strcpy(str, (const char *) ptr);
			break;
		case 2:
			sprintf(str, "%f", *(double *) ptr);
			if (*str=='0') strcpy(str, str+1);
			break;
	}
	// copy to buffer (and fill it) and find the end of line
	for (int j = 0, i = 0; i < (int)sizeof(buf);)
		if (str[j] == 0)
			buf[i++] = ' ';
		else
			buf[i++] = str[j++];
	buf[size] = 0;
	pos = size-1;
	while (pos >= 0)
	{
		if (buf[pos] > ' ')
			break;
		pos--;
	}
	pos++;
	offset = pos>maxpos?pos-maxpos:0;
	pos -= offset;
	first = 1;
	set_font(a);
}

EditBox::EditBox(int xs,	int ys,	int ws1, int ws2, char *nm, int	key, Window *w,	int *pt, int ink, int paper, ControlCall f, int mn, int mx, int check)
	: Control(xs, ys, ws1+ws2, 21, nm, EDITBOX,	key, BNORMAL, w, f,paper,ink)
{
	int a = set_font(FONT0816);
	w1 = ws1;
	w2 = ws2;
	ptr= pt;
    check_range = check;
	min= mn;
	max=mx;
	data_type=0;
	size = maxpos=(ws2-16)/fontw;
	offset = 0;
	hex = passwd = 0;
	draw();
	set_font(a);
}
			
EditBox::EditBox(int sz, int xs, int ys, int ws1, int ws2, char *nm, int key, Window *w, char *pt, int ink, int paper, ControlCall f)
: Control(xs, ys, ws1+ws2, 21, nm, EDITBOX,	key, BNORMAL, w, f,paper,ink)
{
	int a = set_font(FONT0816);
	w1 = ws1;
	w2 = ws2;
	ptr= pt;
	data_type=1;
	maxpos=(ws2-16)/fontw;
	size = sz<=0 ? maxpos : ((sz>127) ? 127:sz);
	offset = 0;
	hex = passwd = 0;
	draw();
	set_font(a);
}
			
EditBox::EditBox(int xs,	int ys,	int ws1, int ws2, char *nm, int	key, Window *w,	double *pt, int	ink, int paper,	ControlCall f, double mn, double mx, int check)
: Control(xs, ys, ws1+ws2, 21, nm, EDITBOX,	key, BNORMAL, w, f,paper,ink)
{
	int a = set_font(FONT0816);
	w1 = ws1;
	w2 = ws2;
	ptr= pt;
	check_range = check;
	mind= mn;
	maxd=mx;
	data_type=2;
	size = maxpos=(ws2-16)/fontw;
	offset = 0;
	hex = passwd = 0;
	draw();
	set_font(a);
}

void EditBox::ClickUp(int a)	// if TRUE, so call handler
{
	if ((status&7) == BDISABLED) return;
	if (!a)	return;
	FlushInput();
	Window *tmp = owner->Context();
	SetStatus(BPUSHED);
	input();
	draw(1);
	tmp->Context();
}

void BaseMenu::MoveOut(void)
{
	owner->Context();
	draw();
}

void BaseMenu::MoveIn(void)
{
	unsigned a = set_font(FONT0816);

	owner->Context();
	if (GetType() == MENUBUTTON)
	{
		set_fcolor(CScheme->menu_back_active);
		Boxw(GetX(), GetY()-1, GetW(), MENUH-2/*GetH()*/);
		set_bcolor(CScheme->menu_back_active);
		set_fcolor(CScheme->menu_fore_active);
		Textw(GetX()+4, GetY(), GetName());
		Underscore(4,0,CWHITE);
		set_font(a);
		owner->WindowRepaint(GetX()-4, GetY()-2, GetW()+8, MENUH);
	}
	else
	{
		set_fcolor(CScheme->pdmenu_back_active);
		Boxw(GetX()-4, GetY(), GetW()+8, GetH());
		set_bcolor(CScheme->pdmenu_back_active);
		set_fcolor(CScheme->pdmenu_fore_active);
		Textw(GetX()+4, GetY()+1, GetName());
		Underscore(4,1,CScheme->pdmenu_fore_active);
		set_font(a);
		owner->WindowRepaint(GetX()-4, GetY(), GetW()+8, GetH());
	}
}

static int is_alted(int c)
{
	for(int i=0;i<26;i++)
		if (alty[i]==c) return i;
	return -1;
}

void Control::Underscore(int xo, int yo, int c)
{
	char *s;
	int pos;
	if (key==0) return;
	set_fcolor(c);
	if ((pos=is_alted(key)) >= 0)
	{
		set_fcolor(CREDLIGHT);
		if ((s = strchr(name, pos+'a')) != 0)
		{
			s = s - (int) name;
			Boxw(GetX() + (int) s * 8+xo-1, GetY()+13+yo, 9,1);
		}
		else if ((s = strchr(name, pos+'A')) != 0)
		{
			s = s - (int) name;
			Boxw(GetX() + (int) s * 8+xo-1, GetY()+13+yo, 9,1);
		}
	}
	else if ((s = strchr(name, key)) != 0)
	{
		s = s - (int) name;
		Boxw(GetX() + (int) s * 8+xo-1, GetY()+13+yo, 9,1);
	}
	else if ((s = strchr(name, key ^ 32)) != 0)
	{
		s = s - (int) name;
		Boxw(GetX() + (int) s * 8+xo-1, GetY()+13+yo, 9,1);
	}
}

void BaseMenu::draw(void)
{
	unsigned a = set_font(FONT0816);
	Window *tmp = Window::GetCurrent();

	owner->Context();
	switch (GetStatus() & 7)
	{
		case BNORMAL:
			set_fcolor(GetPaper());
			if (GetType() == MENUBUTTON)
			{
				Boxw(GetX(), GetY()-1, GetW(), MENUH-2);
				set_bcolor(GetPaper());
				set_fcolor(GetInk());
				Textw(GetX()+4, GetY(), GetName());
				Underscore(4,0,GetInk());
				owner->WindowRepaint(GetX()-4, GetY()-2, GetW()+8, MENUH);
			}
			else
			{
				Boxw(GetX()-4, GetY(), GetW()+8, GetH());
				set_bcolor(GetPaper());
				set_fcolor(GetInk());
				Textw(GetX()+4, GetY()+1, GetName());
				Underscore(4,1,GetInk());
				owner->WindowRepaint(GetX()-4, GetY(), GetW()+8, GetH());
			}
			break;
		case BDISABLED:
			set_bcolor(GetPaper());
			set_fcolor(CScheme->pdmenu_gray);
			Textw(GetX()+4, GetY(), GetName());
			Underscore(4,0,GetPaper());
			Underscore(4,1,GetPaper());
			owner->WindowRepaint(GetX()-4, GetY(), GetW()+8, GetH());
			break;
	}
	set_font(a);
	tmp->Context();
}

int Window::GetXM(int a)
{
	if (!(GetStatus() & WMENU))
	{
		cprintf("You must use WMENU option for this window\n");
	}
	c_menupos += a;
	return c_menupos - a;
}

int Window::GetYM()
{
	return -(MENUH-1);
}

void Window::WindowShape(int sx, int sy, int wx, int wy)
{
	int changepos = (sx!=x || sy!=y), changesize=(wx!=w || wy!=h);
	
	Control *p = (Control *) GetCurrentControls();

	if (changepos && !changesize) // iba zmena polohy
	{
		WindowMove(sx-x, sy-y);
		return;
	}
	else if (!changepos && changesize) // iba zmena velkosti
	{
		WindowResize(wx-w, wy-h);
		return;
	}

	c_menupos = 1;
	if (status&WALIGNED)
	{
		sx &= ~3;
		sy &= ~3;
		wx &= ~3;
		wy &= ~3;
	}

	if (sx>X_width-wx) sx = X_width-wx;
	if (sy>Y_width-wy) sy = Y_width-wy;
	if (sx<0) sx = 0;
	if (sy<0) sy = 0;
	if (wx > X_width) wx = X_width;
 	if (wx < 32)	  wx = 32;
	if (wy > Y_width) wy = Y_width;
	if (wy < (BASEBORDER*2+TITLEH+MENUH+STATUSBARH)) wy = BASEBORDER*2+TITLEH+MENUH+STATUSBARH;

	int nx=sx-x, ny=sy-y, dx=wx-w, dy=wy-h;

	if (CallWindowHook && changepos)  CallWindowHook(x, y, nx, ny, 1); // 1 as move
	if (CallWindowHook && changesize) CallWindowHook(w, h, dx, dy, 2); // 2 as size

	WindowUpdate(nx, ny, 1); // redraw on screen

	Relocate(nx, ny);
	while (p)
	{
		p->Relocate(nx, ny);
		p = (Control *) p->GetNext();
	}

	delete image;
	assert(image = new FGPixel[areasize(wx, wy)]);

	Resize(dx, dy);
	wwrk += dx;
	hwrk += dy;
	wsur += dx;
	hsur += dy;
	xpos = 1;
	ypos = 0;
	Context();
	draw();
	SendEvent(this, WINDOWRESIZEEVENT, x,y,w,h);
	SendEvent(this, WINDOWMOVEEVENT, x,y,w,h);
}

void Window::WindowVirtualRoot(int sx, int sy, int wx, int wy)
{
	int nx=sx-x, ny=sy-y, dx=wx-w, dy=wy-h;

	Relocate(nx, ny);
	delete image;
	assert(image = new FGPixel[areasize(wx, wy)]);
	Resize(dx, dy);
	wwrk += dx;
	hwrk += dy;
	wsur += dx;
	hsur += dy;
	Context();
	draw();
}

void Window::WindowMove(int nx, int ny)
{
	Control *p = (Control *) GetCurrentControls();
	if (status&WALIGNED && !fulldrag)
	{
		nx &= ~3;
		ny &= ~3;
	}
	if (CallWindowHook) CallWindowHook(x, y, nx, ny, 1); // 1 as move
	XWaitRetrace();
	WindowUpdate(nx,ny);
	Relocate(nx, ny);
	while (p)
	{
		p->Relocate(nx, ny);
		p = (Control *) p->GetNext();
	}
	RepaintBlock(0,0,w,h);
	SendEvent(this, WINDOWMOVEEVENT, x,y,w,h);
	rebuild = 1;
}

void Window::WindowResize(int dx, int dy)
{
	if (status&WALIGNED && !fulldrag)
	{
		dx &= ~3;
		dy &= ~3;
	}
	if (CallWindowHook) CallWindowHook(w, h, dx, dy, 2); // 2 as resize
	if (w + dx > X_width 
	    || w + dx < 32 
	    || h + dy > Y_width 
	    || h + dy < (BASEBORDER*2+TITLEH+MENUH+STATUSBARH))
	{
		return;
	}

	c_menupos = 1;
	XWaitRetrace();
	if (dx<0 || dy<0) WindowUpdate(dx,dy);
	delete image;

	assert(image = new FGPixel[areasize(w + dx, h + dy)]);

	Resize(dx, dy);
	wwrk += dx;
	hwrk += dy;
	wsur += dx;
	hsur += dy;
	xpos = 1;
	ypos = 0;
	Context();
	draw();
	SendEvent(this, WINDOWRESIZEEVENT, x,y,w,h);
	rebuild = 1;
}

void Window::WindowCopyFrom(int x, int y, int xs, int ys, int w, int h, Window * p)
{
	Window *tmp = current;
	int ww, hh;

	x += xwrk;
	y += ywrk;
	WindowClipUser(x,y,w,h);
   	if (w<=0 || h <=0)
   		return;
	Context();
	if (w <= p->GetW() && h <= p->GetH()) // cielove okno je mensie nez bitmapa
	{
	    if ((x + w) > cx_maxwork)
		   w -= ((x + w) - cx_maxwork);
        if ((y + h) > cy_maxwork)
		   h -= ((y + h) - cy_maxwork);
       	if ((x + w) > cx_work && x < cx_work)
	    {
		    w = ((x + w) - cx_work);
          	xs+= (cx_work-x);
		    x = cx_work;
        }
	    if ((y + h) > cy_work && y < cy_work)
	    {
		    h = ((y + h) - cy_work);
          	ys+= (cy_work-y); // kresli sa menej aj z bitmapy
		    y = cy_work;
        }
		RamToRam(xs, ys, p->GetW(), p->GetH(), x, y, GetW(), GetH(), w, h, p->GetArray(), image);
	}
	else
	{
		for (int i = 0; i <= (h / p->GetH()); i++)
			for (int j = 0; j <= (w / p->GetW()); j++)
			{
				ww = j == (w / p->GetW())? w % p->GetW() : p->GetW();
				hh = i == (h / p->GetH())? h % p->GetH() : p->GetH();
				RamToRam(xs, ys, p->GetW(), p->GetH(), x + j * p->GetW(), y + i * p->GetH(), GetW(), GetH(), ww, hh, p->GetArray(), image);
			}
	}
	WindowRepaint(x, y, w, h);
	tmp->Context();
}

void Window::WindowPutBitmap(int x, int y, int xs, int ys, int w, int h, DrawBuffer * p)
{
	Window *tmp = current;
	int ww, hh;

	if (p->GetType() == BMP_NONE) return;
	x += xwrk;
	y += ywrk;
	WindowClipUser(x,y,w,h);
   	if (w<=0 || h <=0)
   		return;
	Context();
	int oldp = ppop, oldt = transp_color;
	if (p->transparent_color != -1)
	{
		set_ppop(_GTRANSP);
		transp_color = p->transparent_color;
	}
	if (w <= p->GetW() && h <= p->GetH()) // cielove okno je mensie nez bitmapa
	{
	    if ((x + w) > cx_maxwork)
		   w -= ((x + w) - cx_maxwork);
        if ((y + h) > cy_maxwork)
		   h -= ((y + h) - cy_maxwork);
       	if ((x + w) > cx_work && x < cx_work)
	    {
		    w = ((x + w) - cx_work);
          	xs+= (cx_work-x);
		    x = cx_work;
        }
	    if ((y + h) > cy_work && y < cy_work)
	    {
		    h = ((y + h) - cy_work);
          	ys+= (cy_work-y); // kresli sa menej aj z bitmapy
		    y = cy_work;
        }
		RamToRam(xs, ys, p->GetW(), p->GetH(), x, y, GetW(), GetH(), w, h, p->GetArray(), image);
	}
	else
	{
		for (int i = 0; i <= (h / p->GetH()); i++)
			for (int j = 0; j <= (w / p->GetW()); j++)
			{
				ww = j == (w / p->GetW())? w % p->GetW() : p->GetW();
				hh = i == (h / p->GetH())? h % p->GetH() : p->GetH();
				RamToRam(xs, ys, p->GetW(), p->GetH(), x + j * p->GetW(), y + i * p->GetH(), GetW(), GetH(), ww, hh, p->GetArray(), image);
			}
	}
	set_ppop(oldp);
	transp_color = oldt;
	WindowRepaint(x, y, w, h);
	tmp->Context();
}

void Window::WindowGetBitmap(int x, int y, int xs, int ys, int w, int h, DrawBuffer * p)
{
	Window *tmp = current;

	if (p->GetType() == BMP_NONE)
		return;
	Context();
	x += xwrk;
	y += ywrk;
	RamToRam(x, y, GetW(), GetH(), xs, ys, p->GetW(), p->GetH(), w, h, image, p->GetArray());
	tmp->Context();
}

void myOk(Control *)
{
	delete errWindow;
	errWindow = 0;
}

void myAbort(Control *)
{
	delete errWindow;
	errWindow = 0;
	App::AppDone();
}

void IError(char *s, int flag)
{
	int w = (strlen(s) + 8) * 4;

	if (errWindow) return;
	if (inGraph)
	{
		int a =set_font(FONT0816);
		w = w < 75 ? 75 : w;
		WarningBeep(0);
		new Window(&errWindow, 0, 0, w * 2, 78, "Error", GuiHwnd(0), CWHITE, CREDLIGHT, flag?WMODAL:0 | WCENTRED | WESCAPE);
		if (flag) errWindow->WindowText(w - 70, 8, "* * * ERROR * * *", CYELLOW);
		else errWindow->WindowText(w - 78, 8, "* * * WARNING * * *", CYELLOW);
		errWindow->WindowText(32, 28, s, CWHITE);
		errWindow->WindowRect(0,0,2*w,78,CBLACK);
		if (flag) errWindow->AddPushButton(w - 40, 48, 80, 21, "Abort", CR, myAbort);
		else errWindow->AddPushButton(w - 40, 48, 80, 21, "Ok", CR, myOk);
		set_font(a);
	}
	else IErrorText(s, flag);
#ifndef __MSDOS__
	if (verbose) printf("IError:: %s\n", s);
#endif	
}

static FILE *f;

WindowDatabase::WindowDatabase(char *exename)
{
	int magic;
#ifndef __MSDOS__
   sprintf(name, "%s/.windowxy.wdb", App::homedir);
#else
   strcpy(name, "windowxy.wdb");
#endif	
    sprintf(exe, "%s::", exename);
   ::f = fopen(name, "rb");
   if (::f)
	{
		fread(&magic, sizeof(int), 1,::f);
		fread(&xyCounter, sizeof(int), 1,::f);
		if (xyCounter<1 || xyCounter>100 || magic!=0x4357)
		{
			remove(name);
			xyCounter = 0;
			endpointer = &first;
			return; // possibly damaged config
		}
		WindowItem **previous = &first;

		for (int i = 0; i < xyCounter; i++)
		{
			*previous = new WindowItem();
			previous = &((*previous)->next);
		}
		*previous = 0;
		endpointer = previous;
		fclose(::f);
	}
	else
	{
		endpointer = &first;
	}
}

WindowDatabase::~WindowDatabase()
{
	int magic=0x4357;
	if (xyCounter <= 0)	return;
    ::f = fopen(name, "wb");
    if (::f)
	{
		WindowItem *p = first, *pp;
		fwrite(&magic, sizeof(int), 1,::f);
		fwrite(&xyCounter, sizeof(int), 1,::f);

		for (int i = 0; i < xyCounter; i++)
		{
			pp = p->next;
			delete p;
			p = pp;
		}
		fclose(::f);
	}
}

WindowItem *WindowDatabase::findxy(char *s)
{
	WindowItem *p = first;
	char ss[128];
	
	sprintf(ss, "%s%s", exe, s);
	for (int i = xyCounter; i; --i)
	{
		if (!strcmp(p->name, ss))
			return p;
		p = p->next;
	}
	return 0;
}

WindowItem::WindowItem()
{
	char s[80],*p=s;
	int	c;
	fread(&x, sizeof(int),1,::f);
	fread(&y, sizeof(int),1,::f);
	fread(&w, sizeof(int),1,::f);
	fread(&h, sizeof(int),1,::f);
	fread(&icon_x, sizeof(int),1,::f);
	fread(&icon_y, sizeof(int),1,::f);
	fread(&flag, sizeof(int),1,::f);
	while ((c=fgetc(::f)) != 0)	*p++=(char)c;
	*p=0;
	name = new char[strlen(s)+1];
	strcpy(name,s);
}

WindowItem::WindowItem(int xx, int yy, int ww, int hh, char	*s)
{
	x=xx;
	y=yy;
	w=ww;
	h=hh;
	icon_x = -1;
	icon_y = -1;
	flag = 0;
	name = new char[strlen(s)+1];
	strcpy(name,s);
}

WindowItem::~WindowItem()
{
	fwrite(&x,sizeof(int),1,::f);
	fwrite(&y,sizeof(int),1,::f);
	fwrite(&w,sizeof(int),1,::f);
	fwrite(&h,sizeof(int),1,::f);
	fwrite(&icon_x,sizeof(int),1,::f);
	fwrite(&icon_y,sizeof(int),1,::f);
	fwrite(&flag,sizeof(int),1,::f);
	fputs(name,::f);
	fputc(0,::f);
	delete name;
}

void WindowDatabase::Add(int &xx, int &yy, int &ww, int &hh, char *s, int fl)
{
	WindowItem *w;

	if (!entryPoint) return;

	if (strlen(s) == 0)
		return;

	if ((w = findxy(s))==0)
	{
		char ss[128];
		sprintf(ss, "%s%s",exe, s);
		*endpointer = new WindowItem(xx, yy, ww, hh, ss);
		endpointer = &((*endpointer)->next);
		*endpointer = 0;
		xyCounter++;
	}
	else if (fl&WUSELAST)
	{
		xx = w->x;
		yy = w->y;
		if (fl&WSIZEABLE)
		{
			ww = w->w;
			hh = w->h;
		}
	}
}

void WindowDatabase::DatabaseResize(int xx, int yy, char *s)
{
	if (entryPoint==0) return;
	WindowItem *w = findxy(s);
	if (w)
	{
		w->w = xx;
		w->h = yy;
	}
}

void WindowDatabase::DatabaseSetIcon(int xx, int yy, char *s)
{
	if (!entryPoint) return;

	WindowItem *w = findxy(s);

	if (w)
	{
		w->icon_x = xx;
		w->icon_y = yy;
	}
}

void WindowDatabase::DatabaseGetIcon(int &xx, int &yy, char *s)
{
	if (!entryPoint) return;

	WindowItem *w = findxy(s);

	if (w)
	{
		xx = w->icon_x;
		yy = w->icon_y;
	}
}

void WindowDatabase::DatabaseRelocate(int xx, int yy, char *s)
{
	if (!entryPoint) return;

	WindowItem *w = findxy(s);

	if (w)
	{
		w->x = xx;
		w->y = yy;
	}
}

// vykresli titulok okna
void Window::DrawTitleMem(int color)
{
	int a = set_font(FONT0816), fr = 0, picto=(status&WNOPICTO?0:(status&WMINIMIZE)?PICTOSIZE*2:PICTOSIZE);

	set_ppop(_GSET);
	if (GetStatus() & WFRAMED) fr = BASEBORDER-1;
	set_fcolor(color);
	set_bcolor(color);

	if (status & WTITLED) // modry/hnedy titulok
	{
		Boxw(fr, fr, w - (fr + fr)-picto, TITLEH);
		set_fcolor(CWHITE);
		Boxw(fr, fr+TITLEH-1, w - (fr + fr)-picto, 1);
		Boxw(w-((status & WFRAMED) ?4:0), fr, 1, TITLEH);
		if (status&WMINIMIZE && !(status&WNOPICTO))
			Boxw(w-PICTOSIZE*2-4, fr, 1, TITLEH);
		if (status&WMINIMIZE || !(status&WNOPICTO))
			Boxw(w-PICTOSIZE-4, fr, 1, TITLEH);
		Textw(5 + fr, fr + 2, skipstr(name));
		PiktoMem(w - PICTOSIZE*2-3, fr);
		WindowRepaint(fr, 0, w-fr-fr, BASEBORDER+TITLEH);
	}
	else if (status & WFRAMED) // bez titulku
	{
		Rect(0, 0, w, h);
		Rect(1, 1, w-2, h-2);
		WindowRepaint(0, 0, w, 2);
		WindowRepaint(0, 0, 2, h);
		WindowRepaint(w-2, 0, 2, h);
		WindowRepaint(0, h-2, w, 2);
	}
	set_font(a);
}

// nakresli okno
void Window::draw(void)
{
    int ff = GetStatus() & WFRAMED;
	int	tt = GetStatus() & WTITLED;
	int	pp = GetStatus() & WNOPICTO;
	int	mm = GetStatus() & WMENU;
	int	mw = GetStatus() & WMENUWINDOWTYPE;
	int	ss = GetStatus() & WSTATUSBAR;
	int vs = BASEBORDER, vrch;

	set_ppop(_GSET);
	Image = image;
	if (tt) vs+=(TITLEH+2);
	if (mm) vs+=MENUH;
	vrch=vs;
	if (ss) vs+=STATUSBARH;
    if (!ff)  // ak nemas FRAME, potom urob podklad pod titulok
    {
       	vs -= 2;
       	vrch -= BASEBORDER;
       	if (tt) FGmemset(Image+cx_max * TITLEH, CBLACK, cx_max); // standard
      	else FGmemset(Image+cx_max * TITLEH, paper, cx_max); // standard
    }
	if (!ff && !pp && tt)
	{
		FGmemset(Image, BORD3, cx_max * TITLEH); // standard
	}
   	else if (!tt) FGmemset(Image, GetPaper(), cx_max * TITLEH);
	if (ff)
	{
		FGmemset(Image, BORD3, cx_max*cy_max); // standard
	    set_fcolor(BORD1);
	    Boxw(0, 0, GetW()-1, 1);
	    Boxw(0, 0, 1, GetH()-1);
	    set_fcolor(BORD2);
	    Boxw(0, GetH()-1, GetW(), 1);
	    Boxw(GetW()-1, 0, 1, GetH()-1);
	    set_fcolor(GetPaper());
		if (!mw)
		{
		    Boxw(BASEBORDER, vrch, GetW()-BASEBORDER*2, GetH()-BASEBORDER-vs);
		    set_fcolor(CWHITE);
	    	Rectw(BASEBORDER-1, vrch-1, GetW()-BASEBORDER*2+2, GetH()-BASEBORDER-vs+2);
		    set_fcolor(CBLACK);
		    Boxw(BASEBORDER-1, vrch-1, GetW()-BASEBORDER*2+2,1);
		    Boxw(BASEBORDER-1, vrch-1, 1, GetH()-BASEBORDER-vs+2);
		}
		else Boxw(BASEBORDER-2, vrch-2, GetW()-BASEBORDER*2+4, GetH()-BASEBORDER-vs+4);
	}
    else FGmemset(Image+cx_max*TITLEH +cx_max, GetPaper(), cx_max*(cy_max-TITLEH-1)); // standard

	DrawTitleMem(CTITLEACTIVE);
	if (GetStatus() & WSIZEABLE && ff)
	{
		set_fcolor(CYELLOW);
		Boxw(GetW() - 13, GetH() - 3, 12, 2);
		Boxw(GetW() - 3, GetH() - 13, 2, 12);
	}
	if (mm)
	{
		if (ff)
		{
			set_fcolor(CBLACK);
			Boxw(xwrk-1, ywrk - MENUH-2, GetW() - xwrk * 2+2, MENUH+2);
			set_fcolor(CWHITE);
		    Boxw(wwrk, vrch-MENUH, 1, MENUH+2);
		}
		else
		{
			set_fcolor(CBLACK);
			Boxw(xwrk, ywrk - MENUH-1-(tt?1:0), GetW() - xwrk * 2, MENUH+1+(tt?1:0));
		}
		set_fcolor(MENUBG);
		Boxw(xwrk, ywrk - MENUH-1, GetW() - xwrk * 2, MENUH);
		set_fcolor(CBLACK);
		Boxw(xwrk, ywrk - MENUH-1, 1, MENUH);
	}
	if (ss)
	{
		if (ff)
		{
            set_fcolor(BORD2);
            Boxw(xwrk-1, GetH()-BASEBORDER-STATUSBARH+1, GetW() - xwrk * 2+1, STATUSBARH);
		    set_fcolor(BORD1);
		    Boxw(xwrk, GetH()-BASEBORDER-STATUSBARH+2, GetW() - xwrk * 2+1, STATUSBARH-1);
		    set_fcolor(statuscolor);
		    Boxw(xwrk, GetH()-BASEBORDER-STATUSBARH+2, GetW() - xwrk * 2, STATUSBARH-2);
        }
        else
		{
		    set_fcolor(statuscolor);
		    Boxw(0, GetH()-STATUSBARH, GetW(), STATUSBARH);
        }
	}
	BaseGui *pt = Buttony;
	if (first_draw) SendEvent(this, REPAINTEVENT);
	while (pt)
	{
		((Control *) pt)->draw();
		pt = pt->GetNext();
	}
	first_draw = 1;
	RepaintBlock(0, 0, w, h);
}

void Window::WindowStatusBar(int x, char *s, int color)
{
	Window *tmp = current;
	int y;
	x += (BASEBORDER+1);
	y  = h-STATUSBARH+2-(GetStatus()&WFRAMED?BASEBORDER:0);
	set_bcolor(statuscolor);
	set_fcolor(color);
	Context();
	Textw(x, y, s);
	WindowRepaint(x, y, strlen(s) * fontw, fonth);
	tmp->Context();
}

void Window::WindowFillPolygon(int n, int p[][2], int col)
{
	Window *tmp = current;

	Context();
	psw.gc_xoffset = xwrk;
	psw.gc_yoffset = ywrk;
	psw.gc_xcliplo = 0; //xwrk;
	psw.gc_ycliplo = 0; //ywrk;
	psw.gc_xcliphi = GetWW();
	psw.gc_ycliphi = GetHW();

	psw.line = Line;
	psw.scan = Hline;

	if (col!=-1) set_fcolor(col);
	_FillPolygon(n, p, &psw);
	WindowRepaint(xwrk,ywrk,GetWW(),GetHW());
	tmp->Context();
}

void Window::WindowDrawPolygon(int n, int p[][2], int col)
{
	Window *tmp = current;

	Context();
	psw.gc_xoffset = xwrk;
	psw.gc_yoffset = ywrk;
	psw.gc_xcliplo = 0; //xwrk;
	psw.gc_ycliplo = 0; //ywrk;
	psw.gc_xcliphi = GetWW();
	psw.gc_ycliphi = GetHW();

	psw.line = Line;
	psw.scan = Hline;

	if (col!=-1) set_fcolor(col);
	_DrawPolygon(n, p, &psw);
	WindowRepaint(xwrk,ywrk,GetWW(),GetHW());
	tmp->Context();
}

void Window::WindowSpline(int points[8])
{
	Window *tmp = current;
    #define NPTS   64

    int xpts[NPTS], ypts[NPTS];
    int i;

	Context();
	calc_spline(points, NPTS, xpts, ypts);

	for (i=1; i<NPTS; i++) 
	{
    	Line(xpts[i-1]+xwrk, ypts[i-1]+ywrk, xpts[i]+xwrk, ypts[i]+ywrk);
        if (ppop == _GXOR) Pixel(xpts[i]+xwrk, ypts[i]+ywrk);
	}
	WindowRepaint(xwrk, ywrk, wwrk, hwrk);
	tmp->Context();
}

void Window::FlushInput(void)
{
	::FlushInput();
}

Window::Window(DrawBuffer *p) :
  BaseGui(0, 0, p->GetW(), p->GetH(), 0, PSEUDOWINDOW, 0, CWHITE, WLOCKED|WHIDEN)
{
	init();
	image  = p->GetArray();
	cx_max = p->GetW();
	cy_max = p->GetH();
	wwrk = cx_max - xwrk;
	hwrk = cy_max - xwrk;
	hsur = hwrk + xwrk - ywrk;
	if (hsur<fonth*2) hsur=fonth*2;
	wsur = wwrk;
}

Window::Window(int x, int y, int w, int h) :
  BaseGui(x, y, w, h, 0, PSEUDOWINDOW, 0, CWHITE, WLOCKED|WHIDEN)
{
	init();
	cx_max = w;
	cy_max = h;
	wwrk = cx_max - xwrk;
	hwrk = cy_max - xwrk;
	hsur = hwrk + xwrk - ywrk;
	if (hsur<fonth*2) hsur=fonth*2;
	wsur = wwrk;
}

void SendEvent(Window *w, int event, int key, int x, int y)
{
	GuiEvent e(event,key,x,y);
	w->SendToWindow(&e);
}

void SendEvent(Window *w, int event, int x, int y, int ww, int hh)
{
	GuiEvent e(event,0,x,y,ww,hh);
	w->SendToWindow(&e);
}

void App::Timer(void)
{
	static unsigned int last=0,sec=0;
	if ((unsigned int)time(0) != last)
	{
		last = time(0);
		if (OnEverySecond) OnEverySecond(sec++);
	}
}

static void InitCRC(void)
{
  int I, J;
  unsigned int C;

  for (I=0;I<256;I++)
  {
    for (C=I,J=0;J<8;J++)
      C=(C & 1) ? (C>>1)^0xEDB88320L : (C>>1);
    CRCTab[I]=C;
  }
}

unsigned int CalculateCRC(unsigned StartCRC, void *Addr, unsigned Size)
{
  unsigned I;
  if (!StartCRC) InitCRC();
  for (I=0; I<Size; I++)
    StartCRC = CRCTab[(unsigned char)StartCRC ^ ((unsigned char*)Addr)[I]] ^ (StartCRC >> 8);
  return(StartCRC);
}

void Window::WindowSetWorkRect(int x,int y,int w,int h)
{
    int flag = GetStatus();
	xpos = 1;
	ypos = 0;
	ywrk = y;
	xwrk = x;
	wwrk = w + xwrk;
	hwrk = h + ywrk;
	hsur = hwrk - ((flag & WFRAMED) ? BASEBORDER : 0) + xwrk - ywrk;
	if (hsur<fonth*2) hsur=fonth*2;
	wsur = wwrk - ((flag & WFRAMED) ? BASEBORDER : 0);
}

void Window::WindowGetWorkRect(int& x,int& y,int& w,int& h)
{
	x = xwrk;
	y = ywrk;
	w = wwrk - xwrk;
	h = hwrk - ywrk;
}

//
// Configuration file handling	   (for fastgl)
//

int Config::find(char * s)
{
	for (int i=0;i<entries;i++)
	{
		if (!strcmp(pole[i].name,s)) return i;
	}
	return -1;
}

void Config::CreateEmpty(void)
{
	char s[100] = "; ";
	strcat(s,name);
	WriteComment(s);
	WriteComment(";<.......name of item..........> t <...body of item... (LF)");
	WriteComment("; where 'name' is string up to 32 chars length");
	WriteComment("; where 't' is one of 's'(tring), 'i(nt)' or 'd'(ouble)");
	WriteComment("; Warning! don't use TABs! & STRING MUST be enclosed in double \"\"");
	WriteComment("|..............................| T |.............................");
}

Config::Config(char * s)
{
	char nn[128];
#ifdef __MSDOS__
	sprintf(nn, "%s.rc", s);
#else
	sprintf(nn, "%s/.%s.rc", App::homedir, s);
#endif
	strncpy(name, nn, 63);
	change = 0;
	entries = 0;
	if (cApp->flags&APP_CFG && verbose) cprintf("Opening config file '%s'\n", name);
	f = fopen(name,"r");
	if (f)
	{
		ReadConfig();
		fclose(f);
	}
	else 
	{
		CreateEmpty();
	}
}
		
Config::~Config()
{
	if (cApp->flags&APP_CFG) Sync();
}

void  Config::WriteComment(char * s)
{
	int i;
	if (entries>=MAX_CONF_ITEMS) return;
	if ((i=find(s))==-1) pole[entries++].ModifyNode(s);
	else  pole[i].ModifyNode(s);
	change = 1;
}

void  Config::WriteInt(char * s, int i)
{
	int ii;
	if (entries>=MAX_CONF_ITEMS) return;
	if ((ii=find(s))==-1) pole[entries++].ModifyNode(s,i);
	else  pole[ii].ModifyNode(s,i);
	change = 1;
}

void  Config::WriteString(char * s, char * i)
{
	int ii;
	if (strlen(i)>127) return;
	if (entries>=MAX_CONF_ITEMS) return;
	if ((ii=find(s))==-1) pole[entries++].ModifyNode(s,i);
	else  pole[ii].ModifyNode(s,i);
	change = 1;
}

void  Config::WriteDouble(char * s, double i)
{
	int ii;
	if (entries>=MAX_CONF_ITEMS) return;
	if ((ii=find(s))==-1) pole[entries++].ModifyNode(s,i);
	else  pole[ii].ModifyNode(s,i);
	change = 1;
}

void Config::ReadConfig(void) 
{
	char s[256], *p, n[33], *t;
	int typ,i;
	double d;
	
	for(;entries<MAX_CONF_ITEMS;)
	{
		*s = 0;
		fgets(s,255,f);
		if (!*s) break;
		*(s+strlen(s)-1) = 0;
		p = s;
		t = n;
		if (!isalpha(s[0]) && *s != '_') 
		{
			pole[entries].ModifyNode(s);
		}
		else
		{
			while(isalnum(*p) || *p=='_') (*t++) = (*p++);
			*t = 0;
			switch(typ = s[33])
			{
				case _DOUBLE:
					d = atof(s+35);
					pole[entries].ModifyNode(n,d);
					break;
				case _INT:
					i = atoi(s+35);
					pole[entries].ModifyNode(n,i);
					break;
				case _STRING:
					t = s+36;
					while(*t!='"') t++;
					*t = 0;
					pole[entries].ModifyNode(n,s+36);
					break;
			}
		}
		entries++;
	}
}

void Config::Sync(void)
{
	char s[256];
	
	if (change==0) return;
	if (verbose) printf("Writing config file '%s'\n", name);
	f = fopen(name,"w");
	for(int i=0;i<entries;i++)
	{
		switch(pole[i].type)
		{
			case _COMMENT:
				fputs(pole[i].s,f);
				break;
			case _STRING:
				sprintf(s, "%-32s %c \"%s\"", pole[i].name, pole[i].type, pole[i].s);
				fputs(s,f);
				break;
			case _INT:
				sprintf(s, "%-32s %c %d", pole[i].name, pole[i].type, pole[i].i);
				fputs(s,f);
				break;
			case _DOUBLE:
				sprintf(s, "%-32s %c %f", pole[i].name, pole[i].type, pole[i].d);
				fputs(s,f);
				break;
		}
		fputc('\n',f);
	}
	fclose(f);
}

BaseGui::BaseGui(int xs, int ys, int ws, int hs, char *nm, int typ, int i, int p, long flag)
{
	assert(inGraph);
	set_ppop(_GSET);
	if (nm)
	{
		assert(name	 = new char[strlen(nm)+1]);
		strcpy(name,nm);
	}
	else
	{
		assert(name	 = new char[1]);
		*name=0;
	}
	type = typ;
	status = flag;
	id = counter++;
	next = (BaseGui	*)0;
	parameter1 = -1;
	if (typ==WINDOW	&& flag&WUSELAST) entryPoint->Add(xs, ys, ws, hs, name,flag);
	if (typ	!= PSEUDOWINDOW) PositionCheck(xs, ys, ws, hs);
	if (typ==WINDOW	&& flag&WCENTRED)
	{
		xs = (X_width-ws)/2;
		ys = (Y_width-hs)/2;
	}
	x =	xs;
	y =	ys;
	w =	ws;
	h =	hs;
	ink   = i;
	paper =	p;
	if (!MOVEABLE) status |= WUNMOVED;
}

void BaseGui::Rechain(BaseGui *l, BaseGui *n)  // place to object chain
{
	if (!n && !l) // no more windows ...
	{
	}
	else if	(n==(BaseGui *)0)	// last in queqe
	{
		l->next	= (BaseGui *)0;
	}
	else if	(l==(BaseGui *)0)	// first in queqe
	{
		n->last	= (BaseGui *)0;
	}
	else if	(n && l)
	{
		l->next	= n;
		n->last	= l;
	}
}

BaseGui::~BaseGui()
{
	BaseGui	*l,	*n;
	if (type ==	PSEUDOWINDOW) return;
	counter--;
	if (name) delete name;
	l =	last;
	n =	next;
	Rechain(l,n);
}

void Window::SendToWindow(GuiEvent *p)
{
	if (image==0) IError("Internal Error 1 (SendToWindow)",	1);
	else if	(handler)
	{
		assert(this);
		p->wnd = this;
		handler(p);
	}
}

void MenuWindow::MenuWindowHandler(GuiEvent *p)
{
	if (Proc) Proc(p);
	if (CurrentMenu==0) return;
	switch(p->Type())
	{
		case KEYEVENT:
			if (p->Key() !=	ESC) break;
			delete CurrentMenu;
			break;
		case ACCELEVENT:
			p->accel->RunHandler();
			if (!(p->guiType ==	PUSHBUTTON || p->guiType ==	MENUBUTTON || p->guiType == MENUBUTTON2))  break;
		case LOSTFOCUSEVENT:
		case TERMINATEEVENT:
			if (CurrentMenu == p->wnd) delete CurrentMenu; // do not delete others
			break;
	}
}

Window::Window(Window **wp, int xs, int ys, int ws, int hs, char *nm, GuiHwnd hnd, int i, int p, int flag):
  BaseGui(xs, ys, ws, hs, nm, flag & WMENUWINDOWTYPE ? MENUWINDOW : WINDOW, i, p, flag|WEXIST)
{
	Window *lst;

	init();
	rebuild = 1;
	entryPoint->DatabaseGetIcon(icon_x, icon_y, name);
	if (current) FlushInput();
	if (current) if (current->GetStatus()&WMENUWINDOWTYPE && GetCnt()>1)
	{
		GuiEvent e(TERMINATEEVENT);
		current->SendToWindow(&e);
	}
	assert(image = new FGPixel[areasize(GetW(), GetH())]);

	if (wp) *wp = this;			// save pointer to itself
	itself = wp;
	
	handler = hnd;
	if (nWnd)			// first window
	{
		lst = current;
	}
	else
	{
		lst = (Window *) 0;		// get addr of previous
		first = this;
	}
	current = this;
	nWnd++;
	SetLast(lst);
	Image = image;
	cx_max = GetW();
	cy_max = GetH();
	statuscolor = CScheme->statusbar;
	ywrk = 0;
	if (flag & WFRAMED)
		ywrk += BASEBORDER;
	if (flag & WTITLED)
		ywrk += (TITLEH+2);
	if (flag & WMENU)
		ywrk += (MENUH+1);

	xwrk = 0;
	if (flag & WFRAMED)
		xwrk += BASEBORDER;
	wwrk = cx_max - xwrk;
	hwrk = cy_max - xwrk;
	if (flag & WSTATUSBAR)
		hwrk -= STATUSBARH;

	hsur = hwrk - ((flag & WFRAMED) ? BASEBORDER : 0) + xwrk - ywrk;
	if (hsur<fonth*2) hsur=fonth*2;
    
	wsur = wwrk - ((flag & WFRAMED) ? BASEBORDER : 0);
	if (lst)
	{
		GuiEvent e(LOSTFOCUSEVENT);
		lst->SendToWindow(&e);
		lst->WindowStatus(WDEACTIVE);
		lst->SetNext(this);
	}
	Context();
	first_draw = 0;
	if (!(status&WICONWINDOWTYPE)) draw();
	GuiEvent e(INITEVENT);
	set_fcolor(i);
	set_bcolor(p);
	SendToWindow(&e);
	if ((lst && flag & WLASTFOCUS) || (lst && lst->GetStatus() & WMODAL) && nWnd)
		lst->WindowFocus();
	set_fcolor(i);
	set_bcolor(p);
	idm = oldidm = 0;
	idw = oldidw = 0;
}

// ROOT wnd
Window::Window(Window **wp, FGPixel color):
  BaseGui(0, 0, X_width, Y_width, "Root", PSEUDOWINDOW, get_fcolor(), get_bcolor(), WEXIST)
{
	Window *lst;
	init();
	rebuild = 1;
	assert(!current);		// must be first
	assert(image = new FGPixel[areasize(GetW(), GetH())]);
	FGmemset(image, color, GetW()*GetH());

	if (wp) *wp = this;			// save pointer to itself
	itself = wp;
	
	lst = (Window *) 0;		// get addr of previous
	first = this;
	current = this;
	nWnd++;
	SetLast(lst);
	Image = image;
	cx_max = GetW();
	cy_max = GetH();

	wwrk = cx_max - xwrk;
	hwrk = cy_max - xwrk;
	hsur = hwrk + xwrk - ywrk;
	if (hsur<fonth*2) hsur=fonth*2;
	wsur = wwrk;
	Context();
	DoRootWindow = 1;
}

void Window::RemoveControls(void)
{
	BaseGui *butony = Buttony, *butony2;
	while (butony)
	{
		butony2 = butony->GetNext();
		delete butony;
		butony = butony2;
	}
	GuiEvent::AutoRepeatEnd();
}

Window::~Window()
{
	BaseGui *l, *n;
	BaseGui *last, *novy;

	if (GetType() == PSEUDOWINDOW || image == 0) return;
//	if (status&WMINIMIZE)
//		entryPoint->DatabaseSetIcon(icon_x, icon_y, name);

	FlushInput();
	status &= ~WEXIST;
	GuiEvent e(TERMINATEEVENT);
	SendToWindow(&e);

	if (itself) *itself = 0;
	RemoveControls();
	last = GetLast();
	if (!shut_down) WindowUpdate(0,0,1);		// delete all
	SetStatus(0);			// no anythings
	if (nWnd<=1)			// last in system
	{
		delete image;
		image = 0;
		first = current = 0;
		nWnd  = 0;
		return;
	}
	rebuild = 1;
	if (!last) return;// rusim neposledne aktivne okno

	novy = this==current ? last:current;
	novy->SetNext(0);
	nWnd--;
	l = GetLast();
	n = GetNext();
	if (n == (Window *) 0)		// last in queqe
	{
		current = (Window *) l;
	}
	else if (l == (Window *) 0)	// first in queqe
	{
		first = (Window *) n;
	}
	delete image;
	image = 0;
	idm = oldidm = 0;
	idw = oldidw = 0;
	((Window *) novy)->WindowStatus(WACTIVE);
}

void ButtonGroup::AddToGroup(Control *p, int activ)
{
	int i;
	if (count>=size)
	{
		IError("ButtonGroup - out of range!", 0);
		return; // maximum numbers reached
	}
	for(i=0;i<count;i++)
	{
		assert(p != array[i]);
	}
	i = p->GetType();
	if (i!=BaseGui::POINTBUTTON && i!=BaseGui::CHECKBUTTON && i!=BaseGui::PUSHBUTTON) return; // bad type
	if (type==0) 
	{
	    if (i==BaseGui::CHECKBUTTON || i==BaseGui::POINTBUTTON) type=1;
	    else type=2;
	}
	else if (type==1 && i==BaseGui::PUSHBUTTON) IError("ButtonGroup mismatch",0);
	else if (type==2 && (i==BaseGui::POINTBUTTON || i==BaseGui::CHECKBUTTON)) IError("ButtonGroup mismatch",0);
	array[count++] = p;
	p->RegisterToGroup(this); // say to button for group members
	if (activ && !curr) 
	{
	    curr = p;
	    if (type==1) p->SetTrigger(1);
	    else ((PushButton *)p)->Push();
	}
}

void Control::RefreshGroup(void) 
{ 
	if (grp) 
		grp->RefreshGroup(this); 
	idm = oldidm = 0;
}

void ButtonGroup::RefreshGroup(Control *c)
{
	PushButton *pb1=(PushButton *)c;
	switch(type)
	{
		case 1:
			if (curr) curr->SetTrigger(0);
			if (curr == c) // to same
			{
				curr->SetTrigger(1);
			}
			break;
		case 2:
			if (curr) ((PushButton *)curr)->Release();
			pb1->Push();
			break;
	}
	curr = c;
}

void Slider::MoveIn(void)
{
	Window *tmp = owner->Context();
	set_ppop(_GSET);
	set_fcolor(CYELLOW);
	Rect(GetX(),GetY(),GetW(),GetH());
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

void Slider::MoveOut(void)
{
	Window *tmp = owner->Context();
	set_ppop(_GSET);
	frame(GetX(),GetY(),GetW(),GetH());
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

void Slider::frame(int x, int y, int w, int h, int f) 
{
	set_fcolor(f?CWHITE:CBLACK);
	Vline(x, y, h);
	Hline(x, y, w);
	set_fcolor(CGRAYED);
	Vline(x + w - 2, y + 1, h - 2);
	Hline(x + 1, y + h - 2, w - 2);
	set_fcolor(f?CBLACK:CWHITE);
	Vline(x + w - 1, y + 0, h - 0);
	Hline(x + 0, y + h - 1, w - 1);
}

void SlideBarH::draw(void)
{
	Window *tmp = Window::GetCurrent();
	static char str[40];
	unsigned dl=0, a = set_font(FONT0808), st;
	set_ppop(_GSET);
	owner->Context();
	st = GetStatus();
	switch (st & 7)
	{
		case BNORMAL:
			set_fcolor(CScheme->slider);
			Boxw(GetX() + 1, GetY() + 1, GetW() - 3, GetH() - 3);
			frame(GetX(),GetY(),dl=(maxv-minv)/steps+16+6,GetH());
			frame(GetX()+dl,GetY(),GetW()-dl,GetH());
			frame(GetX()+3+((*val-minv)/steps),GetY()+2,16,12,1);
			set_colors(CBLACK, CScheme->slider);
			sprintf(str, "%3d", *val);
			Textw(GetX()+dl+2,GetY()+4,str);
			break;

		case BDISABLED:
			set_fcolor(CGRAY2);
			Boxw(GetX() + 1, GetY() + 1, GetW() - 3, GetH() - 3);
			frame(GetX(),GetY(),dl=(maxv-minv)/steps+16+6,GetH());
			frame(GetX()+dl,GetY(),GetW()-dl,GetH());
			frame(GetX()+3+((*val-minv)/steps),GetY()+2,16,12,1);
			set_colors(CGRAY1, CGRAY2);
			sprintf(str, "%3d", *val);
			Textw(GetX()+dl+2,GetY()+4,str);
			break;

		case BUNVISIBLE:
			set_fcolor(GetPaper());
			Boxw(GetX(), GetY(), GetW(), GetH());
			break;
	}
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
	if (fnc) fnc(this);
}

void SlideBarH::ClickMove(int dx, int)
{
	modify(dx-GetX()-10+owner->xwrk);
}

void SlideBarV::ClickMove(int, int dy)
{
	modify(dy-GetY()-10+owner->ywrk);
}

void SlideBarH::ClickDown(void)
{
	modify((GetMouseX()-owner->GetX())-GetX()-10);
}

void SlideBarV::ClickDown(void)
{
	modify((GetMouseY()-owner->GetY())-GetY()-10);
}

void Slider::modify(int value)
{
	if (value>= 0)
	{
	    *val = maxv;
	}
	else if (value < (maxv-minv)/steps+8)
	{
	    *val = minv;
	}
	if (value>= 0 && value < (maxv-minv)/steps)
	{
	    *val = minv+value*steps;
	}
	draw();
}

void SlideBarV::draw(void)
{
	Window *tmp = Window::GetCurrent();
	static char str[40];
	unsigned dl=0, a = set_font(FONT0808), st;
	set_ppop(_GSET);
	owner->Context();
	st = GetStatus();
	switch (st & 7)
	{
		case BNORMAL:
			set_fcolor(CScheme->slider);
common:		Boxw(GetX() + 1, GetY() + 1, GetW() - 3, GetH() - 3);
			frame(GetX(),GetY(),GetW(), dl=(maxv-minv)/steps+16+6);
			frame(GetX(),GetY()+dl,GetW(),GetH()-dl);
			frame(GetX()+2, GetY()+3+((*val-minv)/steps),12,16,1);
			set_colors(CBLACK, CScheme->slider);
			str[0] = char((*val%1000)/100+'0');
			str[1] = 0;
			str[2] = char((*val%100)/10+'0');
			str[3] = 0;
			str[4] = char(*val%10+'0');
			str[5] = 0;
			str[6] = char((*val%10000)/1000+'0');
			str[7] = 0;
			Textw(GetX()+4,GetY()+dl+3,str+6);
			Textw(GetX()+4,GetY()+dl+11,str);
			Textw(GetX()+4,GetY()+dl+19,str+2);
			Textw(GetX()+4,GetY()+dl+27,str+4);
			break;

		case BDISABLED:
			set_fcolor(CScheme->slider+1);
			goto common;

		case BUNVISIBLE:
			set_fcolor(GetPaper());
			Boxw(GetX(), GetY(), GetW(), GetH());
			break;
	}
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
	if (fnc) fnc(this);
}

int Config::ReadInt(char * s)
{
	int	n =	find(s);
	if (n>=0) return pole[n].i;
	return 0;
}

char const * Config::ReadString(char * s)
{
	int	n =	find(s);
	if (n>=0) return (char	const *)pole[n].s;
	return "";
}

double Config::ReadDouble(char * s)
{
	int	n =	find(s);
	if (n>=0) return pole[n].d;
	return 0.0;
}
	
int	   Config::ReadInt(char	* s, int &p)
{
	int	n =	find(s);
	if (n>=0) return (p = pole[n].i), 1;
	return 0;
}

int	   Config::ReadString(char * s,	char *p, int max)
{
	int	n =	find(s);
	if (max>128) max = 128;
	if (n>=0)
	{
	 	strncpy(p,pole[n].s,max);
		return 1;
	}
	return 0;
}

int	   Config::ReadString(char * s,	char **p)
{
	int	n =	find(s);
	if (n>=0)
	{
	 	*p = pole[n].s;
		return 1;
	}
	return 0;
}

int	   Config::ReadDouble(char * s,	double &p)
{
	int	n =	find(s);
	if (n>=0) return (p = pole[n].d), 1;
	return 0;
}

void MenuWindow::Separator(void)
{
	int i;
	WindowBox(GetXM(), i=GetYM(7)+3, GetWW()-8, 1, CGRAYED);
	WindowBox(GetXM(), i+1, GetWW()-8, 1, CWHITED);
}

PushButton *Window::AddPushButton(int xs, int ys, int ws, int hs, char *nm,	int	key, ControlCall f, int flag)
{
	return new PushButton(xs, ys, ws, hs, nm, key, flag,this,f);
}

PushButton *Window::AddPushButton(int xs, int ys, int key, Bitmap *bm, ControlCall f, int flag)
{
	if (bm->GetType()==0) return	0;
	return new PushButton(xs, ys, key, flag,this,bm, f);
}

SlideBarH *Window::AddSlideBarH(int xs, int ys, int min, int max, int step, int *val, ControlCall f)
{
	return new SlideBarH(xs, ys, min, max, step, val, this,f);
}

SlideBarV *Window::AddSlideBarV(int xs, int ys, int min, int max, int step, int *val, ControlCall f)
{
	return new SlideBarV(xs, ys, min, max, step, val, this,f);
}

CheckButton	*Window::AddCheckButton(int	xs,	int	ys,	char *nm, int key, int * variable, ControlCall f, int flag)
{
	return new CheckButton(1,xs, ys, nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

PointButton	*Window::AddPointButton(int	xs,	int	ys,	char *nm, int key, int * variable, ControlCall f, int flag)
{
	return new PointButton(1,xs, ys, nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

CheckButton	*Window::AddCheckButtonMask(int m, int	xs,	int	ys,	char *nm, int key, int * variable, ControlCall f, int flag)
{
	return new CheckButton(m, xs, ys, nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

PointButton	*Window::AddPointButtonMask(int m, int	xs,	int	ys,	char *nm, int key, int * variable, ControlCall f, int flag)
{
	return new PointButton(m, xs, ys, nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

EditBox	*Window::AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, int *p, ControlCall f, int min, int max)
{
	return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, min,	max, 1);
}

EditBox	*Window::AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, int *p, ControlCall f)
{
	return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, 0, 0, 0); // no checking
}

EditBox	*Window::AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, char *p, ControlCall f)
{
	return new EditBox(0, xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f);
}

EditBox	*Window::AddEditBox(int sz, int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, char *p, ControlCall f)
{
	return new EditBox(sz, xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f);
}

EditBox	*Window::AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, double *p, ControlCall f, double min, double max)
{
	return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, min,	max, 1);
}

EditBox	*Window::AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, double *p, ControlCall f)
{
	return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, 0, 0, 0); // no checking
}

BaseMenu *Window::AddBaseMenu(char *nm,	int	key, ControlCall f)
{
	return new BaseMenu(GetXM(strlen(nm)*8+8), GetYM(),	strlen(nm)*8+8,	16,	nm,	key, this, CScheme->menu_back, CScheme->menu_fore, f, MENUBUTTON);
}

BaseMenu *MenuWindow::AddMenu(char *nm,	int	key, ControlCall f)
{
	return new BaseMenu(GetXM(), GetYM(18),	GetWW()-8, 18, nm, key,	this, GetPaper(), GetInk(), f, MENUBUTTON2);
}

CheckButton	*MenuWindow::AddCheckButton(char *nm, int key, int * variable, ControlCall f, int flag)
{
	return new CheckButton(1, GetXM(),	GetYM(18), nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

PointButton	*MenuWindow::AddPointButton(char *nm, int key, int * variable, ControlCall f, int flag)
{
	return new PointButton(1, GetXM(),	GetYM(18), nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

CheckButton	*MenuWindow::AddCheckButtonMask(int m, char *nm, int key, int * variable, ControlCall f, int flag)
{
	return new CheckButton(m, GetXM(),	GetYM(18), nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

PointButton	*MenuWindow::AddPointButtonMask(int m, char *nm, int key, int * variable, ControlCall f, int flag)
{
	return new PointButton(m, GetXM(),	GetYM(18), nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

EditBox	*MenuWindow::AddEditBox(int	ws1, int ws2, char *nm,	int	key, int *p, ControlCall f, int min, int max)
{
	return new EditBox(GetXM(),	GetYM(24), ws1,	ws2, nm, key, this, p, GetInk(),GetPaper(), f, min, max, 1);
}

EditBox	*MenuWindow::AddEditBox(int	ws1, int ws2, char *nm,	int	key, int *p, ControlCall f)
{
	return new EditBox(GetXM(),	GetYM(24), ws1,	ws2, nm, key, this, p, GetInk(),GetPaper(),f, 0, 0, 0);
}

EditBox	*MenuWindow::AddEditBox(int	ws1, int ws2, char *nm,	int	key, char *p, ControlCall f)
{
	return new EditBox(0, GetXM(),	GetYM(24), ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f);
}

EditBox	*MenuWindow::AddEditBox(int sz, int	ws1, int ws2, char *nm,	int	key, char *p, ControlCall f)
{
	return new EditBox(sz, GetXM(),	GetYM(24), ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f);
}

EditBox	*MenuWindow::AddEditBox(int	ws1, int ws2, char *nm,	int	key, double	*p, ControlCall f, double min, double max)
{
	return new EditBox(GetXM(),	GetYM(23), ws1,	ws2, nm, key, this,	p, GetInk(), GetPaper(),	f, min,	max, 1);
}

EditBox	*MenuWindow::AddEditBox(int	ws1, int ws2, char *nm,	int	key, double	*p,ControlCall f)
{
	return new EditBox(GetXM(),	GetYM(23), ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, 0, 0, 0);
}

ListBox * Window::AddListBox(int xs, int ys, int wpol, int hpol, int w, int h, int *cnt, int *pos, void (*drawone)(int,int,int,int,void *), void *data)
{
	return new ListBox(xs, ys, wpol, hpol, w, h, cnt, pos, drawone, this, data);
}

ListBox * Window::AddListBox(int xs, int ys, int wpol, int hpol, int w, int h, int cnt, void (*drawone)(int,int,int,int,void *), void *data)
{
	return new ListBox(xs, ys, wpol, hpol, w, h, cnt, drawone, this, data);
}

void ProgressBar::draw(void)
{
	int tmp;
	char s[16];
 	int fnt=set_font(2);

	tmp = (int)((w/(float)steps)*value);
	if (tmp!=sirka) // changed
	{
		Window *doc = owner->Context();
		set_ppop(_GSET);
		set_fcolor(CWHITE);
		Rectw(x-2,y-2,w+4,h+4);
		Rectw(x,y,w+1,h+1);
		set_fcolor(CBLACK);
		Rectw(x-2,y-2,w+3,h+3);
		Rectw(x-1,y-1,w+1,h+1);
		set_fcolor(paper);
		Boxw(x,y,tmp,h);
		set_fcolor(ink);
		Boxw(x+tmp,y,w-tmp,h);
		sprintf(s,"%d%%", (int)((100./steps)*value)+1);
		if (tmp>=(int)strlen(s)*8)
		{
			set_colors(ink,paper);
			Textw(x+tmp/2-strlen(s)*4,y+h/2-8,s);
		}
		owner->WindowRepaint(x-2,y-2,w+4,h+4);
		doc->Context();
	}
	sirka = tmp;
	set_font(fnt);
}

ProgressBar::ProgressBar(Window *win, int xx, int yy, int ww, int hh, int s)
	: Control(xx, yy, ww, hh, 0, PROGRESSBAR, 0, BNORMAL, win, 0)
{
	if (s<=0)
	{
	     s=100;
	     IError("ProgressBar: (step <= 0)", 0);
	}
	steps = s;
	value = 0;
	sirka = -1;
	ink = CWHITE;
	paper = CBLUELIGHT;
	draw();
}

ProgressBar *Window::AddProgressBar(int xs, int ys, int ws, int hs, int size)
{
    return new ProgressBar(this, xs,ys,ws,hs,size);
}

void Label::draw(void)
{
	int tmp = set_font(font_size);
	Window *ctx = owner->Context();
	w = fontw*strlen(name);
	h = fonth;
	if (is_transparent) set_ppop(_GTRANSP); else set_ppop(_GSET);
	set_colors(ink+high_light,paper);
	Text(x,y,name);
	owner->WindowRepaintUser(x,y,w,h);
	set_font(tmp);
	set_ppop(_GSET);
	ctx->Context();
}

Label *Window::AddLabel(int x, int y, char *s, int key, ControlCall f, int i, int p)
{
	return new Label(x,y,s,key,this,f,i==-1?this->ink:i, p==-1?this->paper:p);
}
void Control::RunHandler(void)
{
	if (this)
	{
		cControl = this;
		if (call_handler) 
		    if (call_handler->fnc) 
			call_handler->fnc(call_handler);
		call_handler = 0; // no more call it
	}
}

void BaseGui::Resize(int dx, int dy)
{ 
	w += dx;
	h += dy; 
	entryPoint->DatabaseResize(w,h,name); 
}

void BaseGui::Relocate(int xx, int yy) 
{ 
	x += xx;
	y += yy; 
	entryPoint->DatabaseRelocate(x,y,name); 
}

static Window *_Note_Ptr, *close_adept;

static void Yes_No(CallBack t)
{
	GuiEvent e(NOTIFYEVENT, t->GetLocalId());
	delete _Note_Ptr;
	close_adept->SendToWindow(&e);
	close_adept = 0;
}

int Window::ShowNotify(void)
{
	if (status&WNOTIFY && !close_adept && changed)
	{
		close_adept = this;
		_Note_Ptr = new Window(&_Note_Ptr, 320, 334, 308, 148, "Note!", 0, CYELLOW, CREDLIGHT, 0xa7);
		_Note_Ptr->AddPushButton(168, 72, 64, 21, "No", 'n', Yes_No);
		_Note_Ptr->AddPushButton(56, 72, 64, 21, "Yes", 'y', Yes_No);
		_Note_Ptr->WindowText(32, 24, "Text has been changed, save ?");
		return 1;
	}
	else if (status&WNOTIFY && !close_adept)

 // not changed -> close immediatelly
	{
		GuiEvent e(NOTIFYEVENT, 0);
		SendToWindow(&e);
		return 1;
	}
	return 0;
}

int	Window::TestNullHandler(void)
{
	if (current->ShowNotify()) return 1;
	if (current->status&WNOPICTO)
	{
		IError("Can`t close this window",0);
		return 1;
	}
	return 0;
}

static void ShowEfect(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2)
{
	set_ppop(_GNOT);
	int s=25, xs=(x2-x1)/s, ys=(y2-y1)/s, ws=(w2-w1)/s, hs=(h2-h1)/s;
	for(;s;s--)
	{
		draw_box(x1,y1,w1,h1);
		draw_box(x1+1,y1+1,w1,h1);
		draw_box(x1+1,y1+1,w1,h1);
		draw_box(x1,y1,w1,h1);
		x1 += xs;
		y1 += ys;
		w1 += ws;
		h1 += hs;
	}
	set_ppop(_GSET);
}

int Window::iconize(int xs, int ys)
{
	int rc;
//	Window *ww;
	if (!(status&WMINIMIZE)) return 0; // bad window
	if (iconized==0)
	{
		if (fulldrag && icon) ShowEfect(x,y,w,h,xs,ys,icon->GetW(),icon->GetH());
		WindowStatus(WHIDE);
		iconized = new IconWindow(this, xs, ys, icon);
//		ww = ((Window *)first->GetNext());
// BULGAR workaround
//		if (ww) ww->WindowFocus();
//		iconized->WindowFocus();
//
		int f = set_font(0);
		iconized->WindowText(0,0,name);
		set_font(f);
		icon_x = xs;
		icon_y = ys;
		rc = 1;
	}
	else
	{
		icon_x = iconized->x;
		icon_y = iconized->y;
		if (fulldrag) ShowEfect(icon_x, icon_y, icon->GetW(),icon->GetH(),x,y,w,h);
		delete iconized;
		iconized=0;
		WindowStatus(WVISIBLE);
		WindowFocus();
		rc = 2;
	}
	entryPoint->DatabaseSetIcon(icon_x, icon_y, name);
	GuiEvent e(ICONIZEEVENT, IsIconized());
	SendToWindow(&e);
	return rc;
}

int Window::WindowIconize(void)
{
	if (icon_x==-1 && icon_y==-1)
		return iconize(GetMouseX()-16, GetMouseY()-16);
	else
		return iconize(icon_x, icon_y);
}

int Window::WindowIconize(int xs, int ys)
{
	return iconize(xs, ys);
}

void Window::init(void)
{
	itself = 0;
	handler = 0;
	Buttony = 0;
	lastButton = 0;
	nControls = 0;
	c_menupos = 1;
	CallWindowHook = 0;
	changed = 0;
	iconized = 0;
	icon = 0;
	icon_x = -1;
	icon_y = -1;
	xpos = 1;
	ypos = 0;
	ywrk = 0;
	xwrk = 0;
}

//
// trace all windows and build overlaping map for each one
//
void Window::BuildOverlays(Window *posledne)
{
	int rc;

	if (current==0) return;
	Window *prve=first;
	while(prve)
	{
		prve->ovr.deallocate();	// delete previous map
		if (prve==posledne) break;
		rc = prve->OdkryteOkno(posledne, x, y, w, h); // first test
//::printf("%s::\n", prve->GetName());
		if (rc>0) do
		{
//::printf(" %s", posledne->GetName());
			prve->ovr.insert(posledne);
			posledne = (Window *)((BaseGui *)posledne)->GetLast();
		} while (posledne && prve != posledne);
		prve = (Window *)((BaseGui *)prve)->GetNext();
	}
}

