
#include <signal.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "mylib.h"

static struct sigaction old_alarm_handler;

static int timer_installed = 0;

static struct itimerval old_timer;

struct my_timer {
	void (*proc)();
	int	speed;
	int	c;
};

static struct my_timer *timerstr[MAX_TIMERS];

int timer_counter = 0;

void sig_handler ( int v )
{
 int i;

 timer_counter++;

 for ( i=0; i<MAX_TIMERS; i++ )
	if ( timerstr[i]!=NULL ) {
		timerstr[i]->c+= 1<<7;
		if ( timerstr[i]->c >= timerstr[i]->speed ) {
			timerstr[i]->proc();
			timerstr[i]->c -= timerstr[i]->speed;
		}
	}

}


int my_install_timer ()
{
 struct itimerval timerv;
 struct sigaction siga;

 if ( timer_installed ) return 1;

 siga . sa_handler = sig_handler;
 siga . sa_flags = 0;

 __memset ( &siga.sa_mask, 0, sizeof ( sigset_t ) );

  sigaction ( SIGALRM, &siga, &old_alarm_handler );

 timerv . it_interval .  tv_sec = 0;
 timerv . it_interval . tv_usec = 10000;
 timerv . it_value = timerv . it_interval;

 if ( setitimer ( ITIMER_REAL, &timerv, &old_timer ) ) {
                fprintf(stderr, "libmy: setitimer call failed!\n");
		perror("setitimer");
		return 0;
 }

 timer_installed = 1;
 timer_counter = 0;

 return 1;

}

int my_remove_timer ()
{
 int i;

 if ( !timer_installed ) return 1;

 if ( setitimer ( ITIMER_REAL, &old_timer, 0 ) == -1 ) {
	fprintf( stderr, "libmy: setitimer call failed!\n");
	perror("setitimer");
	return 0;
 }

 if ( sigaction ( SIGALRM, &old_alarm_handler, NULL ) == -1 ) {
	fprintf( stderr, "libmy: sigaction call failed!\n");
	perror("sigaction");
	return 0;
 }

 for ( i=0; i<MAX_TIMERS; i++ ) {
	if ( timerstr[i] != NULL ) free ( timerstr[i] );
	timerstr[i] = NULL;
 }

 timer_installed = 0;

 return 1;

}

int my_install_int(void (*proc)(), int speed)
{
 int i;

 if ( !my_install_timer () ) return 0;

 for ( i=0; i<MAX_TIMERS; i++ )
	if ( timerstr[i] != NULL ) if ( timerstr[i]->proc == proc ) {
		timerstr[i]->speed = (1000<<7)/speed;
		return 1;
	}

 for ( i=0; i<MAX_TIMERS; i++ ) if ( timerstr[i] == NULL ) break;

 if ( i == MAX_TIMERS ) return 0;

 timerstr[i] = malloc ( sizeof ( struct my_timer ) );

 timerstr[i]->speed = (1000<<7)/speed;
 timerstr[i]->proc = proc;
 timerstr[i]->c = 0;

 return 1;

}

int my_remove_int (void (*proc)())
{
 int i;

 for ( i=0; i<MAX_TIMERS; i++ ) if ( timerstr[i]->proc == proc ) break;
 if ( i == MAX_TIMERS ) return 0;
 free ( timerstr[i] );
 timerstr[i] = NULL;

 return 1;

}

int my_is_timer_installed ()
{
 return timer_installed;
}

int my_is_int_installed ( void (*proc)() )
{
 int i;

 for ( i=0; i<MAX_TIMERS; i++ ) if ( timerstr[i]->proc == proc ) return 1;

 return 0;

}

int my_set_int_speed ( void (*proc)(), int speed )
{
 int i,j = 0;

 if ( !timer_installed ) return 0;

 for ( i=0; i<MAX_TIMERS; i++ )
	if ( timerstr[i]->proc == proc ) {
		timerstr[i]->speed = (1000<<7)/speed;
		timerstr[i]->c = 0;
		j = 1;
	}

 if ( j == 0 ) return 0;
	else return 1;

}

int my_timer_count ()
{

 return timer_counter;

}

void my_sleep ( int sec )
{
 struct timeval tv;
 int s;

 gettimeofday (&tv, 0 );
 s = tv.tv_sec;
 while ( tv.tv_sec - s != sec ) gettimeofday (&tv, 0 );

}

void my_usleep ( int micsec )
{

 struct timeval tv;
 int s,t=0;

 if ( micsec >= 1000000 ) t = micsec / 1000000;
 my_sleep ( t );

 micsec -= t * 1000000;

 gettimeofday ( &tv, 0 );
 s = tv.tv_usec;

 for (;;) {
  if ( tv.tv_usec > s ) if ( tv.tv_usec - s > micsec ) break;
  if ( tv.tv_usec < s ) if ( tv.tv_usec + 1000000 - s > micsec ) break;
  gettimeofday ( &tv, 0 );
 }

}

void my_donothing()
{
}

