
#include <vga.h>

#include "mylib.h"

void my_vsync ()
{

 vga_waitretrace();

}

void my_set_color ( int index, RGB *p )
{

 vga_setpalette ( index, p->r, p->g, p->b );

}

void my_get_color ( int index, RGB *p )
{
 int r,g,b;

 vga_getpalette ( index, &r, &g, &b );
 p->r = r;
 p->g = g;
 p->b = b;

}

void my_set_palette ( PALETTE pal )
{

    my_set_palette_range ( pal, 0, 255 );

}

void my_get_palette ( PALETTE pal )
{

    my_get_palette_range ( pal, 0, 255 );

}

void my_set_palette_range ( PALETTE pal, int st, int end )
{
 int i;

 for ( i=st; i<=end; i++ )
	my_set_color ( i, &pal[i] );

}

void my_get_palette_range ( PALETTE pal, int st, int end )
{
 int i;

 for ( i=st; i<=end; i++ )
	my_get_color ( i, &pal[i] );

}

void my_fade_out ( int micsec )
{
 PALETTE P;
 int i;

 for ( i=0; i<256; i++ ) P[i].r = P[i].g = P[i].b = 0;

 my_fade_to ( P, micsec );

}

void my_fade_to ( PALETTE to, int speed )
{
 int x, i;
 PALETTE P;

 my_get_palette ( P );

 for ( ;; ) {
  x = 0;
  for ( i=0; i<256; i++ ) {
	if ( P[i].r < to[i].r ) { x=1; P[i].r++; }
	if ( P[i].r > to[i].r ) { x=1; P[i].r--; }
	if ( P[i].g < to[i].g ) { x=1; P[i].g++; }
	if ( P[i].g > to[i].g ) { x=1; P[i].g--; }
	if ( P[i].b < to[i].b ) { x=1; P[i].b++; }
	if ( P[i].b > to[i].b ) { x=1; P[i].b--; }
  }
  my_vsync();
  my_set_palette ( P );
  my_vsync();
  if ( !x ) break;
  my_usleep ( speed );
 }

}

