
#include <stdlib.h>
#include <vga.h>
#include <vgamouse.h>

#include "mylib.h"

unsigned char mouse_pointer_data[256] =
{
   16,  16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   16,  255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   16,  255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   16,  255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   16,  255, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   16,  255, 255, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0, 
   16,  255, 255, 255, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0, 
   16,  255, 255, 255, 255, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0, 
   16,  255, 255, 255, 255, 255, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0, 
   16,  255, 255, 255, 255, 255, 16,  16,  16,  0,   0,   0,   0,   0,   0,   0, 
   16,  255, 255, 16,  255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0, 
   16,  255, 16,  0,   16,  255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0, 
   0,   16,  0,   0,   16,  255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0, 
   0,   0,   0,   0,   0,   16,  255, 255, 16,  0,   0,   0,   0,   0,   0,   0, 
   0,   0,   0,   0,   0,   16,  255, 255, 16,  0,   0,   0,   0,   0,   0,   0, 
   0,   0,   0,   0,   0,   0,   16,  16,  0,   0,   0,   0,   0,   0,   0,   0
};

static int mouse_installed = 0;
static int mp_x;
static int mp_y;
static int mp_nx = 1;
static int mp_ny = 1;
static int mouse_pointer_on = 0;
static CBITMAP *mouse_bmp = NULL;
static BITMAP *mouse_bg = NULL;

int mouse_x;
int mouse_y;
int mouse_b;

void mouse_int ( )
{

 mouse_update ();

 mouse_x = mouse_getx();
 mouse_y = mouse_gety();
 mouse_b = 0;

 if ( mouse_getbutton () & MOUSE_LEFTBUTTON )
	mouse_b |= 1;
 if ( mouse_getbutton () & MOUSE_RIGHTBUTTON )
	mouse_b |= 2;
 if ( mouse_getbutton () & MOUSE_MIDDLEBUTTON )
	mouse_b |= 4;

 if ( mouse_pointer_on ) {		/* For some reason this works ;) I don't know why...*/
	if ( mp_x == mouse_x && mp_y == mouse_y ); else {
	if ( abs(mouse_x - mp_x)< mouse_bmp->w && abs(mouse_y - mp_y)< mouse_bmp->h ) {
		BITMAP *round;
		int x,y;
		round = my_create_bitmap ( mouse_bmp->w*2, mouse_bmp->h*2 );
		if ( mouse_x > mp_x ) x = mp_x - mp_nx;
			else x = mouse_x - mp_nx;
		if ( mouse_y > mp_y ) y = mp_y - mp_ny;
			else y = mouse_y - mp_ny;
		my_copy_bitmap ( round, GRAPHICS, x, y, round->w, round->h, 0, 0 ); 
		my_put_bitmap ( round, mouse_bg, mp_x-mp_nx-x, mp_y-mp_ny-y ); 
		my_copy_bitmap ( mouse_bg, round, mouse_x-x-mp_nx, mouse_y - y - mp_ny, mouse_bg->w, mouse_bg->h, 0, 0 ); 
		my_put_cbitmap ( round, mouse_bmp, mouse_x - x - mp_nx, mouse_y - y-mp_ny ); 
		my_put_bitmap ( GRAPHICS, round, x, y );
		my_destroy_bitmap ( round ); 
	} else { 
		my_put_bitmap ( GRAPHICS, mouse_bg, mp_x - mp_nx, mp_y - mp_ny ); 
		my_copy_bitmap ( mouse_bg, GRAPHICS, mouse_x - mp_nx, mouse_y - mp_ny, mouse_bg->w, mouse_bg->h, 0, 0 );
		my_put_cbitmap ( GRAPHICS, mouse_bmp, mouse_x - mp_nx, mouse_y - mp_ny );
	} 
	mp_x = mouse_x;
	mp_y = mouse_y; }
 }
}


int my_install_mouse ()
{
 int x;

 x = mouse_init ( "/dev/mouse", vga_getmousetype(), MOUSE_DEFAULTSAMPLERATE);

 if ( x == -1 ) return -1;

 if ( ! my_install_int ( mouse_int, 1000 ) ) {
	mouse_close();
	return 0;
 }

 mouse_installed = 1;

 my_position_mouse ( 50, 50 );

 if ( mouse_bmp == NULL ) {
	BITMAP *bmp;
	RGB r;
	bmp = my_create_bitmap ( 16, 16 );
	free ( bmp->data );
	bmp->data = mouse_pointer_data;
	mouse_bmp = my_compile_bitmap ( bmp );
	r.r = 63;
	r.g = 63;
	r.b = 63;
	my_set_color ( 255, &r );
	free ( bmp );
	mouse_bg = my_create_bitmap ( 16, 16 );
 }

 my_set_mouse_range ( 0, 0, WIDTH - 1, HEIGHT - 1 );

 return 1;

}

void my_remove_mouse ()
{

 if ( !mouse_installed ) return;

 my_remove_int ( mouse_int );
 mouse_close ();

 mouse_installed = 0;

}

void my_position_mouse ( int x, int y )
{

 if ( !mouse_installed ) return;

 mouse_setposition ( x, y );

}

void my_set_mouse_range ( int x1, int y1, int x2, int y2 )
{

 if ( !mouse_installed ) return;

 mouse_setxrange( x1, x2 );
 mouse_setyrange( y1, y2 );

}

void my_set_mouse_speed ( int speed )
{

 if ( !mouse_installed ) return;

 mouse_setscale ( speed );

}

int my_is_mouse_installed ( )
{

 return mouse_installed;

}

void my_show_mouse_pointer ()
{

 mouse_pointer_on = 1;
 mp_x = mouse_x;
 mp_y = mouse_y;
 my_copy_bitmap ( mouse_bg, GRAPHICS, mouse_x - mp_nx, mouse_y - mp_ny, mouse_bmp->w, mouse_bmp->h, 0, 0 );
 my_put_cbitmap ( GRAPHICS, mouse_bmp, mp_x - mp_nx, mp_y - mp_ny );

}

void my_hide_mouse_pointer ()
{
 if ( !mouse_pointer_on  ) return;
 mouse_pointer_on = 0;
 my_put_bitmap ( GRAPHICS, mouse_bg, mp_x-mp_nx, mp_y-mp_ny );
}

void my_set_mouse_pointer ( BITMAP *bmp, int x, int y )
{
 int i;

 i = mouse_pointer_on;

 if ( i ) my_hide_mouse_pointer();

 if ( bmp == NULL ) {
	bmp = my_create_bitmap ( 16, 16 );
	free ( bmp->data );
	bmp->data = mouse_pointer_data;
 }

 if ( mouse_bmp != NULL ) {
	my_destroy_cbitmap ( mouse_bmp );
	my_destroy_bitmap ( mouse_bg );
 }

 mouse_bmp = my_compile_bitmap ( bmp );
 mouse_bg = my_create_bitmap ( bmp->w, bmp->h );
 mp_nx = x;
 mp_ny = y;

 if ( i ) my_show_mouse_pointer ();

}


