
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <vgakeyboard.h>

#include "mylib.h"

#define KEY_BUFFER_SIZE	256

char key_ascii_table[128] =
{
/* 0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F             */
   0,   27,  '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=', 8,   9,       /* 0 */
   'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']', 13,  0,   'a', 's',     /* 1 */
   'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', 39,  '`', 0,   92,  'z', 'x', 'c', 'v',     /* 2 */
   'b', 'n', 'm', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,       /* 3 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   '-', 0,   0,   0,   '+', 0,       /* 4 */
   0,   0,   0,   127, 0,   0,   92,  0,   0,   0,   0,   0,   0,   0,   0,   0,       /* 5 */
   13,  0,   '/', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127,     /* 6 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0        /* 7 */
};

char key_shift_table[128] =
{
/* 0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F             */
   0,   27,  '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', 8,   9,       /* 0 */
   'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '{', '}', 13,  0,   'A', 'S',     /* 1 */
   'D', 'F', 'G', 'H', 'J', 'K', 'L', ':', 34,  '~', 0,   '|', 'Z', 'X', 'C', 'V',     /* 2 */
   'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,       /* 3 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   '-', 0,   0,   0,   '+', 0,       /* 4 */
   0,   0,   0,   127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,       /* 5 */
   13,  0,   '/', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127,     /* 6 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0        /* 7 */
};

char *keynames[128] = {
  "NOT AVAILABLE",
  "ESCAPE",            /*   1 */
  "1",                 /*   2 */
  "2",
  "3",
  "4",
  "5",
  "6",
  "7",
  "8",
  "9",
  "0",                 /*  11 */
  "MINUS",
  "EQUAL",
  "BACKSPACE",         /*  14 */
  "TAB",               /*  15 */
  "Q",                 /*  16 */
  "W",
  "E",
  "R",
  "T",
  "Y",
  "U",
  "I",
  "O",
  "P",                 /*  25 */
  "BRACKET_LEFT",
  "BRACKET_RIGHT",
  "ENTER",             /*  28 */
  "LEFT CONTROL",      /*  29 */
  "A",                 /*  30 */
  "S",
  "D",
  "F",
  "G",
  "H",
  "J",
  "K",
  "L",                 /*  38 */
  "SEMICOLON",
  "APOSTROPHE",
  "GRAVE",
  "LEFT SHIFT",        /*  42 */
  "BACKSLASH",
  "Z",                 /*  44 */
  "X",
  "C",
  "V",
  "B",
  "N",
  "M",                 /*  50 */
  "COMMA",
  "PERIOD",
  "SLASH",
  "RIGHT SHIFT",       /*  54 */
  "KEYPADMULTIPLY",
  "LEFT ALT",          /*  56 */
  "SPACE",             /*  57 */
  "CAPS LOCK",         /*  58 */
  "F1",                /*  59 */
  "F2",
  "F3",
  "F4",
  "F5",
  "F6",
  "F7",
  "F8",
  "F9",
  "F10",               /*  68 */
  "NUM LOCK",          /*  69 */
  "SCROLL LOCK",       /*  70 */
  "KEYPAD HOME",       /*  71 */
  "KEYPAD UP",
  "KEYPAD PGUP",       /*  73 */
  "KEYPAD MINUS",
  "KEYPAD LEFT",       /*  75 */
  "KEYPAD 5",
  "KEYPAD RIGHT",      /*  77 */
  "KEYPAD PLUS",
  "KEYPAD END",        /*  79 */
  "KEYPAD DOWN",
  "KEYPAD PGDN",       /*  81 */
  "KEYPAD 0",          /*  82 */
  "KEYPAD DECIMAL",    /*  83 */
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "F11",               /*  87 */
  "F12",               /*  88 */
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "UNKNOWN",
  "KEYPAD ENTER",      /*  96 */
  "RIGHT CONTROL",     /*  97 */
  "KEYPAD DIVIDE",
  "PRINT SCREEN",      /*  99 */
  "RIGHT ALT",         /* 100 */
  "BREAK",
  "HOME",              /* 102 */
  "CURSOR UP",         /* 103 */
  "PAGE UP",           /* 104 */
  "CURSOR LEFT",       /* 105 */
  "CURSOR RIGHT",      /* 106 */
  "END",               /* 107 */
  "CURSOR DOWN",       /* 108 */
  "PAGE DOWN",         /* 109 */
  "INSERT",            /* 110 */
  "DELETE"             /* 111 */
};

static int keyboard_installed = 0;

static char buffer[KEY_BUFFER_SIZE];
static int buffer_end=0;
static int buffer_start=1;
static int buffer_delay = 0;

char key[128];

void keyboard_int ()
{
char x;

 keyboard_update ();
 memcpy ( key, keyboard_getstate (), 128 );

 if ( buffer_delay != 0 ) buffer_delay --;

 x = my_getkey ();			/* What am I doing? Potato chips? */
 if ( buffer[buffer_end] == x && buffer_delay != 1 ) return;
 if ( x == 0 ) {
	buffer[buffer_end] = 0;
	return;
 }
if ( buffer_delay == 1 ) buffer_delay = 7;
 else buffer_delay = 50;
 buffer[buffer_end] = x;
 buffer_end++;
 if ( buffer_end == KEY_BUFFER_SIZE ) buffer_end = 0;
 buffer[buffer_end] = x;

}


int my_install_keyboard ()
{
 int x;

 if ( keyboard_installed ) return 1;

 memset ( buffer, 0, KEY_BUFFER_SIZE );

 x = keyboard_init();
 if ( x == -1 ) return 0;

 my_clear_keybuff();

 if ( my_install_int ( keyboard_int, 1000 ) < 0 ) {
	keyboard_close ();
	return 0;
 }

 keyboard_installed = 1;

 return 1;

}

void my_remove_keyboard ()
{

 if ( !keyboard_installed ) return;

 my_remove_int ( keyboard_int );
 keyboard_close ();

 keyboard_installed = 0;

}

void my_clear_keypresses ()
{

 if ( !keyboard_installed ) return;

 memset ( key, 0, 128 );

}

void my_set_key ( int k )
{

 if ( !keyboard_installed ) return;

 if ( k < 128 ) key[k] = 1;

}

void my_unset_key ( int k )
{

 if ( !keyboard_installed ) return;

 if ( k < 128 ) key[k] = 0;

}

int my_anypressed ( )
{
 int i;

 if ( !keyboard_installed ) return 0;

 for ( i=0; i<128; i++ ) if ( key[i] ) return 1;

 return 0;

}

int my_getkey ()
{
 int i;

 if ( !keyboard_installed ) return 0;

 for ( i=0; i<128; i++ )
	if (key[i] && key_ascii_table[i]!= 0 && ( isgraph (key_ascii_table[i]) || key_ascii_table[i] == ' ' || iscntrl (key_ascii_table[i]) ) ) break; 

 if ( i == 128 ) return 0;

 if ( key [ KEY_RIGHTCONTROL ] || key [ KEY_LEFTCONTROL ] )
   return key_ascii_table[i] - 'a' + 1;

 if ( key[KEY_RIGHTSHIFT] || key[KEY_LEFTSHIFT] ) return key_shift_table [i];
	else return key_ascii_table[i];

}

int my_is_pressed ( int k )
{

 if ( !keyboard_installed ) return 0;

 if ( key[k] ) return 1;
   else return 0;

}

int my_readkey ()
{
 char x;

 if ( !keyboard_installed ) return 0;

					/* It wont work without this... :) */
 while ( buffer [ buffer_start ] == 0 ) my_donothing();

 x = buffer [ buffer_start ];

 if ( buffer_start == 0 ) buffer[KEY_BUFFER_SIZE-1] = 0;
	else buffer[buffer_start-1] = 0;

 buffer_start ++;
 if ( buffer_start == KEY_BUFFER_SIZE ) buffer_start = 0;

 return x;

}

void my_clear_keybuff ()
{

 memset ( buffer, 0, KEY_BUFFER_SIZE );
 buffer_start = 1;
 buffer_end = 0;
 buffer_delay = 0;

}

int my_keypressed ()
{

 if ( buffer[buffer_start] == 0 ) return 0;
	else return 1;

}

