
#include <vga.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

#include "mylib.h"

static int init_done = 0;

void atexit_f ()
{

 my_remove_keyboard();
 my_remove_mouse();
 my_remove_timer();

 printf("Exiting...\n");

}

void signal_handler ( int s )
{

 fprintf(stderr, "Got signal %d!\n", s);

 exit(0);

}

void my_init ()
{

 if ( init_done ) return;

 vga_init();

 atexit (atexit_f);

 signal ( SIGINT, signal_handler );
 signal ( SIGQUIT, signal_handler );
 signal ( SIGHUP, signal_handler );
 signal ( SIGKILL, signal_handler );
 signal ( SIGSEGV, signal_handler );
 signal ( SIGTERM, signal_handler );

 my_math_init ();

 init_done = 1;

}

