
#include <vga.h>

#include "mylib.h"

void my_setpixel ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

 if ( b->type == BITMAP_MEMORY )
  * ( b->data + y * b->w * b->gfx->BPP + x * b->gfx->BPP ) = c;
 else {
	int vp;
	vp = y * b->w * b->gfx->BPP + x * b->gfx->BPP;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	* ( b->data + vp ) = c;
      }

}

