
#include <vga.h>

#include "mylib.h"

void my_put_cbitmap ( BITMAP *dest, CBITMAP *src, int x, int y )
{
 int cx, cy, cw, ch, i, j, p, u, xx, c, h, t;
 unsigned char *d;

 cx = dest->cx;
 cy = dest->cy;
 cw = dest->cw;
 ch = dest->ch;
 h = src->h;

 while ( dest->mb != NULL ) {
	cx += dest->x;
	cy += dest->y;
	x += dest->x;
	y += dest->y;
	dest = dest->mb;
 }

 d = src->data;

 j = y * dest->w + x;

 if ( y + h >= cy + ch ) h = cy + ch - y;

 if ( dest->type == BITMAP_GR ) {

 p = j >> 16;

 if ( p>=0 ) my_setpage (p);

 j &= 0xffff;

 for ( i=0; i<h; i++ ) {
	xx = x;
	for (;;) {
		u = *d++;
		if ( u == 0xff ) break;
		j += u;
		xx += u;

		u = *d++;

		if ( xx < cx && xx + u > cx ) {
			u -= cx - xx;
			d += cx - xx;
			j += cx - xx;
			xx = cx;
		} else if ( xx + u <= cx ) {
			xx += u;
			d += u;
			j += u;
			continue;
		}

		c = 0;

		if ( j >= 0x10000 ) {
			p++;
			if ( PAGE != p && p>=0) my_setpage ( p );
			j -= 0x10000;
		}
		if ( xx < cx + cw && xx + u >= cx + cw ) {
			c = u - ( ( cx + cw ) - xx );
			u = (cx + cw) - xx;
		} else if ( xx + u >= cx + cw ) {
			xx += u;
			d += u;
			j += u;
			continue;
		}

		if ( i + y < 0 || i+y < cy) {
			xx += u + c;
			d += u + c;
			j += u + c;
			continue;
		}
		if ( j + u >= 0x10000 ) {		/* Page break... */
			int t = 0x10000 - j;
			__memcpy ( dest->data + j, d, t );
			my_setpage ( p+1 );
			__memcpy ( dest->data, d + t, u - t );
		} else {
			__memcpy ( dest->data + j, d, u );
		}
		d += c + u;
		xx += c + u;
		j += c + u;
	}
	j -= xx - x;
	j += dest->w;
 }

} else {
 for ( i=0; i<h; i++ ) {
	t = j;
	xx = x;
	for (;;) {
		u = *d++;
		if ( u == 0xff ) break;
		xx+=u;
		j+=u;

		u = *d++;

		if ( xx < cx && xx + u > cx ) {
			u -= cx - xx;
			d += cx - xx;
			j += cx - xx;
			xx = cx;
		} else if ( xx + u <= cx ) {
			xx += u;
			d += u;
			j += u;
			continue;
		}

		c = 0;

		if ( xx < cx + cw && xx + u >= cx + cw ) {
			c = u - ( ( cx + cw ) - xx );
			u = (cx + cw) - xx;
		} else if ( xx + u >= cx + cw ) {
			xx += u;
			d += u;
			j += u;
			continue;
		}
		if ( i + y < 0 || i+y < cy) {
			xx += u + c;
			d += u + c;
			j += u + c;
			continue;
		}
		__memcpy ( dest->data + j, d, u );
		d += c + u;
		xx += c + u;
		j += c + u;
	}
	j = t + dest->w;
 }
}
}

