
#include <stdlib.h>
#include <string.h>
#include <vga.h>

#include "mylib.h"

POLYG * my_create_polyg ( int c, int *x, int *y)
{
 POLYG *p;

 p = malloc ( sizeof ( POLYG ) );
 p -> x = malloc ( sizeof ( int ) * c );
 p -> y = malloc ( sizeof ( int ) * c );
 p -> c = c;
 if ( x != NULL ) memcpy ( p->x, x, c * sizeof ( int ) );
 if ( y != NULL ) memcpy ( p->y, y, c * sizeof ( int ) );

 return p;

}

void my_destroy_polyg ( POLYG *p )
{
 free ( p->x );
 free ( p->y );
 free ( p );
}

void polyline (int x1, int y1, int x2, int y2, int *s, int *e, int c1, int c2)
{
 int tmp,y;
 long x,m;

 if (y2 != y1)
 {
   if (y2 < y1)
   {
    tmp = y1;
    y1 = y2;
    y2 = tmp;

    tmp = x1;
    x1 = x2;
    x2 = tmp;
   }

 x = (long)x1<<8;

 m = ((long)(x2 - x1)<<8) / ((long)(y2 - y1));
 x += m;
 y1++;
 for (y = y1; y <= y2; y++)
  {
   if ((y >= 0) & (y < c2))
    if (s[y-c1] == -16000)
      s[y-c1] = x>>8;
    else
      e[y-c1] = x>>8;
   x += m;
   } 
 }
}

void my_draw_polyg ( BITMAP *b, POLYG *p, int c )
{
 int *s, *e;
 int y1=16000,y2=0;
 int cc;
 int i;

 for ( i=0; i<p->c; i++ ) {
	if ( y1 > p->y[i] ) y1 = p->y[i];
	if ( y2 < p->y[i] ) y2 = p->y[i];
 } 

 cc = y2 - y1;

 s = malloc ( sizeof ( int ) * ( y2 - y1 ) );
 e = malloc ( sizeof ( int ) * ( y2 - y1 ) );

for ( i=0; i<cc; i++ ) s[i] = -16000;
for ( i=0; i<cc; i++ ) e[i] = -16000;

 for ( i=1; i<p->c; i++ ) {
  polyline ( p->x[i-1], p->y[i-1], p->x[i], p->y[i], s, e, y1, y2 );
 }

polyline ( p->x[0], p->y[0], p->x[i-1], p->y[i-1], s, e, y1, y2 );

  for (i = 0; i < cc; i++)
    if (s[i] != -16000)
    {
     if (e[i] == -16000)
         e[i] = s[i];
if ( s[i]> e[i] ) {
        int tmp;
        tmp = s[i];
        s[i] = e[i];
        e[i] = tmp;
}
       my_hline (b, s[i], i+y1, e[i], c );
    } 

 free ( s );
 free ( e );


}

