
#include <vga.h>
#include <stdlib.h>

#define swap(a,b) { int tmp=a; a=b; b=tmp; }

#include "mylib.h"

static inline int muldiv64(int m1, int m2, int d)
{
/* int32 * int32 -> int64 / int32 -> int32 */
    int result;
    __asm__(
               "imull %%edx\n\t"
               "idivl %3\n\t"
  :            "=a"(result)     /* out */
  :            "a"(m1), "d"(m2), "g"(d)         /* in */
  :            "ax", "dx"       /* mod */
        );
    return result;
}

#define INC_IF_NEG(y, result)				\
{							\
	__asm__("btl $31,%1\n\t"			\
		"adcl $0,%0"				\
		: "=r" ((int) result)			\
		: "rm" ((int) (y)), "0" ((int) result)	\
		);					\
}

static inline int my_regioncode( int cx, int cy, int cw, int ch, int x, int y)
{
    int dx1, dx2, dy1, dy2;
    int result;
    result = 0;
    dy2 = (cy + ch) - y;
    INC_IF_NEG(dy2, result);
    result <<= 1;
    dy1 = y - cy;
    INC_IF_NEG(dy1, result);
    result <<= 1;
    dx2 = (cx + cw) - x;
    INC_IF_NEG(dx2, result);
    result <<= 1;
    dx1 = x - cx;
    INC_IF_NEG(dx1, result);
    return result;
}

void my_line( BITMAP *b, int x1, int y1, int x2, int y2, int c)
{
    int dx, dy, ax, ay, sx, sy, x, y, cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw-1;
 ch = b->ch-1;

 while ( b->mb != NULL ) {
	x1 += b->x;
	x2 += b->x;
	cx += b->x;
	y1 += b->y;
	y2 += b->y;
	cy += b->y;
	b = b->mb;
 }

	/* Cohen & Sutherland algorithm */
	for (;;) {
	    int r1 = my_regioncode(cx, cy, cw, ch, x1, y1);
	    int r2 = my_regioncode(cx, cy, cw, ch, x2, y2);
	    if (!(r1 | r2))
		break;		/* completely inside */
	    if (r1 & r2)
		return;		/* completely outside */
	    if (r1 == 0) {
		swap(x1, x2);	/* make sure first */
		swap(y1, y2);	/* point is outside */
		r1 = r2;
	    }
	    if (r1 & 1) {	/* left */
		y1 += muldiv64(cx - x1, y2 - y1, x2 - x1);
		x1 = cx;
	    } else if (r1 & 2) {	/* right */
		y1 += muldiv64((cx + cw ) - x1, y2 - y1, x2 - x1);
		x1 = cx + cw;
	    } else if (r1 & 4) {	/* top */
		x1 += muldiv64(cy - y1, x2 - x1, y2 - y1);
		y1 = cy;
	    } else if (r1 & 8) {	/* bottom */
		x1 += muldiv64((cy+ch) - y1, x2 - x1, y2 - y1);
		y1 = cy + ch;
	    }
	}
    dx = x2 - x1;
    dy = y2 - y1;
    ax = abs(dx) << 1;
    ay = abs(dy) << 1;
    sx = (dx >= 0) ? 1 : -1;
    sy = (dy >= 0) ? 1 : -1;
    x = x1;
    y = y1;

    if (ax > ay) {
	int d = ay - (ax >> 1);
	while (x != x2) {
	    _my_setpixel(b, x, y, c);

	    if (d > 0 || (d == 0 && sx == 1)) {
		y += sy;
		d -= ax;
	    }
	    x += sx;
	    d += ay;
	}
    } else {
	int sy = (dy >= 0) ? 1 : -1;
	int d = ax - (ay >> 1);
	while (y != y2) {
	    _my_setpixel(b, x, y, c);

	    if (d > 0 || (d == 0 && sy == 1)) {
		x += sx;
		d -= ay;
	    }
	    y += sy;
	    d += ax;
	}
    }
    _my_setpixel(b, x, y, c);
}

