
#include <vga.h>

#include "mylib.h"

void my_fillbox ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	cx += b->x;
	cy += b->y;
	b = b->mb;
 }

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 if ( b->type == BITMAP_MEMORY ) {
                int i;
                unsigned char *vb = b->data;
                vb += y*b->w + x;
                for ( i=0; i<h; i++ ) {
                	__memset ( vb, c, w );
                	vb+=b->w;
		}
 } else
    if ( FILLBOXACCEL ) {
	vga_accel ( ACCEL_SETFGCOLOR, c );
	vga_accel ( ACCEL_FILLBOX, x, y, w, h );
	vga_accel ( ACCEL_SYNC );
    }
    else {
    int vp;
    int page;
    int i;
    vp = y * b->w + x;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    for (i = 0; i < h; i++) {
        if (vp + w > 0x10000)
            if (vp >= 0x10000) {
                page++;
                my_setpage(page);
                vp &= 0xffff;
            } else {            /* page break within line */
                __memset(b->data + vp, c, 0x10000 - vp);
                page++;
                my_setpage(page);
                __memset(b->data, c, (vp + w) & 0xffff);
                vp = (vp + b->w) & 0xffff;
                continue;
            }
        __memset(b->data + vp, c, w);
        vp += b->w;
    }
 }

}

