
#include <vga.h>

#include "mylib.h"

void my_copy_bitmap ( BITMAP *dest, BITMAP *src, int x1, int y1, int w, int h, int x2, int y2 )
{
 int cx, cy, cw, ch;
 int dx, dy, dw, dh;

 dx = dest->cx;
 dy = dest->cy;
 dw = dest->cw;
 dh = dest->ch;

 cx = src->cx;
 cy = src->cy;
 cw = src->cw;
 ch = src->ch;

 while ( dest->mb != NULL ) {
	x2 += dest->x;
	y2 += dest->y;
	dx += dest->x;
	dy += dest->y;
	dest = dest->mb;
 }

 while ( src->mb != NULL ) {
	cx += src->x;
	cy += src->y;
	x1 += src->x;
	y1 += src->y;
	src = src->mb;
 }

 if ( x1 < cx ) { w = w - (cx - x1); x2+=cx-x1; x1 = cx; }
 if ( y1 < cy ) { h = h - (cy - y1); y2+=cy-y1; y1 = cy; }
 if ( x1 + w > cx + cw ) w = cx + cw - x1;
 if ( y1 + h > cy + ch ) h = cy + ch - y1;

 if ( x2 < dx ) { w = w - (dx - x2); x1+=dx-x2; x2 = dx; }
 if ( y2 < dy ) { h = h - (dy - y2); y1+=dy-y2; y2 = dy; }
 if ( x2 + w > dx + dw ) w = dx + dw - x2;
 if ( y2 + h > dy + dh ) h = dy + dh - y2;

 if ( x1 >= cx + cw ) return;
 if ( y1 >= cy + ch ) return;
 if ( x1 + w <= cx ) return;
 if ( y1 + h <= cy ) return;

 if ( x2 >= dx + dw ) return;
 if ( y2 >= dy + dh ) return;
 if ( x2 + w <= dx ) return;
 if ( y2 + h <= dy ) return;
 if ( src->type == BITMAP_MEMORY && dest->type == BITMAP_MEMORY ) {
	int vp1, vp2, i;
	vp1 = y1 * src->w + x1;
	vp2 = y2 * dest->w + x2;
	for ( i=0; i<h; i++ ) {
		__memcpy ( dest->data + vp2, src->data + vp1, w );
		vp1 += src->w;
		vp2 += dest->w;
	}
 } else 
 if ( src->type == BITMAP_MEMORY && dest->type == BITMAP_GR ) {
    int vp,w1,w2;
    int page;
    char *bp = src->data+src->w * y1 + x1;
    int i;
    vp = dest->w * y2 + x2;
    page = vp >> 16;
    vp &= 0xffff;
    w1 = src->w;
    w2 = dest->w;
    my_setpage(page);
    for (i = 0; i < h; i++) {
	if (vp + w > 0x10000)
	    if (vp >= 0x10000) {
		page++;
		my_setpage(page);
		vp &= 0xffff;
	    } else {		/* page break within line */
		__memcpy(dest->data + vp, bp, 0x10000 - vp);
		page++;
		my_setpage(page);
		__memcpy(dest->data, bp + 0x10000 - vp,
			 (vp + w) & 0xffff);
		vp = (vp + w2) & 0xffff;
		bp += w1;
		continue;
	    }
	__memcpy(dest->data + vp, bp, w);
	bp += w1;
	vp += w2;
    }
 } else
 if ( src->type == BITMAP_GR && dest->type == BITMAP_MEMORY ) {
    int vp;
    int page;
    char *bp = dest->data + y2 * dest->w + x2;
    int i;
    vp = y1 * src->w + x1;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    for (i = 0; i < h; i++) {
	if (vp + w > 0x10000)
	    if (vp >= 0x10000) {
		page++;
		my_setpage(page);
		vp &= 0xffff;
	    } else {		/* page break within line */
		__memcpy(bp, src->data + vp, 0x10000 - vp);
		page++;
		my_setpage(page);
		__memcpy(bp + 0x10000 - vp, src->data,
			 (vp + w) & 0xffff);
		vp = (vp + src->w) & 0xffff;
		bp += dest->w;
		continue;
	    }
	__memcpy(bp, src->data + vp, w);
	bp += dest->w;
	vp += src->w;
    }
 } else
 if ( src->type == BITMAP_GR && dest->type == BITMAP_GR ) {
	BITMAP *v;
	if ( COPYSCREENACCEL ) {
		vga_accel ( ACCEL_SCREENCOPY, x1, y1, w, h, x2, y2 );
		return;
	}				/* Sorry, I hope it's temoporarly so */
	v = my_create_bitmap (w, h); 
	my_copy_bitmap ( v, src, x1, y1, w, h, 0, 0 );
	my_copy_bitmap ( dest, v, 0, 0, w, h, x2, y2 );
	my_destroy_bitmap ( v );
 }
}

