
#include <vga.h>
#include <stdlib.h>

#include "mylib.h"

CBITMAP * my_compile_bitmap ( BITMAP *b )
{
 CBITMAP *n;
 BITMAP *u=NULL;
 int w,h;
 int l;

 w = b->w;
 h = b->h;

 if ( b->type != BITMAP_MEMORY ) {
	u = my_create_bitmap ( w, h );
	my_put_bitmap ( u, b, 0, 0 );
	b = u;
 }

 n = malloc ( sizeof ( CBITMAP ) );
n->w = b->w;
n->h = b->h;
 l = my_cbitmap_size ( b );
 n->data = malloc ( l );
 n->size = l;

{
    unsigned char *dp1 = b->data;
    unsigned char *dp2 = n->data;
    int i;
    for (i = 0; i < h; i++) {
	int x = 0;
	while (x < w) {
	    int count;
	    /* count zeroes */
	    count = 0;
	    while (x < w && *(dp1 + count) == 0 && count < 254) {
		count++;
		x++;
	    }
	    dp1 += count;
	    if (x < w) {
		*dp2++ = count;
		/* count nonzeroes */
		count = 0;
		while (x < w && *(dp1 + count) != 0 && count < 255) {
		    *(dp2 + count + 1) = *(dp1 + count);
		    count++;
		    x++;
		}
		*dp2 = count;
		dp2 += count + 1;
		dp1 += count;
	    }
	}
	*dp2++ = 0xff;
    }
}

 if ( u != NULL ) my_destroy_bitmap ( u );

 return n;

}

