
#include <vga.h>

#include "mylib.h"

int my_cbitmap_size ( BITMAP *b )
{
    unsigned char *dp1 = b->data;
    int size = 0;
    BITMAP *u=NULL;
    int i;
    int w,h;
    w = b->w;
    h = b->h;

    if ( b->type != BITMAP_MEMORY ) {
	u = my_create_bitmap ( w, h );
	my_put_bitmap ( u, b, w, h );
	b = u;
    }

    for (i = 0; i < h; i++) {
	int x = 0;
	while (x < w) {
	    int count;
	    /* count zeroes */
	    count = 0;
	    while (x < w && *(dp1 + count) == 0 && count < 254) {
		count++;
		x++;
	    }
	    size++;
	    dp1 += count;
	    /* count nonzeroes */
	    if (x < w) {
		count = 0;
		while (x < w && *(dp1 + count) != 0 && count < 255) {
		    count++;
		    x++;
		}
		size += count + 1;
		dp1 += count;
	    }
	}
	size++;
    }

    if ( u != NULL ) my_destroy_bitmap ( u );
    return size;
}

