
#include <vga.h>
#include <stdio.h>
#include <stdlib.h>

#include "mylib.h"
#include "driver.h"

 extern vga_modeinfo *xx;
 vga_modeinfo *xx;

BITMAP *SCREEN;
BITMAP *GRAPHICS;

int WIDTH;
int HEIGHT;
int VWIDTH;
int VHEIGHT;
int PAGE = 0;
int FILLBOXACCEL=0;
int DRAWING = 0;
int COPYSCREENACCEL=0;

static int first = 1;

int my_set_gfx_mode ( int driver, int w, int h, int lw, char *bpp )
{
 int accelfuncs;
 char M[256];
 int i;
 int mem;

 my_init ();

 if ( driver == TEXT_MODE ) {
	vga_setmode ( TEXT );
	return 1;
 }

 sprintf ( M, "G%dx%dx%s", w, h, bpp );
 i = vga_getmodenumber ( M );

 if ( !vga_hasmode ( i ) ) return 0;

 if ( vga_getmodeinfo(i)->maxlogicalwidth < lw ) return 0;
 vga_setmode (i);
 if ( vga_getmodeinfo (i) -> maxlogicalwidth < lw ) {
	vga_setmode (0);
	return 0;
 }

/* printf("MLW: %d\n", vga_getmodeinfo(i)->maxlogicalwidth ); */

 if ( lw != 0 ) vga_setlogicalwidth ( lw*vga_getmodeinfo(i)->bytesperpixel );

 vga_setpage (0);
 PAGE = 0;

 if ( first ) {
	GRAPHICS = malloc ( sizeof ( struct BITMAP ) );
	GRAPHICS->gfx = malloc ( sizeof ( my_gfx_driver ) );
 }
 else free ( SCREEN );
 first = 0;

 GRAPHICS->gfx->BPP = vga_getmodeinfo(i)->bytesperpixel;
if ( lw == 0 )
 GRAPHICS->w = vga_getmodeinfo(i)->linewidth/GRAPHICS->gfx->BPP;
else GRAPHICS->w = lw;

/* printf("LW: %d\n", vga_getmodeinfo(i)->linewidth ); */

    if (vga_getmodeinfo( i ) ->flags & EXT_INFO_AVAILABLE)
        mem = vga_getmodeinfo ( i ) -> memory * 1000;
    else
        mem = (vga_getmodeinfo( i )->bytesperpixel * vga_getmodeinfo( i )->maxpixels
                  + 0xFFF) & 0xFFFFF000; 

 GRAPHICS->h = (mem/GRAPHICS->w)/GRAPHICS->gfx->BPP;
 GRAPHICS->cx = 0;
 GRAPHICS->cy = 0;
 GRAPHICS->cw = GRAPHICS->w;
 GRAPHICS->ch = GRAPHICS->h;
 GRAPHICS->type = BITMAP_GR;
 GRAPHICS->mb = NULL;
 GRAPHICS->data = graph_mem;

 WIDTH = w;
 HEIGHT = h;
 VWIDTH = GRAPHICS->w;
 VHEIGHT = GRAPHICS->h;

 SCREEN = my_create_sub_bitmap ( GRAPHICS, 0, 0, WIDTH, HEIGHT );

 accelfuncs = vga_ext_set(VGA_EXT_AVAILABLE, VGA_AVAIL_ACCEL);
 if (accelfuncs & ACCELFLAG_FILLBOX) FILLBOXACCEL = 1;
 if (accelfuncs & ACCELFLAG_SCREENCOPY) COPYSCREENACCEL = 1;

 switch ( GRAPHICS->gfx->BPP ) {
	case 1:
		if ( vga_getmodeinfo (i)->flags & (1<<5) ) {
			GRAPHICS->gfx->_setpixel = _setpixel_1bpp_l;
			GRAPHICS->gfx->setpixel = setpixel_1bpp_l;
			GRAPHICS->gfx->getpixel = getpixel_1bpp_l;
			GRAPHICS->gfx->hline = hline_1bpp_l;
			GRAPHICS->gfx->fillbox = fillbox_1bpp_l;
		} else {
			GRAPHICS->gfx->_setpixel = _setpixel_1bpp_p;
			GRAPHICS->gfx->setpixel = setpixel_1bpp_p;
			GRAPHICS->gfx->getpixel = getpixel_1bpp_p;
			GRAPHICS->gfx->hline = hline_1bpp_p;
			GRAPHICS->gfx->fillbox = fillbox_1bpp_p;
		}
		break;
	case 2:
		if ( vga_getmodeinfo (i)->flags & (1<<5) ) {
			GRAPHICS->gfx->_setpixel = _setpixel_2bpp_l;
			GRAPHICS->gfx->setpixel = setpixel_2bpp_l;
			GRAPHICS->gfx->getpixel = getpixel_2bpp_l;
			GRAPHICS->gfx->hline = hline_2bpp_l;
			GRAPHICS->gfx->fillbox = fillbox_2bpp_l;
		} else {
			GRAPHICS->gfx->_setpixel = _setpixel_2bpp_p;
			GRAPHICS->gfx->setpixel = setpixel_2bpp_p;
			GRAPHICS->gfx->getpixel = getpixel_2bpp_p;
			GRAPHICS->gfx->hline = hline_2bpp_p;
			GRAPHICS->gfx->fillbox = fillbox_2bpp_p;
		}
		break;
	case 3:
		if ( vga_getmodeinfo (i)->flags & (1<<5) ) {
			GRAPHICS->gfx->_setpixel = _setpixel_3bpp_l;
			GRAPHICS->gfx->setpixel = setpixel_3bpp_l;
			GRAPHICS->gfx->getpixel = getpixel_3bpp_l;
			GRAPHICS->gfx->hline = hline_3bpp_l;
			GRAPHICS->gfx->fillbox = fillbox_3bpp_l;
		} else {
			GRAPHICS->gfx->_setpixel = _setpixel_3bpp_p;
			GRAPHICS->gfx->setpixel = setpixel_3bpp_p;
			GRAPHICS->gfx->getpixel = getpixel_3bpp_p;
			GRAPHICS->gfx->hline = hline_3bpp_p;
			GRAPHICS->gfx->fillbox = fillbox_3bpp_p;
		}
		break;
	case 4:
		if ( vga_getmodeinfo (i)->flags & (1<<5) ) {
			GRAPHICS->gfx->_setpixel = _setpixel_4bpp_l;
			GRAPHICS->gfx->setpixel = setpixel_4bpp_l;
			GRAPHICS->gfx->getpixel = getpixel_4bpp_l;
			GRAPHICS->gfx->hline = hline_4bpp_l;
			GRAPHICS->gfx->fillbox = fillbox_4bpp_l;
		} else {
			GRAPHICS->gfx->_setpixel = _setpixel_4bpp_p;
			GRAPHICS->gfx->setpixel = setpixel_4bpp_p;
			GRAPHICS->gfx->getpixel = getpixel_4bpp_p;
			GRAPHICS->gfx->hline = hline_4bpp_p;
			GRAPHICS->gfx->fillbox = fillbox_4bpp_p;
		}
		break;
	default:
		printf ("Not implemented for mode %d!\n", GRAPHICS->gfx->BPP);
		break;
 }

	if ( FILLBOXACCEL ) {
/*			For short lines accel is slow :( */
/*		GRAPHICS->gfx->hline = hline_a; */
		GRAPHICS->gfx->fillbox = fillbox_a;
	}
 return 1;
	
}

BITMAP * my_create_bitmap ( int w, int h )
{
 BITMAP *new;

 new = malloc ( sizeof ( BITMAP ) );

 new->w = w;
 new->h = h;
 new->cx = 0;
 new->cy = 0;
 new->cw = w;
 new->ch = h;
 new->mb = NULL;
 new->type = BITMAP_MEMORY;

 new->gfx = malloc ( sizeof ( my_gfx_driver ) );
 new->gfx->setpixel = setpixel_1bpp_l;
 new->gfx->getpixel = getpixel_1bpp_l;
 new->gfx->hline = hline_1bpp_l;
 new->gfx->fillbox = fillbox_1bpp_l;
 new->gfx->BPP = 1;

 new->data = calloc ( 1, w * h );

 return new;

}

void my_destroy_bitmap ( BITMAP *b )
{

 if ( b->data != NULL ) { free ( b->data );
			  free ( b->gfx );
			}
 free ( b );

}

void my_destroy_cbitmap ( CBITMAP *b )
{

 if ( b->data != NULL ) free ( b->data );
 free ( b );

}

int my_setlinearaddressing ()
{

 if ( vga_setlinearaddressing () == -1 ) return 0;
 GRAPHICS->data = vga_getgraphmem ();
 GRAPHICS->type = BITMAP_MEMORY;

 return 1;
 
}

BITMAP * my_create_sub_bitmap ( BITMAP *b, int x, int y, int w, int h )
{
 BITMAP *mm;

 mm = malloc ( sizeof ( BITMAP ) );
 mm->x = x;
 mm->y = y;
 mm->data = NULL;
 mm->mb = b;
 mm->w = w;
 mm->h = h;
 mm->cx = 0;
 mm->cy = 0;
 mm->cw = w;
 mm->ch = h;
 mm->type = BITMAP_SUB; 
 mm->gfx = b->gfx;

 return mm;

}

void my_set_bitmap_cliping ( BITMAP *b, int x, int y, int w, int h )
{

 b->cx = x;
 b->cy = y;
 b->cw = w;
 b->ch = h;

}

void my_scroll_screen ( int x, int y )
{

 vga_setdisplaystart ( VWIDTH * y * GRAPHICS->gfx->BPP + x*GRAPHICS->gfx->BPP );
 SCREEN->x = x;
 SCREEN->y = y;

}

void my_text_mode ()
{

 vga_setmode (TEXT );
 GRAPHICS->gfx->BPP = 0;
 GRAPHICS->w = 0;
 GRAPHICS->h = 0;

}

