
#include <vga.h>

#include "mylib.h"
#include "driver.h"

void setpixel_3bpp_p ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  char *vbuf;
  int page;
  int vp, vpo;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

    c = RGB2BGR(c);
    vp = y * b->w * 3 + x * 3;
    vbuf = b->data;
    page = vp >> 16;
    my_setpage(page);
    vpo = vp & 0xffff;
    if (vpo <= 0xfffd) {
        *(unsigned short *) (vbuf + vpo) = c;
        *(unsigned char *) (vbuf + vpo + 2) = c >> 16;
    } else if (vpo == 0xfffe) {
        *(unsigned short *) (vbuf + 0xfffe) = c;
        my_setpage(page + 1);
        *(unsigned char *) vbuf = c >> 16;
    } else {                    /* vpo == 0xffff */
        *(unsigned char *) (vbuf + 0xffff) = c;
        my_setpage(page + 1);
        *(unsigned short *) vbuf = c >> 8;
    }

}

