
int getpixel_1bpp_l ( BITMAP *b, int x, int y )
{

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

  return * ( b->data + y * b->w + x );

}

int getpixel_1bpp_p ( BITMAP *b, int x, int y )
{
 int vp;

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

	vp = y * b->w + x;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	return * ( b->data + vp );

}

int getpixel_2bpp_l ( BITMAP *b, int x, int y )
{

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

  return *(unsigned short*)( b->data + y * b->w * 2 + x * 2 );

}

int getpixel_2bpp_p ( BITMAP *b, int x, int y )
{
 int vp;

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

	vp = y * b->w * 2 + x * 2;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	return *(unsigned short *)( b->data + vp );

}

int getpixel_3bpp_l ( BITMAP *b, int x, int y )
{
 char *vp;

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

 vp = b->data + b->w * y * 3 + x * 3;
 return RGB2BGR (*(unsigned short*)vp+(*(unsigned char *)(vp+2)<<16));

}

int getpixel_3bpp_p ( BITMAP *b, int x, int y )
{
 int vp, vpo;
 char *vbuf;
 int page;

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

	vp = y * b->w * 3 + x * 3;
	vbuf = b->data;
    page = vp >> 16;
    my_setpage(page);
    vpo = vp & 0xffff;
    if (vpo <= 0xfffd)
        return RGB2BGR(*(unsigned short *) (vbuf + vpo) +
                       (*(unsigned char *) (vbuf + vpo + 2) << 16));
    else if (vpo == 0xfffe) {
        int c;
        c = *(unsigned short *) (vbuf + 0xfffe);
        my_setpage(page + 1);
        return RGB2BGR((*(unsigned char *) vbuf << 16) + c);
    } else {                    /* vpo == 0xffff */
        int c;
        c = *(unsigned char *) (vbuf + 0xffff);
        my_setpage(page + 1);
        return RGB2BGR((*(unsigned short *) vbuf << 8) + c);
    }

}

int getpixel_4bpp_l ( BITMAP *b, int x, int y )
{

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

  return *(unsigned int *)( b->data + y * b->w * 4 + x * 4 );

}

int getpixel_4bpp_p ( BITMAP *b, int x, int y )
{
 int vp;

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

	vp = y * b->w * 4 + x * 4;
	my_setpage ( vp>>16 );
	return *(unsigned int *)( b->data + (vp&0xffff) );

}

void setpixel_1bpp_l ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

  * ( b->data + y * b->w + x ) = c;

}

void setpixel_1bpp_p ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  int vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

	vp = y * b->w + x;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	* ( b->data + vp ) = c;
}

void setpixel_2bpp_l ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

  * ( unsigned short *) ( b->data + y * b->w * 2 + x*2 ) = c;

}

void setpixel_2bpp_p ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  int vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

	vp = y * b->w*2 + x*2;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	* (unsigned short *) (b->data + vp ) = c;
}

void setpixel_3bpp_l ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  unsigned char *vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

  c = RGB2BGR ( c );
  vp = b->data + y * b->w * 3 + x * 3;
  *(unsigned short *) vp = c;
  *(unsigned char *)(vp+2) = c>>16;

}

void setpixel_3bpp_p ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  char *vbuf;
  int page;
  int vp, vpo;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

    c = RGB2BGR(c);
    vp = y * b->w * 3 + x * 3;
    vbuf = b->data;
    page = vp >> 16;
    my_setpage(page);
    vpo = vp & 0xffff;
    if (vpo <= 0xfffd) {
        *(unsigned short *) (vbuf + vpo) = c;
        *(unsigned char *) (vbuf + vpo + 2) = c >> 16;
    } else if (vpo == 0xfffe) {
        *(unsigned short *) (vbuf + 0xfffe) = c;
        my_setpage(page + 1);
        *(unsigned char *) vbuf = c >> 16;
    } else {                    /* vpo == 0xffff */
        *(unsigned char *) (vbuf + 0xffff) = c;
        my_setpage(page + 1);
        *(unsigned short *) vbuf = c >> 8;
    }

}

void setpixel_4bpp_l ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  char *vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

 vp = b->data + y * b->w * 4 + x * 4;
 * ( unsigned int *) vp = c;

}

void setpixel_4bpp_p ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  int vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

	vp = y * b->w*4 + x*4;
	my_setpage ( vp>>16 );
	* (unsigned int *) (b->data + (vp & 0xffff) ) = c;
}

void _setpixel_1bpp_l ( BITMAP *b, int x, int y, int c )
{

  * ( b->data + y * b->w + x ) = c;

}

void _setpixel_1bpp_p ( BITMAP *b, int x, int y, int c )
{
  int vp;

	vp = y * b->w + x;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	* ( b->data + vp ) = c;
}

void _setpixel_2bpp_l ( BITMAP *b, int x, int y, int c )
{

  * ( unsigned short *) ( b->data + y * b->w * 2 + x*2 ) = c;

}

void _setpixel_2bpp_p ( BITMAP *b, int x, int y, int c )
{
  int vp;

	vp = y * b->w*2 + x*2;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	* (unsigned short *) (b->data + vp ) = c;
}

void _setpixel_3bpp_l ( BITMAP *b, int x, int y, int c )
{
  unsigned char *vp;

  c = RGB2BGR ( c );
  vp = b->data + y * b->w * 3 + x * 3;
  *(unsigned short *) vp = c;
  *(unsigned char *)(vp+2) = c>>16;

}

void _setpixel_3bpp_p ( BITMAP *b, int x, int y, int c )
{
  char *vbuf;
  int page;
  int vp, vpo;

    c = RGB2BGR(c);
    vp = y * b->w * 3 + x * 3;
    vbuf = b->data;
    page = vp >> 16;
    my_setpage(page);
    vpo = vp & 0xffff;
    if (vpo <= 0xfffd) {
        *(unsigned short *) (vbuf + vpo) = c;
        *(unsigned char *) (vbuf + vpo + 2) = c >> 16;
    } else if (vpo == 0xfffe) {
        *(unsigned short *) (vbuf + 0xfffe) = c;
        my_setpage(page + 1);
        *(unsigned char *) vbuf = c >> 16;
    } else {                    /* vpo == 0xffff */
        *(unsigned char *) (vbuf + 0xffff) = c;
        my_setpage(page + 1);
        *(unsigned short *) vbuf = c >> 8;
    }

}

void _setpixel_4bpp_l ( BITMAP *b, int x, int y, int c )
{
  char *vp;

 vp = b->data + y * b->w * 4 + x * 4;
 * ( unsigned int *) vp = c;

}

void _setpixel_4bpp_p ( BITMAP *b, int x, int y, int c )
{
  int vp;

	vp = y * b->w*4 + x*4;
	my_setpage ( vp>>16 );
	* (unsigned int *) (b->data + (vp & 0xffff) ) = c;
}


