
#include <vga.h>

#include "mylib.h"
#include "driver.h"

int getpixel_3bpp_p ( BITMAP *b, int x, int y )
{
 int vp, vpo;
 char *vbuf;
 int page;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

	vp = y * b->w * 3 + x * 3;
	vbuf = b->data;
    page = vp >> 16;
    my_setpage(page);
    vpo = vp & 0xffff;
    if (vpo <= 0xfffd)
        return RGB2BGR(*(unsigned short *) (vbuf + vpo) +
                       (*(unsigned char *) (vbuf + vpo + 2) << 16));
    else if (vpo == 0xfffe) {
        int c;
        c = *(unsigned short *) (vbuf + 0xfffe);
        my_setpage(page + 1);
        return RGB2BGR((*(unsigned char *) vbuf << 16) + c);
    } else {                    /* vpo == 0xffff */
        int c;
        c = *(unsigned char *) (vbuf + 0xffff);
        my_setpage(page + 1);
        return RGB2BGR((*(unsigned short *) vbuf << 8) + c);
    }

}

