
#include <vga.h>

#include "mylib.h"
#include "driver.h"

#define SETWRITEPAGED(vp, rvp, chunksize, page, b) \
        page = vp >> 16; \
        my_setpage(page); \
        rvp = (vp & 0xffff) + b->data; \
        chunksize = 0x10000 - (vp & 0xffff);

void hline_4bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

{
    int vp;
    char *rvp;
    int l;
    int chunksize, page;
    vp = x1 * 4 + y * b->w * 4;
    SETWRITEPAGED(vp, rvp, chunksize, page, b);
    l = (x2 - x1 + 1) * 4;
    if (l <= chunksize)
        __memsetlong(rvp, c, l / 4);
    else {
        __memsetlong(rvp, c, chunksize / 4);
        my_setpage(page + 1);
        __memsetlong(b->data, c, (l - chunksize) / 4);
    }
}

}

