
#include <vga.h>

#include "mylib.h"
#include "driver.h"

#define SETWRITEPAGED(vp, rvp, chunksize, page, b) \
        page = vp >> 16; \
        my_setpage(page); \
        rvp = (vp & 0xffff) + b->data; \
        chunksize = 0x10000 - (vp & 0xffff);

void hline_3bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

{
    int vp;
    char *rvp;
    int l;
    int chunksize, page;
    c = RGB2BGR(c);
    vp = x1 * 3 + y * b->w * 3;
    SETWRITEPAGED(vp, rvp, chunksize, page, b);
    l = (x2 - x1 + 1) * 3;
    if (l <= chunksize)
        __memset3(rvp, c, l / 3);
    else {
        int n, m, o;
        n = chunksize / 3;
        m = chunksize % 3;
        __memset3(rvp, c, n);
        /* Handle page break within pixel. */
        if (m >= 1)
            *(rvp + n * 3) = c;
        if (m == 2)
            *(rvp + n * 3 + 1) = c >> 8;
        my_setpage(page + 1);
        o = 0;
        if (m == 2) {
            *(b->data) = c >> 16;
            o = 1;
        }
        if (m == 1) {
            *(unsigned short *) (b->data) = c >> 8;
            o = 2;
        }
        __memset3(b->data + o, c, (l - chunksize) / 3);
    }
}

}

