
#include <vga.h>

#include "mylib.h"
#include "driver.h"

#define SETWRITEPAGED(vp, rvp, chunksize, page, b) \
        page = vp >> 16; \
        my_setpage(page); \
        rvp = (vp & 0xffff) + b->data; \
        chunksize = 0x10000 - (vp & 0xffff);

void hline_2bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

{
    int vp;
    char *rvp;
    int l;
    int chunksize, page;
    vp = b->w * y * 2 + x1 * 2;
    SETWRITEPAGED(vp, rvp, chunksize, page, b);
    l = (x2 - x1 + 1) * 2;
    if (l <= chunksize)
        __memset2(rvp, c, l / 2);
    else {
        __memset2(rvp, c, chunksize / 2);
        my_setpage(page + 1);
        __memset2(b->data, c, (l - chunksize) / 2);
    }
}

}

