

void hline_1bpp_l (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

	__memset(b->data + y * b->w + x1 , c, x2 - x1 + 1);

}

void hline_1bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

   {
    int vp, p;
    int l;
    vp = y * b->w + x1;
    l = x2 - x1 + 1;
    p = vp>>16;
    my_setpage ( p );
    vp &= 0xffff;
    if ( vp + l > 0x10000 ) {
        __memset ( b->data + vp, c, 0x10000 - vp );
        my_setpage ( p+1 );
        __memset ( b->data, c, l - ( 0x10000 - vp ));
    }
    else
    __memset ( b->data + vp, c, l );
   }

}

void hline_2bpp_l (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;
 char *vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

    vp = b->data + y * b->w * 2 + x1 * 2;
    __memset2 ( vp, c, x2 - x1 + 1 );

}

#define SETWRITEPAGED(vp, rvp, chunksize, page, b) \
        page = vp >> 16; \
        my_setpage(page); \
        rvp = (vp & 0xffff) + b->data; \
        chunksize = 0x10000 - (vp & 0xffff);

void hline_2bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

{
    int vp;
    char *rvp;
    int l;
    int chunksize, page;
    vp = b->w * y * 2 + x1 * 2;
    SETWRITEPAGED(vp, rvp, chunksize, page, b);
    l = (x2 - x1 + 1) * 2;
    if (l <= chunksize)
        __memset2(rvp, c, l / 2);
    else {
        __memset2(rvp, c, chunksize / 2);
        my_setpage(page + 1);
        __memset2(b->data, c, (l - chunksize) / 2);
    }
}

}

void hline_3bpp_l (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;
 char *vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

    c = RGB2BGR(c);
    vp = b->data + b->w * y * 3 + x1 * 3;
    if (RGBEQUAL(c))
        __memset(vp, c, (x2 - x1 + 1) * 3);
    else
        __memset3(vp, c, x2 - x1 + 1);

}

void hline_3bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

{
    int vp;
    char *rvp;
    int l;
    int chunksize, page;
    c = RGB2BGR(c);
    vp = x1 * 3 + y * b->w * 3;
    SETWRITEPAGED(vp, rvp, chunksize, page, b);
    l = (x2 - x1 + 1) * 3;
    if (l <= chunksize)
        __memset3(rvp, c, l / 3);
    else {
        int n, m, o;
        n = chunksize / 3;
        m = chunksize % 3;
        __memset3(rvp, c, n);
        /* Handle page break within pixel. */
        if (m >= 1)
            *(rvp + n * 3) = c;
        if (m == 2)
            *(rvp + n * 3 + 1) = c >> 8;
        my_setpage(page + 1);
        o = 0;
        if (m == 2) {
            *(b->data) = c >> 16;
            o = 1;
        }
        if (m == 1) {
            *(unsigned short *) (b->data) = c >> 8;
            o = 2;
        }
        __memset3(b->data + o, c, (l - chunksize) / 3);
    }
}

}

void hline_4bpp_l (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;
 char *vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

    vp = b->data + y * b->w * 4 + x1 * 4;
    __memsetlong ( vp, c, x2 - x1 + 1 );

}

void hline_4bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

{
    int vp;
    char *rvp;
    int l;
    int chunksize, page;
    vp = x1 * 4 + y * b->w * 4;
    SETWRITEPAGED(vp, rvp, chunksize, page, b);
    l = (x2 - x1 + 1) * 4;
    if (l <= chunksize)
        __memsetlong(rvp, c, l / 4);
    else {
        __memsetlong(rvp, c, chunksize / 4);
        my_setpage(page + 1);
        __memsetlong(b->data, c, (l - chunksize) / 4);
    }
}

}

void hline_a (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

  vga_accel ( ACCEL_SETFGCOLOR, c );
  vga_accel ( ACCEL_FILLBOX, x1, y, x2-x1+1, 1 );

}

