
void fillbox_3bpp_p ( BITMAP *b, int x, int y, int w, int h, int c )
{
int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    int vp;
    int page;
    int i;
    c = RGB2BGR(c);
    vp = b->w * y * 3 + x * 3;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    if (RGBEQUAL(c)) {
        for (i = 0; i < h; i++) {
            if (vp + w * 3 > 0x10000)
                if (vp >= 0x10000) {
                    page++;
                    my_setpage(page);
                    vp &= 0xffff;
                } else {        /* Page break within line. */
                    __memset(b->data + vp, c, 0x10000 - vp);
                    page++;
                    my_setpage(page);
                    __memset(b->data, c, (vp + w * 3) & 0xffff);
                    vp = (vp + b->w * 3) & 0xffff;
                    continue;
                }
            __memset(b->data + vp, c, w * 3);
            vp += b->w * 3;
        }
    } else
        for (i = 0; i < h; i++) {
            if (vp + w * 3 > 0x10000)
                if (vp >= 0x10000) {
                    page++;
                    my_setpage(page);
                    vp &= 0xffff;
                } else {        /* Page break within line. */
                    int n, m, o;
                    n = (0x10000 - vp) / 3;
                    m = (0x10000 - vp) % 3;
                    __memset3(b->data + vp, c, n);
                    /* Handle page break within pixel. */
                    if (m >= 1)
                        *(b->data + vp + n * 3) = c;
                    if (m == 2)
                        *(b->data + vp + n * 3 + 1) = c >> 8;
                    page++;
                    my_setpage(page);
                    o = 0;
                    if (m == 2) {
                        *(b->data) = c >> 16;
                        o = 1;
                    }
                    if (m == 1) {
                        *(unsigned short *) (b->data) = c >> 8;
                        o = 2;
                    }
                    __memset3(b->data + o, c, ((vp + w * 3) & 0xffff) / 3);
                    vp = (vp + b->w * 3) & 0xffff;
                    continue;
                }
            __memset3(b->data + vp, c, w);
            vp += b->w * 3;
        }
}

}

