
void fillbox_1bpp_l ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

		{
                int i;
                unsigned char *vb = b->data;
                vb += y*b->w + x;
                for ( i=0; i<h; i++ ) {
                	__memset ( vb, c, w );
                	vb+=b->w;
		}
 		}
}


void fillbox_1bpp_p ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

    {
    int vp;
    int page;
    int i;
    vp = y * b->w + x;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    for (i = 0; i < h; i++) {
        if (vp + w > 0x10000)
            if (vp >= 0x10000) {
                page++;
                my_setpage(page);
                vp &= 0xffff;
            } else {            /* page break within line */
                __memset(b->data + vp, c, 0x10000 - vp);
                page++;
                my_setpage(page);
                __memset(b->data, c, (vp + w) & 0xffff);
                vp = (vp + b->w) & 0xffff;
                continue;
            }
        __memset(b->data + vp, c, w);
        vp += b->w;
    }
    }

}


void fillbox_2bpp_l ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

		{
                int i;
                unsigned char *vb = b->data;
                vb += y*b->w*2 + x*2;
                for ( i=0; i<h; i++ ) {
                	__memset2 ( vb, c, w );
                	vb+=b->w;
		}
 		}
}


void fillbox_2bpp_p ( BITMAP *b, int x, int y, int w, int h, int c )
{
int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    int vp;
    int page;
    int i;
    vp = b->w * y * 2 + x * 2;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    for (i = 0; i < h; i++) {
        if (vp + w * 2 > 0x10000)
            if (vp >= 0x10000) {
                page++;
                my_setpage(page);
                vp &= 0xffff;
            } else {            /* page break within line */
                __memset2(b->data + vp, c, (0x10000 - vp) / 2);
                page++;
                my_setpage(page);
                __memset2(b->data, c, ((vp + w * 2) & 0xffff) / 2);
                vp = (vp + b->w * 2) & 0xffff;
                continue;
            }
        __memset2(b->data + vp, c, w);
        vp += b->w * 2;
    }
}

}


void fillbox_3bpp_l ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    char *vp;
    int i, j;
    c = RGB2BGR(c);
    vp = b->data + y * b->w * 3 + x * 3;
    if (RGBEQUAL(c))
        for (i = 0; i < h; i++) {
            __memset(vp, c, w * 3);
            vp += b->w * 3;
    } else
        for (j = 0; j < h; j++) {
            __memset3(vp, c, w);
            vp += b->w * 3;
        }
}

}


void fillbox_3bpp_p ( BITMAP *b, int x, int y, int w, int h, int c )
{
int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    int vp;
    int page;
    int i;
    c = RGB2BGR(c);
    vp = b->w * y * 3 + x * 3;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    if (RGBEQUAL(c)) {
        for (i = 0; i < h; i++) {
            if (vp + w * 3 > 0x10000)
                if (vp >= 0x10000) {
                    page++;
                    my_setpage(page);
                    vp &= 0xffff;
                } else {        /* Page break within line. */
                    __memset(b->data + vp, c, 0x10000 - vp);
                    page++;
                    my_setpage(page);
                    __memset(b->data, c, (vp + w * 3) & 0xffff);
                    vp = (vp + b->w * 3) & 0xffff;
                    continue;
                }
            __memset(b->data + vp, c, w * 3);
            vp += b->w * 3;
        }
    } else
        for (i = 0; i < h; i++) {
            if (vp + w * 3 > 0x10000)
                if (vp >= 0x10000) {
                    page++;
                    my_setpage(page);
                    vp &= 0xffff;
                } else {        /* Page break within line. */
                    int n, m, o;
                    n = (0x10000 - vp) / 3;
                    m = (0x10000 - vp) % 3;
                    __memset3(b->data + vp, c, n);
                    /* Handle page break within pixel. */
                    if (m >= 1)
                        *(b->data + vp + n * 3) = c;
                    if (m == 2)
                        *(b->data + vp + n * 3 + 1) = c >> 8;
                    page++;
                    my_setpage(page);
                    o = 0;
                    if (m == 2) {
                        *(b->data) = c >> 16;
                        o = 1;
                    }
                    if (m == 1) {
                        *(unsigned short *) (b->data) = c >> 8;
                        o = 2;
                    }
                    __memset3(b->data + o, c, ((vp + w * 3) & 0xffff) / 3);
                    vp = (vp + b->w * 3) & 0xffff;
                    continue;
                }
            __memset3(b->data + vp, c, w);
            vp += b->w * 3;
        }
}

}


void fillbox_4bpp_l ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    char *vp;
    int i;
    vp = b->data + y * b->w * 4 + x * 4;
    for (i = 0; i < h; i++) {
        __memsetlong(vp, c, w);
        vp += b->w * 4;
    }
}


}


void fillbox_4bpp_p ( BITMAP *b, int x, int y, int w, int h, int c )
{
int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    int vp;
    int page;
    int i;
    vp = b->w * y * 4 + x * 4;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    for (i = 0; i < h; i++) {
        if (vp + w * 4 > 0x10000)
            if (vp >= 0x10000) {
                page++;
                my_setpage(page);
                vp &= 0xffff;
            } else {            /* page break within line */
                __memsetlong(b->data + vp, c, (0x10000 - vp) / 4);
                page++;
                my_setpage(page);
                __memsetlong(b->data, c, ((vp + w * 4) & 0xffff) / 4);
                vp = (vp + b->w * 4) & 0xffff;
                continue;
            }
        __memsetlong(b->data + vp, c, w);
        vp += b->w * 4;
    }
}

}


void fillbox_a ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;


 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

	vga_accel ( ACCEL_SETFGCOLOR, c );
	vga_accel ( ACCEL_FILLBOX, x, y, w, h );

}

