
#include <stdio.h>
#include <vga.h>
#include "mylib.h"
#include "driver.h"



void hline_1bpp_l (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

	__memset(b->data + y * b->w + x1 , c, x2 - x1 + 1);

}

void hline_1bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

   {
    int vp, p;
    int l;
    vp = y * b->w + x1;
    l = x2 - x1 + 1;
    p = vp>>16;
    my_setpage ( p );
    vp &= 0xffff;
    if ( vp + l > 0x10000 ) {
        __memset ( b->data + vp, c, 0x10000 - vp );
        my_setpage ( p+1 );
        __memset ( b->data, c, l - ( 0x10000 - vp ));
    }
    else
    __memset ( b->data + vp, c, l );
   }

}

void hline_2bpp_l (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;
 char *vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

    vp = b->data + y * b->w * 2 + x1 * 2;
    __memset2 ( vp, c, x2 - x1 + 1 );

}

#define SETWRITEPAGED(vp, rvp, chunksize, page, b) \
        page = vp >> 16; \
        my_setpage(page); \
        rvp = (vp & 0xffff) + b->data; \
        chunksize = 0x10000 - (vp & 0xffff);

void hline_2bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

{
    int vp;
    char *rvp;
    int l;
    int chunksize, page;
    vp = b->w * y * 2 + x1 * 2;
    SETWRITEPAGED(vp, rvp, chunksize, page, b);
    l = (x2 - x1 + 1) * 2;
    if (l <= chunksize)
        __memset2(rvp, c, l / 2);
    else {
        __memset2(rvp, c, chunksize / 2);
        my_setpage(page + 1);
        __memset2(b->data, c, (l - chunksize) / 2);
    }
}

}

void hline_3bpp_l (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;
 char *vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

    c = RGB2BGR(c);
    vp = b->data + b->w * y * 3 + x1 * 3;
    if (RGBEQUAL(c))
        __memset(vp, c, (x2 - x1 + 1) * 3);
    else
        __memset3(vp, c, x2 - x1 + 1);

}

void hline_3bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

{
    int vp;
    char *rvp;
    int l;
    int chunksize, page;
    c = RGB2BGR(c);
    vp = x1 * 3 + y * b->w * 3;
    SETWRITEPAGED(vp, rvp, chunksize, page, b);
    l = (x2 - x1 + 1) * 3;
    if (l <= chunksize)
        __memset3(rvp, c, l / 3);
    else {
        int n, m, o;
        n = chunksize / 3;
        m = chunksize % 3;
        __memset3(rvp, c, n);
        /* Handle page break within pixel. */
        if (m >= 1)
            *(rvp + n * 3) = c;
        if (m == 2)
            *(rvp + n * 3 + 1) = c >> 8;
        my_setpage(page + 1);
        o = 0;
        if (m == 2) {
            *(b->data) = c >> 16;
            o = 1;
        }
        if (m == 1) {
            *(unsigned short *) (b->data) = c >> 8;
            o = 2;
        }
        __memset3(b->data + o, c, (l - chunksize) / 3);
    }
}

}

void hline_4bpp_l (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;
 char *vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

    vp = b->data + y * b->w * 4 + x1 * 4;
    __memsetlong ( vp, c, x2 - x1 + 1 );

}

void hline_4bpp_p (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

{
    int vp;
    char *rvp;
    int l;
    int chunksize, page;
    vp = x1 * 4 + y * b->w * 4;
    SETWRITEPAGED(vp, rvp, chunksize, page, b);
    l = (x2 - x1 + 1) * 4;
    if (l <= chunksize)
        __memsetlong(rvp, c, l / 4);
    else {
        __memsetlong(rvp, c, chunksize / 4);
        my_setpage(page + 1);
        __memsetlong(b->data, c, (l - chunksize) / 4);
    }
}

}

void hline_a (BITMAP *b, int x1, int y, int x2, int c)
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
	cx += b->x;
	cy += b->y;
	x1 += b->x;
	x2 += b->x;
	y += b->y;
	b = b->mb;
 }

 if ( x1 >= cx + cw ) return;
 if ( x2 < cx ) return;
 if ( y < cy ) return;
 if ( y >= cy + ch ) return;
 if ( x2 >= cx + cw ) x2 = cw+cx-1;
 if ( x1 < cx ) x1 = cx;

  vga_accel ( ACCEL_SETFGCOLOR, c );
  vga_accel ( ACCEL_FILLBOX, x1, y, x2-x1+1, 1 );

}


int getpixel_1bpp_l ( BITMAP *b, int x, int y )
{

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

  return * ( b->data + y * b->w + x );

}

int getpixel_1bpp_p ( BITMAP *b, int x, int y )
{
 int vp;

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

	vp = y * b->w + x;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	return * ( b->data + vp );

}

int getpixel_2bpp_l ( BITMAP *b, int x, int y )
{

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

  return *(unsigned short*)( b->data + y * b->w * 2 + x * 2 );

}

int getpixel_2bpp_p ( BITMAP *b, int x, int y )
{
 int vp;

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

	vp = y * b->w * 2 + x * 2;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	return *(unsigned short *)( b->data + vp );

}

int getpixel_3bpp_l ( BITMAP *b, int x, int y )
{
 char *vp;

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

 vp = b->data + b->w * y * 3 + x * 3;
 return RGB2BGR (*(unsigned short*)vp+(*(unsigned char *)(vp+2)<<16));

}

int getpixel_3bpp_p ( BITMAP *b, int x, int y )
{
 int vp, vpo;
 char *vbuf;
 int page;

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

	vp = y * b->w * 3 + x * 3;
	vbuf = b->data;
    page = vp >> 16;
    my_setpage(page);
    vpo = vp & 0xffff;
    if (vpo <= 0xfffd)
        return RGB2BGR(*(unsigned short *) (vbuf + vpo) +
                       (*(unsigned char *) (vbuf + vpo + 2) << 16));
    else if (vpo == 0xfffe) {
        int c;
        c = *(unsigned short *) (vbuf + 0xfffe);
        my_setpage(page + 1);
        return RGB2BGR((*(unsigned char *) vbuf << 16) + c);
    } else {                    /* vpo == 0xffff */
        int c;
        c = *(unsigned char *) (vbuf + 0xffff);
        my_setpage(page + 1);
        return RGB2BGR((*(unsigned short *) vbuf << 8) + c);
    }

}

int getpixel_4bpp_l ( BITMAP *b, int x, int y )
{

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

  return *(unsigned int *)( b->data + y * b->w * 4 + x * 4 );

}

int getpixel_4bpp_p ( BITMAP *b, int x, int y )
{
 int vp;

 if ( x < 0 ) return 0;
 if ( y < 0 ) return 0;
 if ( x >= b->w ) return 0;
 if ( y >= b->h ) return 0;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

	vp = y * b->w * 4 + x * 4;
	my_setpage ( vp>>16 );
	return *(unsigned int *)( b->data + (vp&0xffff) );

}

void setpixel_1bpp_l ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

  * ( b->data + y * b->w + x ) = c;

}

void setpixel_1bpp_p ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  int vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        b = b->mb;
 }

	vp = y * b->w + x;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	* ( b->data + vp ) = c;
}

void setpixel_2bpp_l ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

  * ( unsigned short *) ( b->data + y * b->w * 2 + x*2 ) = c;

}

void setpixel_2bpp_p ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  int vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

	vp = y * b->w*2 + x*2;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	* (unsigned short *) (b->data + vp ) = c;
}

void setpixel_3bpp_l ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  unsigned char *vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

  c = RGB2BGR ( c );
  vp = b->data + y * b->w * 3 + x * 3;
  *(unsigned short *) vp = c;
  *(unsigned char *)(vp+2) = c>>16;

}

void setpixel_3bpp_p ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  char *vbuf;
  int page;
  int vp, vpo;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

    c = RGB2BGR(c);
    vp = y * b->w * 3 + x * 3;
    vbuf = b->data;
    page = vp >> 16;
    my_setpage(page);
    vpo = vp & 0xffff;
    if (vpo <= 0xfffd) {
        *(unsigned short *) (vbuf + vpo) = c;
        *(unsigned char *) (vbuf + vpo + 2) = c >> 16;
    } else if (vpo == 0xfffe) {
        *(unsigned short *) (vbuf + 0xfffe) = c;
        my_setpage(page + 1);
        *(unsigned char *) vbuf = c >> 16;
    } else {                    /* vpo == 0xffff */
        *(unsigned char *) (vbuf + 0xffff) = c;
        my_setpage(page + 1);
        *(unsigned short *) vbuf = c >> 8;
    }

}

void setpixel_4bpp_l ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  char *vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

 vp = b->data + y * b->w * 4 + x * 4;
 * ( unsigned int *) vp = c;

}

void setpixel_4bpp_p ( BITMAP *b, int x, int y, int c )
{
  int cx, cy, cw, ch;
  int vp;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 while ( b->mb != NULL ) {
        x+=b->x;
        y+=b->y;
        cx += b->x;
        cy += b->y;
        b = b->mb;
 }

 if ( x < cx ) return;
 if ( y < cy ) return;
 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;

	vp = y * b->w*4 + x*4;
	my_setpage ( vp>>16 );
	* (unsigned int *) (b->data + (vp & 0xffff) ) = c;
}

void _setpixel_1bpp_l ( BITMAP *b, int x, int y, int c )
{

  * ( b->data + y * b->w + x ) = c;

}

void _setpixel_1bpp_p ( BITMAP *b, int x, int y, int c )
{
  int vp;

	vp = y * b->w + x;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	* ( b->data + vp ) = c;
}

void _setpixel_2bpp_l ( BITMAP *b, int x, int y, int c )
{

  * ( unsigned short *) ( b->data + y * b->w * 2 + x*2 ) = c;

}

void _setpixel_2bpp_p ( BITMAP *b, int x, int y, int c )
{
  int vp;

	vp = y * b->w*2 + x*2;
	my_setpage ( vp>>16 );
	vp &= 0xffff;
	* (unsigned short *) (b->data + vp ) = c;
}

void _setpixel_3bpp_l ( BITMAP *b, int x, int y, int c )
{
  unsigned char *vp;

  c = RGB2BGR ( c );
  vp = b->data + y * b->w * 3 + x * 3;
  *(unsigned short *) vp = c;
  *(unsigned char *)(vp+2) = c>>16;

}

void _setpixel_3bpp_p ( BITMAP *b, int x, int y, int c )
{
  char *vbuf;
  int page;
  int vp, vpo;

    c = RGB2BGR(c);
    vp = y * b->w * 3 + x * 3;
    vbuf = b->data;
    page = vp >> 16;
    my_setpage(page);
    vpo = vp & 0xffff;
    if (vpo <= 0xfffd) {
        *(unsigned short *) (vbuf + vpo) = c;
        *(unsigned char *) (vbuf + vpo + 2) = c >> 16;
    } else if (vpo == 0xfffe) {
        *(unsigned short *) (vbuf + 0xfffe) = c;
        my_setpage(page + 1);
        *(unsigned char *) vbuf = c >> 16;
    } else {                    /* vpo == 0xffff */
        *(unsigned char *) (vbuf + 0xffff) = c;
        my_setpage(page + 1);
        *(unsigned short *) vbuf = c >> 8;
    }

}

void _setpixel_4bpp_l ( BITMAP *b, int x, int y, int c )
{
  char *vp;

 vp = b->data + y * b->w * 4 + x * 4;
 * ( unsigned int *) vp = c;

}

void _setpixel_4bpp_p ( BITMAP *b, int x, int y, int c )
{
  int vp;

	vp = y * b->w*4 + x*4;
	my_setpage ( vp>>16 );
	* (unsigned int *) (b->data + (vp & 0xffff) ) = c;
}



void fillbox_1bpp_l ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

		{
                int i;
                unsigned char *vb = b->data;
                vb += y*b->w + x;
                for ( i=0; i<h; i++ ) {
                	__memset ( vb, c, w );
                	vb+=b->w;
		}
 		}
}


void fillbox_1bpp_p ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

    {
    int vp;
    int page;
    int i;
    vp = y * b->w + x;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    for (i = 0; i < h; i++) {
        if (vp + w > 0x10000)
            if (vp >= 0x10000) {
                page++;
                my_setpage(page);
                vp &= 0xffff;
            } else {            /* page break within line */
                __memset(b->data + vp, c, 0x10000 - vp);
                page++;
                my_setpage(page);
                __memset(b->data, c, (vp + w) & 0xffff);
                vp = (vp + b->w) & 0xffff;
                continue;
            }
        __memset(b->data + vp, c, w);
        vp += b->w;
    }
    }

}


void fillbox_2bpp_l ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

		{
                int i;
                unsigned char *vb = b->data;
                vb += y*b->w*2 + x*2;
                for ( i=0; i<h; i++ ) {
                	__memset2 ( vb, c, w );
                	vb+=b->w;
		}
 		}
}


void fillbox_2bpp_p ( BITMAP *b, int x, int y, int w, int h, int c )
{
int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    int vp;
    int page;
    int i;
    vp = b->w * y * 2 + x * 2;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    for (i = 0; i < h; i++) {
        if (vp + w * 2 > 0x10000)
            if (vp >= 0x10000) {
                page++;
                my_setpage(page);
                vp &= 0xffff;
            } else {            /* page break within line */
                __memset2(b->data + vp, c, (0x10000 - vp) / 2);
                page++;
                my_setpage(page);
                __memset2(b->data, c, ((vp + w * 2) & 0xffff) / 2);
                vp = (vp + b->w * 2) & 0xffff;
                continue;
            }
        __memset2(b->data + vp, c, w);
        vp += b->w * 2;
    }
}

}


void fillbox_3bpp_l ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    char *vp;
    int i, j;
    c = RGB2BGR(c);
    vp = b->data + y * b->w * 3 + x * 3;
    if (RGBEQUAL(c))
        for (i = 0; i < h; i++) {
            __memset(vp, c, w * 3);
            vp += b->w * 3;
    } else
        for (j = 0; j < h; j++) {
            __memset3(vp, c, w);
            vp += b->w * 3;
        }
}

}


void fillbox_3bpp_p ( BITMAP *b, int x, int y, int w, int h, int c )
{
int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    int vp;
    int page;
    int i;
    c = RGB2BGR(c);
    vp = b->w * y * 3 + x * 3;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    if (RGBEQUAL(c)) {
        for (i = 0; i < h; i++) {
            if (vp + w * 3 > 0x10000)
                if (vp >= 0x10000) {
                    page++;
                    my_setpage(page);
                    vp &= 0xffff;
                } else {        /* Page break within line. */
                    __memset(b->data + vp, c, 0x10000 - vp);
                    page++;
                    my_setpage(page);
                    __memset(b->data, c, (vp + w * 3) & 0xffff);
                    vp = (vp + b->w * 3) & 0xffff;
                    continue;
                }
            __memset(b->data + vp, c, w * 3);
            vp += b->w * 3;
        }
    } else
        for (i = 0; i < h; i++) {
            if (vp + w * 3 > 0x10000)
                if (vp >= 0x10000) {
                    page++;
                    my_setpage(page);
                    vp &= 0xffff;
                } else {        /* Page break within line. */
                    int n, m, o;
                    n = (0x10000 - vp) / 3;
                    m = (0x10000 - vp) % 3;
                    __memset3(b->data + vp, c, n);
                    /* Handle page break within pixel. */
                    if (m >= 1)
                        *(b->data + vp + n * 3) = c;
                    if (m == 2)
                        *(b->data + vp + n * 3 + 1) = c >> 8;
                    page++;
                    my_setpage(page);
                    o = 0;
                    if (m == 2) {
                        *(b->data) = c >> 16;
                        o = 1;
                    }
                    if (m == 1) {
                        *(unsigned short *) (b->data) = c >> 8;
                        o = 2;
                    }
                    __memset3(b->data + o, c, ((vp + w * 3) & 0xffff) / 3);
                    vp = (vp + b->w * 3) & 0xffff;
                    continue;
                }
            __memset3(b->data + vp, c, w);
            vp += b->w * 3;
        }
}

}


void fillbox_4bpp_l ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    char *vp;
    int i;
    vp = b->data + y * b->w * 4 + x * 4;
    for (i = 0; i < h; i++) {
        __memsetlong(vp, c, w);
        vp += b->w * 4;
    }
}


}


void fillbox_4bpp_p ( BITMAP *b, int x, int y, int w, int h, int c )
{
int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;

 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

{
    int vp;
    int page;
    int i;
    vp = b->w * y * 4 + x * 4;
    page = vp >> 16;
    vp &= 0xffff;
    my_setpage(page);
    for (i = 0; i < h; i++) {
        if (vp + w * 4 > 0x10000)
            if (vp >= 0x10000) {
                page++;
                my_setpage(page);
                vp &= 0xffff;
            } else {            /* page break within line */
                __memsetlong(b->data + vp, c, (0x10000 - vp) / 4);
                page++;
                my_setpage(page);
                __memsetlong(b->data, c, ((vp + w * 4) & 0xffff) / 4);
                vp = (vp + b->w * 4) & 0xffff;
                continue;
            }
        __memsetlong(b->data + vp, c, w);
        vp += b->w * 4;
    }
}

}


void fillbox_a ( BITMAP *b, int x, int y, int w, int h, int c )
{
 int cx, cy, cw, ch;

 cx = b->cx;
 cy = b->cy;
 cw = b->cw;
 ch = b->ch;

 if ( x >= cx + cw ) return;
 if ( y >= cy + ch ) return;
 if ( x + w <= cx ) return;
 if ( y + h <= cy ) return;

 if ( x < cx ) { w = w - (cx - x); x = cx; }
 if ( y < cy ) { h = h - (cy - y); y = cy; }
 if ( x + w > cx + cw ) w = cx + cw - x;
 if ( y + h > cy + ch ) h = cy + ch - y;


 while ( b->mb != NULL ) {
	x+=b->x;
	y+=b->y;
	b = b->mb;
 }

	vga_accel ( ACCEL_SETFGCOLOR, c );
	vga_accel ( ACCEL_FILLBOX, x, y, w, h );

}

