
/* One of the most sucking h-files I'v ever written */

#include <stdio.h>

struct BITMAP;

typedef struct my_gfx_driver {
	int BPP;
	void (*_setpixel)(struct BITMAP *, int, int, int);
	void (*setpixel)(struct BITMAP *, int, int, int);
	int (*getpixel)(struct BITMAP *, int, int);
	void (*hline)(struct BITMAP *, int, int, int, int );
	void (*fillbox)(struct BITMAP *, int, int, int, int, int );
}my_gfx_driver;

/***************************************************************************/
/* Fonts funcs block                                                        */
/***************************************************************************/
/* FONTS DO NOT WORK YET! */

typedef struct FONT {
	char	*l[256];
	int	w;
	int	h;
} FONT;

/***************************************************************************/
/* Math funcs block                                                        */
/***************************************************************************/

void my_math_init ( void );

extern double COS[360];
extern double SIN[360];
extern int FSIN[360];
extern int FCOS[360];
extern int FACOS[1000];
/* extern int FROT[201][360][2]; */

/***************************************************************************/
/* Init funcs block                                                        */
/***************************************************************************/

void my_init ( void );

/***************************************************************************/
/* Timer funcs block                                                       */
/***************************************************************************/

#define MAX_TIMERS		10

int my_install_timer ( void );
int my_remove_timer ( void );
int my_install_int ( void (*)(), int );
int my_remove_int ( void (*)() );
int my_is_timer_installed ( void );
int my_is_int_installed ( void (*)() );
int my_set_int_speed ( void (*)(), int );
int my_timer_count ( void );
void my_usleep ( int );
void my_sleep ( int );
void my_donothing ( void );

extern int timer_counter;

/***************************************************************************/
/* Keyboard funcs block                                                    */
/***************************************************************************/

int my_install_keyboard ( void );
void my_remove_keyboard ( void );
void my_clear_keypresses ( void );
void my_set_key ( int );
void my_unset_key ( int );
int my_anypressed ( void );
int my_getkey ( void );
int my_is_pressed ( int );
int my_readkey ( void );
void my_clear_keybuff ();
int my_keypressed ( void );

extern char key[128];
extern char *keynames[128];
extern char key_ascii_table[128];
extern char key_shift_table[128];

#define KEY_ESCAPE			1

#define KEY_1				2
#define KEY_2				3
#define KEY_3				4
#define KEY_4				5
#define KEY_5				6
#define KEY_6				7
#define KEY_7				8
#define KEY_8				9
#define KEY_9				10
#define KEY_0				11

#define KEY_MINUS			12
#define KEY_EQUAL			13

#define KEY_BACKSPACE			14
#define KEY_TAB				15

#define KEY_Q				16
#define KEY_W				17
#define KEY_E				18
#define KEY_R				19
#define KEY_T				20
#define KEY_Y				21
#define KEY_U				22
#define KEY_I				23
#define KEY_O				24
#define KEY_P				25
#define KEY_BRACKET_LEFT		26
#define KEY_BRACKET_RIGHT		27

#define KEY_ENTER			28

#define KEY_LEFTCONTROL			29

#define KEY_A				30
#define KEY_S				31
#define KEY_D				32
#define KEY_F				33
#define KEY_G				34
#define KEY_H				35
#define KEY_J				36
#define KEY_K				37
#define KEY_L				38
#define KEY_SEMICOLON			39
#define KEY_APOSTROPHE			40
#define KEY_GRAVE			41

#define KEY_LEFTSHIFT			42
#define KEY_BACKSLASH			43

#define KEY_Z				44
#define KEY_X				45
#define KEY_C				46
#define KEY_V				47
#define KEY_B				48
#define KEY_N				49
#define KEY_M				50
#define KEY_COMMA			51
#define KEY_PERIOD			52
#define KEY_SLASH			53

#define KEY_RIGHTSHIFT			54
#define KEY_KEYPADMULTIPLY		55

#define KEY_LEFTALT			56
#define KEY_SPACE			57
#define KEY_CAPSLOCK			58

#define KEY_F1				59
#define KEY_F2				60
#define KEY_F3				61
#define KEY_F4				62
#define KEY_F5				63
#define KEY_F6				64
#define KEY_F7				65
#define KEY_F8				66
#define KEY_F9				67
#define KEY_F10				68

#define KEY_NUMLOCK			69
#define KEY_SCROLLLOCK			70

#define KEY_KEYPAD7			71
#define KEY_CURSORUPLEFT		71
#define KEY_KEYPAD8			72
#define KEY_CURSORUP			72
#define KEY_KEYPAD9			73
#define KEY_CURSORUPRIGHT		73
#define KEY_KEYPADMINUS			74
#define KEY_KEYPAD4			75
#define KEY_CURSORLEFT			75
#define KEY_KEYPAD5			76
#define KEY_KEYPAD6			77
#define KEY_CURSORRIGHT			77
#define KEY_KEYPADPLUS			78
#define KEY_KEYPAD1			79
#define KEY_CURSORDOWNLEFT		79
#define KEY_KEYPAD2			80
#define KEY_CURSORDOWN			80
#define KEY_KEYPAD3			81
#define KEY_CURSORDOWNRIGHT		81
#define KEY_KEYPAD0			82
#define KEY_KEYPADPERIOD		83

#define KEY_LESS			86

#define KEY_F11				87
#define KEY_F12				88

#define KEY_KEYPADENTER			96
#define KEY_RIGHTCONTROL		97
#define KEY_CONTROL			97
#define KEY_KEYPADDIVIDE		98
#define KEY_PRINTSCREEN			99
#define KEY_RIGHTALT			100
#define KEY_BREAK			101	/* Beware: is 119     */
#define KEY_BREAK_ALTERNATIVE		119	/* on some keyboards! */

#define KEY_HOME			102
#define KEY_CURSORBLOCKUP		103	/* Cursor key block */
#define KEY_PAGEUP			104
#define KEY_CURSORBLOCKLEFT		105	/* Cursor key block */
#define KEY_CURSORBLOCKRIGHT		106	/* Cursor key block */
#define KEY_END				107
#define KEY_CURSORBLOCKDOWN		108	/* Cursor key block */
#define KEY_PAGEDOWN			109
#define KEY_INSERT			110
#define KEY_REMOVE			111

/***************************************************************************/
/* Palette funcs block                                                     */
/***************************************************************************/

typedef struct RGB {
	char r,g,b;
}RGB;

typedef RGB PALETTE[256];

void my_vsync ( void );
void my_set_color ( int, RGB * );
void my_get_color ( int, RGB * );
void my_set_palette ( PALETTE );
void my_get_palette ( PALETTE );
void my_set_palette_range ( PALETTE, int, int );
void my_get_palette_range ( PALETTE, int, int );
void my_fade_out ( int );
void my_fade_to ( PALETTE, int );

/***************************************************************************/
/* Graphics funcs block                                                    */
/***************************************************************************/

#define TEXT_MODE	0
#define USE_SVGALIB	1
#define USE_VESA2	2
#define AUTODETECT	3

#define BITMAP_MEMORY	0
#define BITMAP_GR	1
#define BITMAP_SUB	3

#define M_256_COLORS	"256"
#define M_32K_COLORS	"32K"
#define M_64K_COLORS	"64K"
#define M_16M_COLORS	"16M"
#define M_4BPP_COLORS	"16M32"

typedef struct BITMAP {
	unsigned char *data;
	int	w;
	int	h;
	int	type;
	int	cx;
	int	cy;
	int	cw;
	int	ch;
	struct	BITMAP	*mb;
	int	x;
	int	y;
	my_gfx_driver	*gfx;
} BITMAP;

typedef struct CBITMAP {		/* Compiled/compressed bitmap */
	unsigned char *data;
	int	w;
	int	h;
	int	size;
} CBITMAP;

typedef struct POLYG {
	int	c;
	int	*x;
	int	*y;
} POLYG;

typedef struct D3POLYG {
	int	c;
	int	*x;
	int	*y;
	int	*z;
	int	n1;
	int	n2;
	int	n3;
} D3POLYG;

typedef struct D3OBJ {
	int	n;
	D3POLYG	**p;
} D3OBJ;

extern BITMAP *SCREEN;
extern BITMAP *GRAPHICS;
extern int WIDTH;
extern int HEIGHT;
extern int VWIDTH;
extern int VHEIGHT;
extern int PAGE;
extern int FILLBOXACCEL;
extern int COPYSCREENACCEL;

int my_set_gfx_mode ( int, int, int, int, char * );
void my_text_mode ( void );
BITMAP * my_create_bitmap ( int, int );
void my_destroy_bitmap ( BITMAP * );
void my_destroy_cbitmap ( CBITMAP * );
int my_setlinearaddresing ( void );
BITMAP * my_create_sub_bitmap ( BITMAP *, int, int, int, int );
void my_set_bitmap_cliping ( BITMAP *, int, int, int, int );
void my_scroll_screen ( int, int );

void my_line ( BITMAP *, int, int, int, int, int );

/*
void my_fillbox ( BITMAP *, int, int, int, int, int );
void _my_setpixel ( BITMAP *, int, int, int );
void my_setpixel ( BITMAP *, int, int, int );
void my_hline ( BITMAP *, int, int, int, int );
int my_getpixel ( BITMAP *, int, int );
*/

#define _my_setpixel(bmp,x,y,c) bmp->gfx->_setpixel(bmp,x,y,c)
#define my_setpixel(bmp,x,y,c) bmp->gfx->setpixel(bmp,x,y,c)
#define my_getpixel(bmp,x,y) bmp->gfx->getpixel(bmp,x,y)
#define my_hline(bmp,x1,y,x2,c) bmp->gfx->hline(bmp,x1,y,x2,c)
#define my_fillbox(bmp,x,y,w,h,c) bmp->gfx->fillbox(bmp,x,y,w,h,c)

POLYG * my_create_polyg ( int , int *, int *);
void my_destroy_polyg ( POLYG * );
void my_draw_polyg ( BITMAP *, POLYG *, int );

void my_copy_bitmap ( BITMAP *, BITMAP *, int, int, int, int, int, int );
void my_copy_mbitmap ( BITMAP *, BITMAP *, int, int, int, int, int, int );
void my_put_bitmap ( BITMAP *, BITMAP *, int, int );
void my_put_mbitmap ( BITMAP *, BITMAP *, int, int );
BITMAP * my_rotate_bitmap ( BITMAP *, int, int, int );
int _my_getpixel ( BITMAP *, int, int );
BITMAP * my_scale_bitmap ( BITMAP *, int, int );
CBITMAP * my_compile_bitmap ( BITMAP * );
int my_cbitmap_size ( BITMAP * );
void my_put_cbitmap ( BITMAP *, CBITMAP *, int, int );

static inline void *
 __memsetlong(void *s, unsigned c, size_t count)
{
    __asm__("cld\n\t"
            "rep\n\t"
            "stosl"
  : :       "a"(c), "D"(s), "c"(count)
  :         "cx", "di");
    return s;
}

static inline void *
 __memset3(void *s, int c, size_t count)
/* count is in 24-bit pixels (3 bytes per pixel) */
{
    __asm__(
               "cmpl $8,%%edx\n\t"
    /*      "jmp 2f\n\t" *//* debug */
               "jl 2f\n\t"

               "movl %%eax,%%ebx\n\t"   /* eax = (low) BGR0 (high) */
               "shll $24,%%ebx\n\t"     /* ebx = 000B */
               "orl %%ebx,%%eax\n\t"    /* eax = BGRB */

               "movl %%eax,%%ebx\n\t"
               "shrl $8,%%ebx\n\t"      /* ebx = GRB0 */
               "movl %%ebx,%%ecx\n\t"
               "shll $24,%%ecx\n\t"     /* ecx = 000G */
               "orl %%ecx,%%ebx\n\t"    /* ebx = GRBG */

               "movl %%eax,%%ecx\n\t"
               "shll $8,%%ecx\n\t"      /* ecx = 0BGR */
               "movb %%bh,%%cl\n\t"     /* ecx = RBGR */
               "cmpl $16,%%edx\n\t"
               "jl 1f\n\t"
               "jmp 5f\n\t"
               ".align 4,0x90\n\t"

               "5:\n\t"         /* loop unrolling */
               "movl %%eax,(%%edi)\n\t"         /* write BGRB */
               "movl %%ebx,4(%%edi)\n\t"        /* write GRBG */
               "movl %%ecx,8(%%edi)\n\t"        /* write RBGR */
               "movl %%eax,12(%%edi)\n\t"
               "movl %%ebx,16(%%edi)\n\t"
               "movl %%ecx,20(%%edi)\n\t"
               "movl %%eax,24(%%edi)\n\t"
               "movl %%ebx,28(%%edi)\n\t"
               "movl %%ecx,32(%%edi)\n\t"
               "movl %%eax,36(%%edi)\n\t"
               "subl $16,%%edx\n\t"     /* blend end-of-loop instr. */
               "movl %%ebx,40(%%edi)\n\t"
               "movl %%ecx,44(%%edi)\n\t"
               "addl $48,%%edi\n\t"
               "cmpl $16,%%edx\n\t"
               "jge 5b\n\t"
               "andl %%edx,%%edx\n\t"
               "jz 4f\n\t"      /* finished */
               "cmpl $4,%%edx\n\t"
               "jl 2f\n\t"      /* less than 4 pixels left */
               "jmp 1f\n\t"
               ".align 4,0x90\n\t"

               "1:\n\t"
               "movl %%eax,(%%edi)\n\t"         /* write BGRB */
               "movl %%ebx,4(%%edi)\n\t"        /* write GRBG */
               "movl %%ecx,8(%%edi)\n\t"        /* write RBGR */
               "addl $12,%%edi\n\t"
               "subl $4,%%edx\n\t"
               "cmpl $4,%%edx\n\t"
               "jge 1b\n\t"

               "2:\n\t"
               "cmpl $0,%%edx\n\t"      /* none left? */
               "jle 4f\n\t"     /* finished */

               "mov %%eax,%%ecx\n\t"
               "shrl $16,%%ecx\n\t"     /* B in cl */

               "3:\n\t"         /* write last few pixels */
               "movw %%ax,(%%edi)\n\t"  /* write RG */
               "movb %%cl,2(%%edi)\n\t"         /* write B */
               "addl $3,%%edi\n\t"
               "decl %%edx\n\t"
               "jnz 3b\n\t"

               "4:\n\t"
  : :          "a"(c), "D"(s), "d"(count)
  :            "ax", "bx", "cx", "dx", "di");
    return s;
}

static inline void *
 __memset2(void *s, short c, size_t count)
/* count is in 16-bit pixels */
/* s is assumed to be 16-bit aligned */
{
    __asm__(
               "cld\n\t"
               "cmpl $12,%%edx\n\t"
               "jl 1f\n\t"      /* if (count >= 12) */

               "movzwl %%ax,%%eax\n\t"
               "movl %%eax,%%ecx\n\t"
               "shll $16,%%ecx\n\t"     /* c |= c << 16 */
               "orl %%ecx,%%eax\n\t"

               "movl %%edi,%%ecx\n\t"
               "andl $2,%%ecx\n\t"      /* s & 2 */
               "jz 2f\n\t"
               "decl %%edx\n\t" /* count -= 1 */
               "stosw\n\t"      /* align to longword boundary */

               "2:\n\t"
               "movl %%edx,%%ecx\n\t"
               "shrl $1,%%ecx\n\t"
               "rep ; stosl\n\t"        /* fill longwords */

               "andl $1,%%edx\n"        /* one 16-bit word left? */
               "jz 3f\n\t"      /* no, finished */
               "1:\tmovl %%edx,%%ecx\n\t"       /* <= 12 entry point */
               "rep ; stosw\n\t"
               "3:\n\t"
  : :          "a"(c), "D"(s), "d"(count)
  :            "ax", "cx", "dx", "di");
    return s;
}



static inline void *
 __memcpy(void *to, const void *from, size_t n)
{
    __asm__("cld\n\t"
            "movl %%edi,%%ecx\n\t"
            "andl $1,%%ecx\n\t"
            "subl %%ecx,%%edx\n\t"
            "rep ; movsb\n\t"   /* 16-bit align destination */
            "movl %%edx,%%ecx\n\t"
            "shrl $2,%%ecx\n\t"
            "rep ; movsl\n\t"
            "testb $1,%%dl\n\t"
            "je 1f\n\t"
            "movsb\n"
            "1:\ttestb $2,%%dl\n\t"
            "je 2f\n\t"
            "movsw\n"
            "2:\n"
  : :       "d"(n), "D"((long) to), "S"((long) from)
  :         "cx", "dx", "di", "si");
    return (to);
}

static inline void *
 __memcpyb(void *to, const void *from, size_t n)
{
    __asm__("cld\n\t"
            "rep ; movsb\n\t"
  : :       "c"(n), "D"((long) to), "S"((long) from)
  :         "cx", "di", "si");
    return (to);
}

static inline void *__memcpyf ( void * dest, void * src, long size )
{
 __asm__ __volatile__ ("
        movl    %%ecx, %%eax
        andl    $0xFFFFFFFC, %%ecx
        shr     $2, %%ecx
        rep;    movsl
        movl    %%eax, %%ecx
        andl    $3, %%ecx
        rep;    movsb"
        : : "S" ((unsigned long)src), "D" ((unsigned long)dest), "c" (size)
        : "esi", "edi", "ecx", "eax" );
 return dest;
}

static inline void *__memsetf ( void * dest, char c, long size )
{
 __asm__ __volatile__ ("
        movl    %%ecx, %%edx
        andl    $0xFFFFFFFC, %%ecx
        shr     $2, %%ecx
        rep;    stosl
        movl    %%edx, %%ecx
        andl    $3, %%ecx
        rep;    stosb"
        : : "D" ((unsigned long)dest), "b" ((unsigned long)c), "c" (size)
        : "edi", "ecx", "eax", "edx" );
 return dest;
}

static inline void *
__mymemcpy(void *to, const void *from, size_t n)
{
    __asm__(
	   "cld\n\t"
	   "2: cmpb $0, 0(%%esi)\n\t"
	   "je 1f\n\t"
	   "movb 0(%%esi), %%eax\n\t"
	   "movb %%eax, 0(%%edi)\n\t"
	   "1: incl %%esi\n\t"
	   "incl %%edi\n\t"
	   "decl %%ecx\n\t"
	   "jnz 2b\n\t"
  : :       "c"(n), "D"((long) to), "S"((long) from)
  :         "cx", "di", "si");
    return (to);
}


static inline void *
 __bzero(void *what, size_t n)
{
    __asm__("cld\n\t"
            "movl $0, %%eax\n\t"
            "rep ; stosl\n\t"
  : :       "c"(n), "D"((long) what)
  :         "cx", "di", "si");
return what;
}

static inline void *
 __memset(void *s, char c, size_t count)
{
    __asm__(
	       "cld\n\t"
	       "cmpl $12,%%edx\n\t"
	       "jl 1f\n\t"	/* if (count >= 12) */

	       "movzbl %%al,%%ax\n\t"
	       "movl %%eax,%%ecx\n\t"
	       "shll $8,%%ecx\n\t"	/* c |= c << 8 */
	       "orl %%ecx,%%eax\n\t"
	       "movl %%eax,%%ecx\n\t"
	       "shll $16,%%ecx\n\t"	/* c |= c << 16 */
	       "orl %%ecx,%%eax\n\t"

	       "movl %%edx,%%ecx\n\t"
	       "negl %%ecx\n\t"
	       "andl $3,%%ecx\n\t"	/* (-s % 4) */
	       "subl %%ecx,%%edx\n\t"	/* count -= (-s % 4) */
	       "rep ; stosb\n\t"	/* align to longword boundary */

	       "movl %%edx,%%ecx\n\t"
	       "shrl $2,%%ecx\n\t"
	       "rep ; stosl\n\t"	/* fill longwords */

	       "andl $3,%%edx\n"	/* fill last few bytes */
	       "1:\tmovl %%edx,%%ecx\n\t"	/* <= 12 entry point */
	       "rep ; stosb\n\t"
  : :	       "a"(c), "D"(s), "d"(count)
  :	       "ax", "cx", "dx", "di");
    return s;
}

#define __my_setpixel(b,x,y,c) *( b->data + y * b->w + x) = c
#define __my_getpixel(b,x,y) *( b->data + y * b->w + x)

void vga_setpage ( int );

static inline void my_setpage ( int P )
{
 if ( P!= PAGE ) {
	vga_setpage ( P );
	PAGE = P;
 }
}

/***************************************************************************/
/* Mouse funcs block                                                       */
/***************************************************************************/

#define BUTTON_LEFT	1
#define BUTTON_RIGHT	2
#define BUTTON_MIDDLE	4

int my_install_mouse ( void );
void my_remove_mouse ( void );
void my_position_mouse ( int, int );
void my_set_mouse_range ( int, int, int, int );
void my_set_mouse_speed ( int );
int my_is_mouse_installed ( void );
void my_show_mouse_pointer ( void );
void my_hide_mouse_pointer ( void );
void my_set_mouse_pointer ( BITMAP *, int, int );

extern int mouse_x;
extern int mouse_y;
extern int mouse_b;
extern unsigned char mouse_pointer_data[256];


