
#include <mylib.h>
#include <stdlib.h>

void linetest ( void );
void hlinetest ( void );
void boxtest ( void );
void bitmtest ( void );
void cbitmtest ( void );
void scaletest ( void );
void rottest ( void );

int main ()
{
 my_init ();
 my_set_gfx_mode ( AUTODETECT, 640, 480, 0, M_256_COLORS );
  linetest();
 getchar ();
  hlinetest ();
 getchar ();
  boxtest();
 getchar ();
  bitmtest ();
 getchar ();
  cbitmtest ();
 getchar ();
 my_set_bitmap_cliping ( SCREEN, 100, 50, 200, 120 );
  linetest();
 getchar ();
  hlinetest ();
 getchar ();
  boxtest();
 getchar ();
  bitmtest ();
 getchar ();
  cbitmtest ();
 getchar ();
 my_set_bitmap_cliping ( SCREEN, 0, 0, WIDTH, HEIGHT );
  scaletest ();
 getchar ();
  rottest ();
 getchar ();
 my_text_mode ();
 return 0;
}

void linetest ()
{
 int i;

  for ( i=0; i<10000; i++ ) {
   my_line ( SCREEN, random()%WIDTH, random()%HEIGHT, random()%WIDTH, random()%HEIGHT, random()%256 );
  }
}

void hlinetest ()
{
 int i, x;
  for ( i=0; i<10000; i++ ) {
   x = random () %(WIDTH-10);
   my_hline ( SCREEN, x, random()%HEIGHT, x + random()%(WIDTH-x-1), random()%256 );
  }
}

void boxtest ()
{
 int i,x,y;
  for ( i=0; i<1000; i++ ) {
   x = random () %(WIDTH-10);
   y = random () %(HEIGHT-10);
   my_fillbox ( SCREEN, x, y, 1 + random()%(WIDTH - x - 2), 1 + random()%(HEIGHT - y - 2), random()%256 );
  }
}

void bitmtest ()
{
 BITMAP *bmp;
 int i;

 bmp = my_create_bitmap ( 100, 100 );
  for ( i=0; i<1000; i++ )
    my_fillbox ( bmp, random()%100, random()%100, 10, 10, random()%256 );
 for ( i=0; i<1000; i++ ) {
  my_put_bitmap ( SCREEN, bmp, -50 + random ()%(WIDTH+50) , -50 + random ()%(HEIGHT+50) );
 }
 my_destroy_bitmap ( bmp );
}

void cbitmtest ()
{
 BITMAP *bmp;
 CBITMAP *cbmp;
 int i;

 bmp = my_create_bitmap ( 100, 100 );
  for ( i=0; i<100; i++ )
    my_fillbox ( bmp, random()%100, random()%100, 10, 10, random()%256 );
  cbmp = my_compile_bitmap ( bmp );
 for ( i=0; i<1000; i++ ) {
  int x,y;
  x = -50 + random ()%(WIDTH+50);
  y = -50 + random ()%(HEIGHT+50);
  my_put_cbitmap ( SCREEN, cbmp, x , y );
 }
 my_destroy_bitmap ( bmp );
 my_destroy_cbitmap (cbmp);
}

void scaletest ()
{
 BITMAP *bmp;
 BITMAP *sbmp;
 int i;

  bmp = my_create_bitmap ( 100, 100 );

   for ( i=0; i<100; i++ )
    my_fillbox ( bmp, random()%100, random()%100, 10, 10, random()%256 );

  for ( i=1; i<HEIGHT; i++ ) {
   sbmp = my_scale_bitmap ( bmp, i, i );
   my_put_bitmap ( SCREEN, sbmp, 0, 0 );
   my_destroy_bitmap ( sbmp );
  }

 my_destroy_bitmap ( bmp );

}

void rottest ()
{
 BITMAP *bmp;
 BITMAP *sbmp;
 int i;

  bmp = my_create_bitmap ( 100, 100 );

   for ( i=0; i<100; i++ )
    my_fillbox ( bmp, random()%100, random()%100, 10, 10, random()%256 );

  for ( i=0; i<360; i++ ) {
   sbmp = my_rotate_bitmap ( bmp, i, 50, 50 );
   my_put_bitmap ( SCREEN, sbmp, -50 + (WIDTH>>1), -50 + (HEIGHT>>1) );
   my_destroy_bitmap ( sbmp );
  }

}

