
#include <mylib.h>
#include <stdlib.h>

#include "map.h"
#include "datafile.h"
#include "defines.h"
#include "game.h"

BITMAP **tiles;
int TILES_N;
unsigned short *image;
int MAX_X;
int MAX_Y;

void load_map ( char *fname )
{
 struct TILETABLE tile;
 struct DATAFILE dat;
 FILE *fl;
 int i;

 fl = fopen (fname, "rb");

   fread (&dat, sizeof ( struct DATAFILE ), 1, fl );

   tiles = malloc ( 4 * 1024 );

   for ( i=0; i<dat.tiles; i++ ) {
     fread ( &tile, sizeof ( struct TILETABLE ), 1, fl );
     load_tile ( tile.name, tile.onmap );
   }

   image = malloc ( sizeof (short) * dat.mapx * dat.mapy );

   fread ( image, dat.mapx*dat.mapy*sizeof (short), 1, fl );

   MAX_X = dat.mapx;
   MAX_Y = dat.mapy;

 fclose (fl);

}

void load_tile (char *fname, int nr )
{
 char s[1024];
 FILE *fl;

 *(tiles + nr ) = my_create_bitmap ( 50, 50 );

 sprintf ( s, "%s%s", TILEDIR, fname );
 if ( ( fl = fopen ( s, "rb" ) ) == NULL ) perror ("load_title: fopen");
    fread ( (*(tiles + nr))->data, 50 * 50, 1, fl );
 fclose (fl);

}

